/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view;

import gama.core.runtime.PlatformHelper;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.navigator.view.GamaNavigator;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedGamaFile;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.swt.IFocusService;

public class NavigatorSearchControl {
    Text find;
    private static final String EMPTY = "Find model...";
    String pattern;
    GamaNavigator navigator;
    CommonViewer treeViewer;
    private Object[] expandedElementsBeforeSearch = null;
    final NamePatternFilter filter = new NamePatternFilter();
    UIJob resetJob = new UIJob("Reset"){

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            NavigatorSearchControl.this.resetSearch();
            return Status.OK_STATUS;
        }
    };
    UIJob searchJob = new UIJob("Search"){

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            NavigatorSearchControl.this.doSearch();
            return Status.OK_STATUS;
        }
    };
    private final ModifyListener modifyListener = modifyEvent -> {
        this.pattern = ((Text)modifyEvent.widget).getText().toLowerCase();
        if (this.pattern.isEmpty()) {
            this.searchJob.cancel();
            this.resetJob.schedule(200L);
        } else {
            if (this.searchJob.getState() == 1 || this.searchJob.getState() == 2) {
                this.searchJob.cancel();
            }
            this.searchJob.schedule(200L);
        }
    };

    boolean shouldSelect(Object object) {
        if (!(object instanceof WrappedGamaFile)) {
            return false;
        }
        WrappedGamaFile wrappedGamaFile = (WrappedGamaFile)object;
        return wrappedGamaFile.getName().toLowerCase().contains(this.pattern) || wrappedGamaFile.hasTag(this.pattern);
    }

    public NavigatorSearchControl(GamaNavigator gamaNavigator) {
        this.navigator = gamaNavigator;
    }

    public void initialize() {
        this.treeViewer = this.navigator.getCommonViewer();
    }

    public NavigatorSearchControl fill(GamaToolbarSimple gamaToolbarSimple) {
        GridLayout gridLayout;
        GridData gridData;
        GamaToolbarSimple gamaToolbarSimple2 = gamaToolbarSimple;
        Color color = gamaToolbarSimple2.getBackground();
        if (PlatformHelper.isWindows()) {
            gamaToolbarSimple2 = new Composite((Composite)gamaToolbarSimple, 0);
            gridData = new GridData(4, 4, true, true);
            gridData.heightHint = 24;
            gridData.widthHint = 150;
            gamaToolbarSimple2.setLayoutData((Object)gridData);
            gridLayout = new GridLayout();
            gamaToolbarSimple2.setLayout((Layout)gridLayout);
            GamaColors.setBackground((Color)color, (Control[])new Control[]{gamaToolbarSimple2});
        }
        this.find = new Text((Composite)gamaToolbarSimple2, 896);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 16;
        gridData.widthHint = 100;
        this.find.setLayoutData((Object)gridData);
        gamaToolbarSimple.control((Control)(gamaToolbarSimple2 == gamaToolbarSimple ? this.find : gamaToolbarSimple2), 150);
        gridLayout = (IFocusService)this.navigator.getSite().getService(IFocusService.class);
        gridLayout.addFocusTracker((Control)this.find, "search");
        this.find.setMessage(EMPTY);
        GamaColors.setBackAndForeground((Color)color, (Color)(ThemeHelper.isDark() ? IGamaColors.VERY_LIGHT_GRAY.color() : IGamaColors.VERY_DARK_GRAY.color()), (Control[])new Control[]{this.find});
        this.find.addModifyListener(this.modifyListener);
        this.find.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    NavigatorSearchControl.this.find.setText("");
                    NavigatorSearchControl.this.navigator.setFocus();
                }
            }
        });
        return this;
    }

    public void doSearch() {
        if (this.expandedElementsBeforeSearch == null) {
            this.expandedElementsBeforeSearch = this.treeViewer.getExpandedElements();
        }
        this.treeViewer.getControl().setRedraw(false);
        this.filter.reset();
        if (!Arrays.asList(this.treeViewer.getFilters()).contains((Object)this.filter)) {
            this.treeViewer.addFilter((ViewerFilter)this.filter);
        } else {
            this.treeViewer.refresh(false);
        }
        this.treeViewer.expandAll();
        this.treeViewer.getControl().setRedraw(true);
    }

    public void resetSearch() {
        this.treeViewer.getControl().setRedraw(false);
        if (Arrays.asList(this.treeViewer.getFilters()).contains((Object)this.filter)) {
            this.treeViewer.removeFilter((ViewerFilter)this.filter);
        } else {
            this.treeViewer.refresh(false);
        }
        if (this.expandedElementsBeforeSearch != null) {
            this.treeViewer.collapseAll();
            this.treeViewer.setExpandedElements(this.expandedElementsBeforeSearch);
            this.expandedElementsBeforeSearch = null;
        }
        this.treeViewer.getControl().setRedraw(true);
    }

    public void searchFor(String string) {
        this.find.setText(string);
        this.pattern = string;
        this.doSearch();
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        Set alreadySelected = new HashSet();

        public void reset() {
            this.alreadySelected = ((StreamEx)StreamEx.ofValues((Map)ResourceManager.cache.asMap()).filter(wrappedResource -> NavigatorSearchControl.this.shouldSelect(wrappedResource))).toSet();
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return this.select((VirtualContent)object2, true);
        }

        private boolean select(VirtualContent<?> virtualContent, boolean bl) {
            if (this.alreadySelected.contains(virtualContent)) {
                return true;
            }
            if (this.internalSelect(virtualContent, bl)) {
                this.alreadySelected.add(virtualContent);
                return true;
            }
            return false;
        }

        private boolean internalSelect(VirtualContent<?> virtualContent, boolean bl) {
            Object[] objectArray;
            if (NavigatorSearchControl.this.pattern.isEmpty()) {
                return true;
            }
            switch (virtualContent.getType()) {
                case FILE: {
                    return NavigatorSearchControl.this.shouldSelect(virtualContent);
                }
                case FILE_REFERENCE: 
                case CATEGORY: 
                case GAML_ELEMENT: {
                    return bl;
                }
            }
            Object[] objectArray2 = objectArray = virtualContent.getNavigatorChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                if (this.select((VirtualContent)object, false)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

