/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.metadata.FileMetaDataProvider;
import gama.ui.navigator.view.contents.LinkedFile;
import gama.ui.shared.dialogs.Messages;
import gama.ui.shared.utils.WorkbenchHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class RenameResourceAction
extends WorkspaceAction {
    public static final String ID = "org.eclipse.ui.RenameResourceAction";
    private String newNameWithoutExtension;
    private String[] modelProviderIds;
    private static final String CHECK_RENAME_TITLE = IDEWorkbenchMessages.RenameResourceAction_checkTitle;
    private static final String CHECK_RENAME_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_readOnlyCheck;
    private static String RESOURCE_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_resourceExists;
    private static String RESOURCE_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteQuestion;
    private static String PROJECT_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteProjectQuestion;
    private static String PROJECT_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_projectExists;

    public RenameResourceAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.RenameResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.RenameResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.rename_resource_action_context");
    }

    private boolean checkOverwrite(IResource iResource) {
        String string = iResource.getFullPath().makeRelative().toString();
        String string2 = RESOURCE_EXISTS_MESSAGE;
        String string3 = RESOURCE_EXISTS_TITLE;
        if (iResource.getType() == 4) {
            string2 = PROJECT_EXISTS_MESSAGE;
            string3 = PROJECT_EXISTS_TITLE;
        }
        return Messages.question((String)string3, (String)MessageFormat.format(string2, string));
    }

    private boolean checkReadOnlyAndNull(IResource iResource) {
        if (iResource == null) {
            return false;
        }
        ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
        if (resourceAttributes != null && resourceAttributes.isReadOnly()) {
            return Messages.question((String)CHECK_RENAME_TITLE, (String)MessageFormat.format(CHECK_RENAME_MESSAGE, iResource.getName()));
        }
        return true;
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_progress;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RenameResourceAction_problemTitle;
    }

    protected String queryNewResourceName(IResource iResource) {
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IPath iPath = iResource.getFullPath().removeLastSegments(1);
        IInputValidator iInputValidator = string -> {
            if (iResource.getName().equals(string)) {
                return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
            }
            IStatus iStatus = iWorkspace.validateName(string, iResource.getType());
            if (!iStatus.isOK()) {
                return iStatus.getMessage();
            }
            if (iWorkspace.getRoot().exists(iPath.append(string))) {
                return IDEWorkbenchMessages.RenameResourceAction_nameExists;
            }
            return null;
        };
        InputDialog inputDialog = new InputDialog(WorkbenchHelper.getShell(), IDEWorkbenchMessages.RenameResourceAction_inputDialogTitle, IDEWorkbenchMessages.RenameResourceAction_inputDialogMessage, iResource.getName(), iInputValidator);
        inputDialog.setBlockOnOpen(true);
        int n = inputDialog.open();
        if (n == 0) {
            return inputDialog.getValue();
        }
        return null;
    }

    public void run() {
        IResource iResource = this.getCurrentResource();
        if (iResource == null || !iResource.exists() || !this.checkReadOnlyAndNull(iResource)) {
            return;
        }
        String string = this.queryNewResourceName(iResource);
        if (string == null || "".equals(string)) {
            return;
        }
        this.newNameWithoutExtension = new Path(string).removeFileExtension().toOSString();
        super.run();
    }

    private IResource getCurrentResource() {
        List<? extends IResource> list = this.getSelectedResources();
        if (list.size() == 0) {
            return null;
        }
        IResource iResource = list.get(0);
        if (FileMetaDataProvider.getInstance().hasSupportFiles(iResource) || list.size() == 1) {
            return iResource;
        }
        return null;
    }

    protected List<? extends IResource> getSelectedResources() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (IResource iResource : super.getSelectedResources()) {
            arrayList.add(iResource);
            if (!FileMetaDataProvider.getInstance().hasSupportFiles(iResource)) continue;
            arrayList.addAll(FileMetaDataProvider.getInstance().getSupportFilesOf((IFile)iResource));
        }
        return arrayList;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 0 || iStructuredSelection.size() > 1 || iStructuredSelection.getFirstElement() instanceof LinkedFile || !super.updateSelection(iStructuredSelection)) {
            return false;
        }
        IResource iResource = this.getCurrentResource();
        return iResource != null && iResource.exists();
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    protected IRunnableWithProgress createOperation(IStatus[] iStatusArray) {
        return iProgressMonitor -> {
            IResource[] iResourceArray = this.getActionResources().toArray(new IResource[this.getActionResources().size()]);
            IWorkspaceRoot iWorkspaceRoot = iResourceArray[0].getWorkspace().getRoot();
            IResource[] iResourceArray2 = iResourceArray;
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                String string = iResource.getFullPath().getFileExtension();
                IPath iPath = iResource.getFullPath().removeLastSegments(1).append((String)(string == null ? this.newNameWithoutExtension : this.newNameWithoutExtension + "." + string));
                IResource iResource2 = iWorkspaceRoot.findMember(iPath);
                boolean bl = true;
                if (iResource2 != null) {
                    bl = this.checkOverwrite(iResource2);
                }
                if (bl) {
                    MoveResourcesOperation moveResourcesOperation = new MoveResourcesOperation(iResource, iPath, IDEWorkbenchMessages.RenameResourceAction_operationTitle);
                    moveResourcesOperation.setModelProviderIds(this.getModelProviderIds());
                    try {
                        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)moveResourcesOperation, iProgressMonitor, null);
                    }
                    catch (ExecutionException executionException) {
                        iStatusArray[0] = executionException.getCause() instanceof CoreException ? ((CoreException)executionException.getCause()).getStatus() : new Status(4, "org.eclipse.ui", this.getProblemsMessage(), (Throwable)executionException);
                    }
                }
                ++n2;
            }
        };
    }
}

