/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.view.contents.NavigatorRoot;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenSystemEditorAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenFileAction
extends OpenSystemEditorAction {
    public static final String ID = "org.eclipse.ui.OpenFileAction";
    private final IEditorDescriptor editorDescriptor;

    public OpenFileAction(IWorkbenchPage iWorkbenchPage) {
        this(iWorkbenchPage, null);
    }

    public OpenFileAction(IWorkbenchPage iWorkbenchPage, IEditorDescriptor iEditorDescriptor) {
        super(iWorkbenchPage);
        this.setText(iEditorDescriptor == null ? IDEWorkbenchMessages.OpenFileAction_text : iEditorDescriptor.getLabel());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_file_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenFileAction_toolTip);
        this.setId(ID);
        this.editorDescriptor = iEditorDescriptor;
    }

    boolean ensureFileLocal(IFile iFile) {
        return NavigatorRoot.getInstance().getManager().validateLocation(iFile);
    }

    public void run() {
        for (IResource iResource : this.getSelectedResources()) {
            if (!(iResource instanceof IFile)) continue;
            this.privateOpenFile((IFile)iResource);
        }
    }

    protected List<? extends IResource> getSelectedResources() {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(super.getSelectedResources());
        arrayList.removeIf(iResource -> iResource instanceof IFile && !NavigatorRoot.getInstance().getManager().validateLocation((IFile)iResource));
        return arrayList;
    }

    void privateOpenFile(IFile iFile) {
        try {
            boolean bl = OpenStrategy.activateOnOpen();
            if (this.editorDescriptor == null) {
                IDE.openEditor((IWorkbenchPage)WorkbenchHelper.getPage(), (IFile)iFile, (boolean)bl);
            } else if (this.ensureFileLocal(iFile)) {
                WorkbenchHelper.getPage().openEditor((IEditorInput)new FileEditorInput(iFile), this.editorDescriptor.getId(), bl);
            }
        }
        catch (PartInitException partInitException) {
            DialogUtil.openError((Shell)WorkbenchHelper.getPage().getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenFileAction_openFileShellTitle, (String)partInitException.getMessage(), (PartInitException)partInitException);
        }
    }
}

