/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.ExperimentParameter;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.InputParameter;
import gama.core.kernel.experiment.TextStatement;
import gama.core.metamodel.agent.IAgent;
import gama.core.outputs.MonitorOutput;
import gama.core.runtime.IScope;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.UserCommandStatement;
import gama.gaml.types.IType;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.interfaces.IParameterEditor;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.parameters.AgentEditor;
import gama.ui.shared.parameters.BooleanEditor;
import gama.ui.shared.parameters.ColorEditor;
import gama.ui.shared.parameters.CommandEditor;
import gama.ui.shared.parameters.DateEditor;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.parameters.ExpressionBasedEditor;
import gama.ui.shared.parameters.ExpressionEditor;
import gama.ui.shared.parameters.FileEditor;
import gama.ui.shared.parameters.FloatEditor;
import gama.ui.shared.parameters.FontEditor;
import gama.ui.shared.parameters.IntEditor;
import gama.ui.shared.parameters.LabelEditor;
import gama.ui.shared.parameters.ListEditor;
import gama.ui.shared.parameters.MatrixEditor;
import gama.ui.shared.parameters.MonitorDisplayer;
import gama.ui.shared.parameters.PointEditor;
import gama.ui.shared.parameters.PopulationEditor;
import gama.ui.shared.parameters.SliderEditor;
import gama.ui.shared.parameters.StringEditor;
import gama.ui.shared.parameters.TextDisplayer;

public class EditorFactory {
    private static final EditorFactory instance = new EditorFactory();

    public static EditorFactory getInstance() {
        return instance;
    }

    public static ExpressionEditor createExpression(IScope iScope, EditorsGroup editorsGroup, String string, IExpression iExpression, EditorListener editorListener, IType iType) {
        ExpressionEditor expressionEditor = new ExpressionEditor(iScope.getAgent(), new InputParameter(string, (Object)iExpression), editorListener, iType);
        expressionEditor.createControls(editorsGroup);
        return expressionEditor;
    }

    public static AbstractEditor create(IScope iScope, EditorsGroup editorsGroup, String string, String string2, boolean bl, EditorListener<String> editorListener) {
        InputParameter inputParameter = new InputParameter(string, (Object)string2);
        AbstractEditor abstractEditor = bl ? new LabelEditor(iScope.getAgent(), (IParameter)inputParameter, editorListener) : new StringEditor(iScope.getAgent(), (IParameter)inputParameter, editorListener);
        abstractEditor.createControls(editorsGroup);
        return abstractEditor;
    }

    public static AbstractEditor create(IScope iScope, EditorsGroup editorsGroup, IParameter iParameter, boolean bl) {
        return EditorFactory.create(iScope, editorsGroup, iParameter, null, bl);
    }

    public static AbstractEditor create(IScope iScope, EditorsGroup editorsGroup, IParameter iParameter, EditorListener editorListener, boolean bl) {
        AbstractEditor abstractEditor = instance.create(iScope.getAgent(), iParameter, editorListener);
        abstractEditor.isSubParameter(bl);
        abstractEditor.createControls(editorsGroup);
        return abstractEditor;
    }

    public AbstractEditor create(IAgent iAgent, IParameter iParameter, EditorListener editorListener) {
        boolean bl = iParameter instanceof ExperimentParameter && ((ExperimentParameter)iParameter).canBeNull();
        IScope iScope = iAgent.getScope();
        IType iType = iParameter.getType();
        int n = iType.getGamlType().id();
        if (iType.isContainer() && iType.getContentType().isAgentType()) {
            return new PopulationEditor(iAgent, iParameter, editorListener);
        }
        if (iType.isAgentType() || n == 11) {
            return new AgentEditor(iAgent, iParameter, editorListener);
        }
        switch (n) {
            case 3: {
                return new BooleanEditor(iAgent, iParameter, editorListener);
            }
            case 23: {
                return new DateEditor(iAgent, iParameter, editorListener);
            }
            case 6: {
                return new ColorEditor(iAgent, iParameter, editorListener);
            }
            case 2: {
                if (iParameter.getMaxValue(iAgent.getScope()) != null && iParameter.getMinValue(iScope) != null && iParameter.acceptsSlider(iScope)) {
                    return new SliderEditor.Float(iAgent, iParameter, editorListener);
                }
                return new FloatEditor(iAgent, iParameter, bl, editorListener);
            }
            case 1: {
                if (iParameter.getMaxValue(iScope) != null && iParameter.getMinValue(iScope) != null && iParameter.acceptsSlider(iScope)) {
                    return new SliderEditor.Int(iAgent, iParameter, editorListener);
                }
                return new IntEditor(iAgent, iParameter, bl, editorListener);
            }
            case 5: {
                return new ListEditor(iAgent, iParameter, editorListener);
            }
            case 7: {
                return new PointEditor(iAgent, iParameter, editorListener);
            }
            case 8: {
                return new MatrixEditor(iAgent, iParameter, editorListener);
            }
            case 12: {
                return new FileEditor(iAgent, iParameter, editorListener, false);
            }
            case 30: {
                return new FileEditor(iAgent, iParameter, editorListener, true);
            }
            case 19: {
                return new FontEditor(iAgent, iParameter, editorListener);
            }
            case 4: {
                return new StringEditor(iAgent, iParameter, editorListener);
            }
        }
        return new ExpressionBasedEditor(iAgent, iParameter, editorListener);
    }

    public IParameterEditor create(IScope iScope, UserCommandStatement userCommandStatement, EditorListener.Command command) {
        return new CommandEditor(iScope, userCommandStatement, command);
    }

    public IParameterEditor create(IScope iScope, TextStatement textStatement) {
        return new TextDisplayer(iScope, textStatement);
    }

    public MonitorDisplayer create(IScope iScope, MonitorOutput monitorOutput) {
        return new MonitorDisplayer(iScope, monitorOutput);
    }
}

