/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.utils;

import com.google.common.base.Objects;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGamaView;
import gama.dev.DEBUG;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ViewsHelper {
    static volatile boolean isRequesting;
    static Map<Integer, IGamaView.Display> FULLSCREEN_VIEWS;

    static {
        DEBUG.OFF();
        FULLSCREEN_VIEWS = new HashMap<Integer, IGamaView.Display>();
    }

    public static void requestUserAttention(IGamaView iGamaView, String string) {
        if (isRequesting) {
            return;
        }
        String string2 = iGamaView.getPartName();
        int n = 0;
        while (n < 2) {
            WorkbenchHelper.getDisplay().timerExec(400 * n - 200, () -> {
                isRequesting = true;
                iGamaView.setName(string);
            });
            WorkbenchHelper.getDisplay().timerExec(400 * n, () -> {
                iGamaView.setName(string2);
                isRequesting = false;
            });
            ++n;
        }
    }

    public static IGamaView.Display findDisplay(String string) {
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IViewReference iViewReference = iWorkbenchPage.findViewReference(string);
        if (iViewReference == null) {
            return null;
        }
        IViewPart iViewPart = iViewReference.getView(false);
        if (iViewPart instanceof IGamaView.Display) {
            return (IGamaView.Display)iViewPart;
        }
        return null;
    }

    public static boolean isDisplay(String string) {
        if (!string.startsWith("gama.ui.application.view.OpenGLDisplayView") && !string.startsWith("gama.ui.application.view.LayeredDisplayView")) {
            return false;
        }
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return false;
        }
        IViewReference iViewReference = iWorkbenchPage.findViewReference(string);
        return iViewReference != null;
    }

    public static IViewPart findView(String string, String string2, boolean bl) {
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IViewReference iViewReference = iWorkbenchPage.findViewReference(string, string2);
        if (iViewReference == null) {
            return null;
        }
        return iViewReference.getView(bl);
    }

    public static List<IGamaView.Display> getDisplayViews(Predicate<IViewPart> predicate) {
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return Collections.EMPTY_LIST;
        }
        return ((StreamEx)StreamEx.of((Object[])iWorkbenchPage.getViewReferences()).map(iViewReference -> iViewReference.getView(false)).filter(predicate == null ? iViewPart -> true : predicate)).select(IGamaView.Display.class).toList();
    }

    public static void hideView(String string) {
        WorkbenchHelper.run(() -> {
            IWorkbenchPart iWorkbenchPart;
            IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
            if (iWorkbenchPage == null) {
                return;
            }
            IViewReference iViewReference = iWorkbenchPage.findViewReference(string);
            if (iViewReference != null && (iWorkbenchPart = iViewReference.getPart(false)) != null && iWorkbenchPage.isPartVisible(iWorkbenchPart)) {
                iWorkbenchPage.hideView((IViewPart)iWorkbenchPart);
            }
        });
    }

    public static List<IDisplaySurface> allDisplaySurfaces() {
        return StreamEx.of(ViewsHelper.getDisplayViews(null)).map(IGamaView.Display::getDisplaySurface).toList();
    }

    public static IDisplaySurface frontmostDisplaySurface() {
        return WorkbenchHelper.run(() -> {
            IGamaView.Display display = ViewsHelper.findFrontmostGamaViewUnderMouse();
            if (display != null) {
                return display.getDisplaySurface();
            }
            List<IDisplaySurface> list = ViewsHelper.allDisplaySurfaces();
            if (list.size() == 0) {
                return null;
            }
            return list.get(0);
        });
    }

    public static void hideView(IViewPart iViewPart) {
        if (iViewPart == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return;
        }
        iWorkbenchPage.hideView(iViewPart);
    }

    public static IGamaView.Display findFrontmostGamaViewUnderMouse() {
        CTabFolder cTabFolder;
        CTabItem cTabItem;
        int n = WorkbenchHelper.run(WorkbenchHelper::getMonitorUnderCursor);
        IGamaView.Display display = WorkbenchHelper.run(() -> FULLSCREEN_VIEWS.get(n));
        if (display != null) {
            return display;
        }
        Control control = WorkbenchHelper.run(() -> WorkbenchHelper.getDisplay().getCursorControl());
        if (control instanceof CTabFolder && (cTabItem = (cTabFolder = (CTabFolder)control).getSelection()) != null) {
            for (IDisplaySurface iWorkbenchPage2 : ViewsHelper.allDisplaySurfaces()) {
                if (!iWorkbenchPage2.getOutput().getName().equals(cTabItem.getText())) continue;
                return iWorkbenchPage2.getOutput().getView();
            }
        }
        if (control instanceof IGamaView.Display.InnerComponent) {
            cTabItem = (IGamaView.Display.InnerComponent)control;
            return cTabItem.getView();
        }
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return null;
        }
        Point point = WorkbenchHelper.getDisplay().getCursorLocation();
        List list = WorkbenchHelper.run(() -> ViewsHelper.getDisplayViews(iViewPart -> iWorkbenchPage2.isPartVisible((IWorkbenchPart)iViewPart)));
        for (IGamaView.Display display2 : list) {
            if (!display2.containsPoint(point.x, point.y)) continue;
            return display2;
        }
        return null;
    }

    public static boolean toggleFullScreenMode() {
        IGamaView.Display display = WorkbenchHelper.run(ViewsHelper::findFrontmostGamaViewUnderMouse);
        if (display != null && !display.isEscRedefined()) {
            return ViewsHelper.toggleFullScreenMode(display);
        }
        return false;
    }

    public static boolean toggleFullScreenMode(IGamaView.Display display) {
        WorkbenchHelper.run(() -> display.toggleFullScreen());
        return true;
    }

    public static boolean registerFullScreenView(Integer n, IGamaView.Display display) {
        boolean bl;
        boolean bl2 = bl = FULLSCREEN_VIEWS.putIfAbsent(n, display) == null;
        if (bl) {
            DEBUG.OUT((Object)("Registered " + String.valueOf(display) + " as fullscreen on Monitor " + String.valueOf(n)));
        } else {
            DEBUG.OUT((Object)("Impossible to register " + String.valueOf(display) + " as fullscreen on Monitor " + String.valueOf(n)));
        }
        return bl;
    }

    public static void unregisterFullScreenView(IGamaView.Display display) {
        FULLSCREEN_VIEWS.entrySet().removeIf(entry -> {
            boolean bl = Objects.equal(entry.getValue(), (Object)display);
            if (bl) {
                DEBUG.OUT((Object)("Unregistered " + String.valueOf(display) + " as fullscreen on Monitor " + String.valueOf(entry.getKey())));
            }
            return bl;
        });
    }

    public static void activate(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return;
        }
        iWorkbenchPage.activate(iWorkbenchPart);
    }

    public static void bringToFront(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return;
        }
        iWorkbenchPage.bringToTop(iWorkbenchPart);
    }

    public static Monitor getMonitorOf(IWorkbenchPart iWorkbenchPart) {
        return WorkbenchHelper.run(() -> WorkbenchHelper.getDisplay().getMonitors()[WorkbenchHelper.getMonitorContaining(iWorkbenchPart.getSite().getShell().getBounds())]);
    }
}

