/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;

public class FontSizer {
    IToolbarDecoratedView.Sizable view;
    Font currentFont;
    final GestureListener gl = gestureEvent -> {
        if (gestureEvent.detail == 32) {
            this.changeFontSize((int)(2.0 * Math.signum(gestureEvent.magnification - 1.0)));
        }
    };

    public FontSizer(IToolbarDecoratedView.Sizable sizable) {
        this.view = sizable;
    }

    private void changeFontSize(int n) {
        Control control = this.view.getSizableFontControl();
        if (control != null) {
            FontData fontData = control.getFont().getFontData()[0];
            fontData.height += (float)n;
            if (fontData.height < 6.0f || fontData.height > 256.0f) {
                return;
            }
            Font font = this.currentFont;
            this.currentFont = new Font((Device)WorkbenchHelper.getDisplay(), fontData);
            control.setFont(this.currentFont);
            if (font != null && !font.isDisposed()) {
                font.dispose();
            }
        }
    }

    public void install(final GamaToolbar2 gamaToolbar2) {
        gamaToolbar2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Control control = FontSizer.this.view.getSizableFontControl();
                if (control != null) {
                    control.addGestureListener(FontSizer.this.gl);
                    gamaToolbar2.removeControlListener((ControlListener)this);
                }
            }
        });
        gamaToolbar2.button("viewers/font.increase", "Increase font size", "Increase font size", selectionEvent -> this.changeFontSize(2), 131072);
        gamaToolbar2.button("viewers/font.decrease", "Decrease font size", "Decrease font size", selectionEvent -> this.changeFontSize(-2), 131072);
        gamaToolbar2.sep(16, 131072);
    }
}

