/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.bindings;

import gama.core.runtime.GAMA;
import gama.core.runtime.PlatformHelper;
import gama.ui.application.workbench.PerspectiveHelper;
import gama.ui.shared.access.GamlSearchField;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GamaKeyBindings
implements Listener {
    public static final int COMMAND = PlatformHelper.isMac() ? 0x400000 : 262144;
    public static final String SEARCH_STRING = GamaKeyBindings.format(COMMAND + 131072, 72);
    public static final String PLAY_STRING = GamaKeyBindings.format(COMMAND, 80);
    public static final String STEP_STRING = GamaKeyBindings.format(COMMAND + 131072, 80);
    public static final String RELOAD_STRING = GamaKeyBindings.format(COMMAND, 82);
    public static final String QUIT_STRING = GamaKeyBindings.format(COMMAND + 131072, 88);
    private static final Map<KeyStroke, PluggableBinding> bindings = new LinkedHashMap<KeyStroke, PluggableBinding>();
    private static final GamaKeyBindings BINDINGS = new GamaKeyBindings();

    GamaKeyBindings() {
    }

    public void handleEvent(Event event) {
        if (event.keyCode == 27) {
            if (ViewsHelper.toggleFullScreenMode()) {
                this.consume(event);
            }
            return;
        }
        if (event.stateMask == 0) {
            return;
        }
        switch (event.keyCode) {
            case 104: {
                if (!GamaKeyBindings.ctrl(event) || !GamaKeyBindings.shift(event)) break;
                this.consume(event);
                GamlSearchField.INSTANCE.search();
                break;
            }
            case 112: {
                if (GamaKeyBindings.ctrl(event) && GamaKeyBindings.shift(event)) {
                    this.consume(event);
                    GAMA.stepFrontmostExperiment((boolean)false);
                    break;
                }
                if (!GamaKeyBindings.ctrl(event)) break;
                this.consume(event);
                GAMA.startPauseFrontmostExperiment((boolean)false);
                break;
            }
            case 114: {
                if (PerspectiveHelper.isModelingPerspective()) break;
                if (GamaKeyBindings.ctrl(event) && GamaKeyBindings.shift(event)) {
                    this.consume(event);
                    GAMA.relaunchFrontmostExperiment();
                    break;
                }
                if (!GamaKeyBindings.ctrl(event)) break;
                this.consume(event);
                GAMA.reloadFrontmostExperiment((boolean)false);
                break;
            }
            case 120: {
                if (!GamaKeyBindings.ctrl(event) || !GamaKeyBindings.shift(event)) break;
                this.consume(event);
                GAMA.closeAllExperiments((boolean)true, (boolean)false);
                break;
            }
            default: {
                PluggableBinding pluggableBinding = bindings.get(KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode));
                if (pluggableBinding == null) break;
                this.consume(event);
                pluggableBinding.run();
            }
        }
    }

    private void consume(Event event) {
        event.doit = false;
        event.type = 0;
    }

    public static void install() {
        WorkbenchHelper.run(() -> WorkbenchHelper.getDisplay().addFilter(1, (Listener)BINDINGS));
    }

    public static boolean ctrl(Event event) {
        return (event.stateMask & COMMAND) != 0;
    }

    public static boolean ctrl(KeyEvent keyEvent) {
        return (keyEvent.stateMask & COMMAND) != 0;
    }

    public static boolean ctrl(MouseEvent mouseEvent) {
        return (mouseEvent.stateMask & COMMAND) != 0;
    }

    public static boolean shift(KeyEvent keyEvent) {
        return (keyEvent.stateMask & 0x20000) != 0;
    }

    public static boolean shift(Event event) {
        return (event.stateMask & 0x20000) != 0;
    }

    public static boolean shift(MouseEvent mouseEvent) {
        return (mouseEvent.stateMask & 0x20000) != 0;
    }

    public static String format(int n, int n2) {
        return SWTKeySupport.getKeyFormatterForPlatform().format(KeyStroke.getInstance((int)n, (int)n2));
    }

    public static void plug(PluggableBinding pluggableBinding) {
        bindings.put(pluggableBinding.key, pluggableBinding);
    }

    public static abstract class PluggableBinding
    implements Runnable {
        final KeyStroke key;

        public PluggableBinding(int n, int n2) {
            this.key = KeyStroke.getInstance((int)n, (int)n2);
        }
    }
}

