/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.core.util.GamaColor;
import gama.ui.shared.menus.GamaColorMenu;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

public class BackgroundChooser {
    final IToolbarDecoratedView.Colorizable view;
    final String[] labels;
    final GamaColors.GamaUIColor[] colors;

    public BackgroundChooser(IToolbarDecoratedView.Colorizable colorizable) {
        this.view = colorizable;
        this.labels = colorizable.getColorLabels();
        this.colors = new GamaColors.GamaUIColor[this.labels.length];
        int n = 0;
        while (n < this.labels.length) {
            this.colors[n] = colorizable.getColor(n);
            ++n;
        }
    }

    public void install(GamaToolbar2 gamaToolbar2) {
        int n = 0;
        while (n < this.labels.length) {
            final int n2 = n++;
            final ToolItem toolItem = gamaToolbar2.button(null, this.labels[n2], this.labels[n2], null, 131072);
            toolItem.setImage(GamaIcon.ofColor(this.colors[n2], true).image());
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
                SelectionListener listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MenuItem menuItem = (MenuItem)selectionEvent.widget;
                        String string = menuItem.getText().replace("#", "");
                        GamaColor gamaColor = (GamaColor)GamaColor.colors.get(string);
                        if (gamaColor == null) {
                            return;
                        }
                        this.changeColor(gamaColor.red(), gamaColor.green(), gamaColor.blue());
                    }
                };

                void changeColor(int n, int n22, int n3) {
                    BackgroundChooser.this.colors[n2] = GamaColors.get(n, n22, n3);
                    toolItem.setImage(GamaIcon.ofColor(BackgroundChooser.this.colors[n2], true).image());
                    BackgroundChooser.this.view.setColor(n2, BackgroundChooser.this.colors[n2]);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    new GamaColorMenu(null).open((Control)toolItem.getParent(), selectionEvent, this.listener, this::changeColor);
                }
            });
        }
    }
}

