/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls;

import gama.dev.DEBUG;
import gama.ui.shared.controls.IPositionChangeListener;
import gama.ui.shared.resources.GamaColors;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SimpleSlider
extends Composite {
    public static final int THUMB_WIDTH = 6;
    public static final int THUMB_HEIGHT = 13;
    public static final int PANEL_HEIGHT = 3;
    final Composite parent;
    final Thumb thumb;
    final Panel leftRegion;
    final Panel rightRegion;
    boolean mouseDown = false;
    private Double step = null;
    private final List<IPositionChangeListener> positionChangedListeners = new ArrayList<IPositionChangeListener>();
    double previousPosition = 0.0;
    private boolean notify = true;

    static {
        DEBUG.OFF();
    }

    public SimpleSlider(Composite composite, Color color, Color color2, Color color3, boolean bl) {
        super(composite, 0x20000001);
        this.parent = composite;
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(0, 0).applyTo((Composite)this);
        this.leftRegion = new Panel(this, color);
        this.leftRegion.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                SimpleSlider.this.mouseDown = true;
                SimpleSlider.this.moveThumbHorizontally(mouseEvent.x - 3);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                SimpleSlider.this.mouseDown = false;
            }
        });
        this.leftRegion.addMouseMoveListener(mouseEvent -> {
            if (this.mouseDown) {
                this.moveThumbHorizontally(mouseEvent.x - 3);
            }
        });
        this.thumb = new Thumb(this, color3);
        this.thumb.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                SimpleSlider.this.mouseDown = true;
                SimpleSlider.this.moveThumbHorizontally(SimpleSlider.this.leftRegion.getBounds().width + mouseEvent.x - 3);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                SimpleSlider.this.mouseDown = false;
            }
        });
        this.thumb.addMouseMoveListener(mouseEvent -> {
            if (this.mouseDown) {
                this.moveThumbHorizontally(this.leftRegion.getBounds().width + mouseEvent.x - 3);
            }
        });
        this.rightRegion = new Panel(this, color2, true);
        this.rightRegion.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                SimpleSlider.this.mouseDown = true;
                SimpleSlider.this.moveThumbHorizontally(SimpleSlider.this.leftRegion.getBounds().width + SimpleSlider.this.thumb.getBounds().width / 2 + mouseEvent.x);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                SimpleSlider.this.mouseDown = false;
            }
        });
        this.rightRegion.addMouseMoveListener(mouseEvent -> {
            if (this.mouseDown) {
                this.moveThumbHorizontally(this.leftRegion.getBounds().width + this.thumb.getBounds().width / 2 + mouseEvent.x);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                SimpleSlider.this.updateSlider(SimpleSlider.this.previousPosition, false);
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SimpleSlider.this.thumb.setFocus();
            }
        });
        this.addTraverseListener(traverseEvent -> {
            boolean bl = traverseEvent.doit = true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPositionChangeListener(IPositionChangeListener iPositionChangeListener) {
        List<IPositionChangeListener> list = this.positionChangedListeners;
        synchronized (list) {
            if (!this.positionChangedListeners.contains(iPositionChangeListener)) {
                this.positionChangedListeners.add(iPositionChangeListener);
            }
        }
    }

    public double getCurrentPosition() {
        return this.previousPosition;
    }

    private void updatePositionListeners(double d) {
        if (!this.notify) {
            return;
        }
        if (Math.abs(d - this.previousPosition) > 1.0E-6) {
            Iterator<IPositionChangeListener> iterator = this.positionChangedListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().positionChanged(this, d);
            }
        }
    }

    void moveThumbHorizontally(int n) {
        int n2 = this.getClientArea().width - 6;
        int n3 = n < 0 ? 0 : (n > n2 ? n2 : n);
        double d = (double)n3 / (double)n2;
        if (this.step != null) {
            d = (double)Math.round(d / this.step) * this.step;
        }
        n3 = (int)(d * (double)n2);
        this.thumb.setFocus();
        this.leftRegion.updatePosition(n3);
        this.layout();
        this.updatePositionListeners(d);
        this.previousPosition = d;
    }

    public void updateSlider(double d, boolean bl) {
        double d2 = d;
        if (this.step != null) {
            d2 = (double)Math.round(d2 / this.step) * this.step;
        }
        this.notify = bl;
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > 1.0) {
            d2 = 1.0;
        }
        int n = this.getClientArea().width - 6;
        int n2 = (int)Math.round((double)n * d2);
        this.moveThumbHorizontally(n2);
        this.previousPosition = d2;
        this.notify = true;
    }

    public void setBackground(Color color) {
        if (color != null) {
            GamaColors.setBackground(color, new Control[]{this.thumb, this.rightRegion, this.leftRegion});
        }
        super.setBackground(color);
    }

    public void setLeftBackground(Color color) {
        this.leftRegion.setBackground(color);
    }

    public void setRightBackground(Color color) {
        this.rightRegion.setBackground(color);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.thumb.setToolTipText(string);
        this.rightRegion.setToolTipText(string);
        this.leftRegion.setToolTipText(string);
    }

    public void setStep(Double d) {
        if (d != null && d > 0.0) {
            this.step = d;
        }
    }

    private class Panel
    extends Canvas
    implements PaintListener {
        private final GridData gd;
        private final Color color;

        public Panel(Composite composite, Color color) {
            this(composite, color, false);
        }

        public Panel(Composite composite, Color color, boolean bl) {
            super(composite, 0x20040000);
            this.gd = GridDataFactory.swtDefaults().minSize(0, 3).align(bl ? 4 : 1, 1).grab(bl, false).create();
            this.color = color;
            this.setLayoutData(this.gd);
            this.addPaintListener(this);
        }

        void updatePosition(int n) {
            this.gd.minimumWidth = n;
            this.gd.widthHint = n;
        }

        public void paintControl(PaintEvent paintEvent) {
            GC gC = paintEvent.gc;
            Rectangle rectangle = gC.getClipping();
            gC.setBackground(SimpleSlider.this.parent.getBackground());
            gC.fillRectangle(rectangle);
            gC.setBackground(this.color);
            gC.fillRoundRectangle(rectangle.x, (int)((double)rectangle.height / 2.0 - 1.0), rectangle.width, 3, 3, 3);
        }
    }

    public class Thumb
    extends Canvas
    implements PaintListener {
        final Color color;

        public Thumb(Composite composite, Color color) {
            super(composite, 262144);
            this.color = color;
            this.addPaintListener(this);
            GridDataFactory.swtDefaults().hint(6, 13).minSize(6, 13).align(1, 4).grab(false, true).applyTo((Control)this);
        }

        public boolean forceFocus() {
            return true;
        }

        public Point computeSize(int n, int n2) {
            return new Point(6, 13);
        }

        public void paintControl(PaintEvent paintEvent) {
            GC gC = paintEvent.gc;
            Rectangle rectangle = gC.getClipping();
            gC.setBackground(SimpleSlider.this.parent.getBackground());
            gC.fillRectangle(rectangle);
            gC.setBackground(this.color);
            gC.fillRoundRectangle(0, (rectangle.height - 13) / 2 + 1, 6, 13, 3, 3);
        }
    }
}

