/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.gaml.types.IType;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.interfaces.IAgentMenuFactory;
import gama.ui.shared.menus.MenuAction;
import gama.ui.shared.parameters.ExpressionBasedEditor;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.Collection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class AgentEditor
extends ExpressionBasedEditor {
    String species;

    AgentEditor(IAgent iAgent, IParameter iParameter, EditorListener editorListener) {
        super(iAgent, iParameter, editorListener);
        this.species = iParameter.getType().toString();
    }

    @Override
    public void applyChange() {
        IAgentMenuFactory iAgentMenuFactory;
        Shell shell = this.editorToolbar.getItem(5).getParent().getShell();
        Menu menu = shell.getMenu();
        shell.setMenu(null);
        if (menu != null) {
            menu.dispose();
        }
        MenuAction menuAction = new MenuAction((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                IAgent iAgent = (IAgent)menuItem.getData("agent");
                if (iAgent != null && !iAgent.dead()) {
                    AgentEditor.this.modifyAndDisplayValue(iAgent);
                }
            }
        }, GamaIcon.named("agents/agent.submenu").image(), "Choose");
        Menu menu2 = new Menu((Control)shell);
        IAgent iAgent = (IAgent)(this.currentValue instanceof IAgent ? this.currentValue : this.getAgent());
        if (iAgent != null && (iAgentMenuFactory = WorkbenchHelper.getService(IAgentMenuFactory.class)) != null) {
            iAgentMenuFactory.fillPopulationSubMenu(menu2, (Collection<? extends IAgent>)iAgent.getSimulation().getMicroPopulation(this.species), null, menuAction);
        }
        iAgentMenuFactory = this.editorToolbar.getItem(5).getBounds();
        Point point = this.editorToolbar.getItem(5).getParent().toDisplay(new Point(((Rectangle)iAgentMenuFactory).x, ((Rectangle)iAgentMenuFactory).y));
        menu2.setLocation(point.x, point.y + ((Rectangle)iAgentMenuFactory).height);
        menu2.setVisible(true);
    }

    @Override
    public IType getExpectedType() {
        return this.getScope().getType(this.species);
    }

    @Override
    protected int[] getToolItems() {
        return new int[]{3, 5, 6};
    }

    @Override
    protected void applyInspect() {
        IAgent iAgent;
        Object object = this.currentValue;
        if (object instanceof IAgent && !(iAgent = (IAgent)object).dead()) {
            this.getScope().getGui().setSelectedAgent(iAgent);
        }
    }
}

