/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.core.common.interfaces.IGamaView;
import gama.dev.DEBUG;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.ITooltipDisplayer;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.views.toolbar.BackgroundChooser;
import gama.ui.shared.views.toolbar.CSVExportationController;
import gama.ui.shared.views.toolbar.FontSizer;
import gama.ui.shared.views.toolbar.FrequencyController;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gama.ui.shared.views.toolbar.LogExportationController;
import gama.ui.shared.views.toolbar.ZoomController;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;

public class GamaToolbarFactory {
    public static final int TOOLBAR_HEIGHT = 24;
    public static final int TOOLBAR_SEP = 4;

    static {
        DEBUG.OFF();
    }

    public static ITooltipDisplayer findTooltipDisplayer(Control control) {
        GamaComposite gamaComposite = GamaToolbarFactory.findGamaComposite(control);
        return gamaComposite == null ? null : gamaComposite.displayer;
    }

    public static GamaComposite findGamaComposite(Control control) {
        if (control instanceof Shell) {
            return null;
        }
        if (control instanceof GamaComposite) {
            return (GamaComposite)control;
        }
        return GamaToolbarFactory.findGamaComposite((Control)control.getParent());
    }

    private static Composite createIntermediateCompositeFor(IToolbarDecoratedView iToolbarDecoratedView, Composite composite) {
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 0;
        composite.setLayout((Layout)fillLayout);
        Composite composite2 = iToolbarDecoratedView instanceof ITooltipDisplayer ? new GamaComposite(composite, (ITooltipDisplayer)((Object)iToolbarDecoratedView)) : new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    public static GridData getLayoutDataForChild() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 5;
        return gridData;
    }

    public static FillLayout getLayoutForChild() {
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        return fillLayout;
    }

    public static Composite createToolbarComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GamaColors.setBackground(ThemeHelper.isDark() ? composite.getShell().getBackground() : IGamaColors.WHITE.color(), new Control[]{composite2});
        return composite2;
    }

    public static Composite createToolbars(final IToolbarDecoratedView iToolbarDecoratedView, Composite composite) {
        Composite composite2 = GamaToolbarFactory.createIntermediateCompositeFor(iToolbarDecoratedView, composite);
        Composite composite3 = GamaToolbarFactory.createToolbarComposite(composite2);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayoutData((Object)GamaToolbarFactory.getLayoutDataForChild());
        composite4.setLayout((Layout)GamaToolbarFactory.getLayoutForChild());
        final GamaToolbar2 gamaToolbar2 = new GamaToolbar2(composite3, 0x880100);
        GridData gridData = GamaToolbarFactory.layoutDataForToolbar();
        gamaToolbar2.setLayoutData(gridData);
        composite.addDisposeListener(disposeEvent -> GamaToolbarFactory.disposeToolbar(iToolbarDecoratedView, gamaToolbar2));
        GamaToolbarFactory.buildToolbar(iToolbarDecoratedView, gamaToolbar2);
        ToggleAction toggleAction = new ToggleAction(){

            public void run() {
                boolean bl = !gamaToolbar2.isVisible();
                gamaToolbar2.setVisible(bl);
                ((GridData)gamaToolbar2.getLayoutData()).exclude = !bl;
                gamaToolbar2.getParent().setVisible(bl);
                gamaToolbar2.getParent().getParent().layout();
                this.setIcon(bl);
            }

            @Override
            protected void setIcon(boolean bl) {
                this.setImageDescriptor(GamaIcon.named(bl ? "mini/toolbar.show" : "mini/toolbar.hide").descriptor());
            }
        };
        gamaToolbar2.setToogleAction(toggleAction);
        IWorkbenchSite iWorkbenchSite = iToolbarDecoratedView.getSite();
        if (iWorkbenchSite instanceof IViewSite) {
            IToolBarManager iToolBarManager = ((IViewSite)iWorkbenchSite).getActionBars().getToolBarManager();
            iToolBarManager.add((IAction)toggleAction);
            if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Expandable) {
                iToolBarManager.add((IAction)new CollapseAll(){

                    public void run() {
                        ((IToolbarDecoratedView.Expandable)iToolbarDecoratedView).collapseAll();
                    }
                });
                iToolBarManager.add((IAction)new ExpandAll(){

                    public void run() {
                        ((IToolbarDecoratedView.Expandable)iToolbarDecoratedView).expandAll();
                    }
                });
            }
            if (iToolbarDecoratedView instanceof IGamaView.Display) {
                ToggleOverlay toggleOverlay = new ToggleOverlay(){

                    public void run() {
                        ((IGamaView.Display)iToolbarDecoratedView).toggleOverlay();
                    }
                };
                iToolBarManager.add((IAction)toggleOverlay);
            }
            iToolBarManager.update(true);
        }
        return composite4;
    }

    public static GridData layoutDataForToolbar() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 24;
        gridData.minimumWidth = 48;
        return gridData;
    }

    public static void disposeToolbar(IToolbarDecoratedView iToolbarDecoratedView, GamaToolbar2 gamaToolbar2) {
        if (gamaToolbar2 != null && !gamaToolbar2.isDisposed()) {
            gamaToolbar2.dispose();
        }
    }

    public static void buildToolbar(IToolbarDecoratedView iToolbarDecoratedView, GamaToolbar2 gamaToolbar2) {
        Object object;
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Sizable) {
            object = new FontSizer((IToolbarDecoratedView.Sizable)iToolbarDecoratedView);
            ((FontSizer)object).install(gamaToolbar2);
        }
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Pausable) {
            object = new FrequencyController((IToolbarDecoratedView.Pausable)iToolbarDecoratedView);
            ((FrequencyController)object).install(gamaToolbar2);
        }
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Zoomable) {
            object = new ZoomController((IToolbarDecoratedView.Zoomable)iToolbarDecoratedView);
            ((ZoomController)object).install(gamaToolbar2);
        }
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Colorizable) {
            object = new BackgroundChooser((IToolbarDecoratedView.Colorizable)iToolbarDecoratedView);
            ((BackgroundChooser)object).install(gamaToolbar2);
        }
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.CSVExportable) {
            object = new CSVExportationController((IToolbarDecoratedView.CSVExportable)iToolbarDecoratedView);
            ((CSVExportationController)object).install(gamaToolbar2);
        }
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.LogExportable) {
            object = new LogExportationController((IToolbarDecoratedView.LogExportable)iToolbarDecoratedView);
            ((LogExportationController)object).install(gamaToolbar2);
        }
        iToolbarDecoratedView.createToolItems(gamaToolbar2);
        gamaToolbar2.requestLayout();
    }

    public static class CollapseAll
    extends Action {
        CollapseAll() {
            super("Collapse all items", 1);
            this.setIcon();
        }

        protected void setIcon() {
            this.setImageDescriptor(GamaIcon.named("mini/tree.collapse").descriptor());
        }
    }

    public static class ExpandAll
    extends Action {
        ExpandAll() {
            super("Expand all items", 1);
            this.setIcon();
        }

        protected void setIcon() {
            this.setImageDescriptor(GamaIcon.named("mini/tree.expand").descriptor());
        }
    }

    public static class GamaComposite
    extends Composite {
        ITooltipDisplayer displayer;

        public GamaComposite(Composite composite, ITooltipDisplayer iTooltipDisplayer) {
            super(composite, 0);
            this.displayer = iTooltipDisplayer;
        }
    }

    public static abstract class ToggleAction
    extends Action {
        ToggleAction() {
            super("Toggle toolbar", 1);
            this.setId("toolbar.toggle");
            this.setIcon(true);
        }

        protected abstract void setIcon(boolean var1);
    }

    public static class ToggleOverlay
    extends Action {
        ToggleOverlay() {
            super("Toggle Overlay", 1);
            this.setImageDescriptor(GamaIcon.named("mini/overlay.toggle").descriptor());
        }
    }
}

