/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.access;

import gama.dev.DEBUG;
import gama.gaml.interfaces.IGamlDescription;
import gama.ui.shared.access.GamlAccessContents;
import gama.ui.shared.access.GamlAccessEntry;
import gama.ui.shared.access.HeapControl;
import gama.ui.shared.bindings.GamaKeyBindings;
import gama.ui.shared.controls.IPopupProvider;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WebHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.swt.IFocusService;

public class GamlSearchField {
    Shell shell;
    protected Text text;
    public static GamlSearchField INSTANCE;
    GamlAccessContents quickAccessContents;
    int dialogHeight = -1;
    int dialogWidth = -1;
    Control previousFocusControl;
    private Composite composite;
    Table table;
    String selectedString = "";
    private AccessibleAdapter accessibleListener;
    private boolean commandsInstalled;

    static {
        DEBUG.ON();
    }

    private GamlSearchField() {
    }

    public Text getText() {
        return this.text;
    }

    void hookUpCommands() {
        if (this.commandsInstalled) {
            return;
        }
        this.commandsInstalled = true;
        IFocusService iFocusService = WorkbenchHelper.getService(IFocusService.class);
        iFocusService.addFocusTracker((Control)this.text, GamlSearchField.class.getName());
        Expression expression = new Expression(){

            public void collectExpressionInfo(ExpressionInfo expressionInfo) {
                expressionInfo.addVariableNameAccess("activeFocusControlId");
            }

            public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
                return EvaluationResult.valueOf((boolean)GamlSearchField.class.getName().equals(iEvaluationContext.getVariable("activeFocusControlId")));
            }
        };
        IHandlerService iHandlerService = WorkbenchHelper.getService(IHandlerService.class);
        iHandlerService.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent executionEvent) {
                GamlSearchField.this.text.selectAll();
                return null;
            }
        }, expression);
        iHandlerService.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent executionEvent) {
                GamlSearchField.this.text.cut();
                return null;
            }
        }, expression);
        iHandlerService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent executionEvent) {
                GamlSearchField.this.text.copy();
                return null;
            }
        }, expression);
        iHandlerService.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent executionEvent) {
                GamlSearchField.this.text.paste();
                return null;
            }
        }, expression);
    }

    public Control createWidget(Composite composite) {
        this.composite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).extendedMargins(0, 5, 5, 5).numColumns(3).equalWidth(false).applyTo(this.composite);
        this.text = this.createText(this.composite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(250, -1).applyTo((Control)this.text);
        new HeapControl().displayOn(this.composite);
        composite.getShell().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                this.closeDropDown();
            }

            public void controlMoved(ControlEvent controlEvent) {
                this.closeDropDown();
            }

            private void closeDropDown() {
                if (GamlSearchField.this.shell == null || GamlSearchField.this.shell.isDisposed() || GamlSearchField.this.text.isDisposed() || !GamlSearchField.this.shell.isVisible()) {
                    return;
                }
                GamlSearchField.this.quickAccessContents.doClose();
            }
        });
        this.quickAccessContents = new GamlAccessContents(){

            @Override
            protected void doClose() {
                GamlSearchField.this.text.setText("");
                GamlSearchField.this.dialogHeight = GamlSearchField.this.shell.getSize().y;
                GamlSearchField.this.dialogWidth = GamlSearchField.this.shell.getSize().x;
                GamlSearchField.this.shell.setVisible(false);
                GamlSearchField.this.removeAccessibleListener();
            }

            @Override
            protected void handleElementSelected(String string, GamlAccessEntry gamlAccessEntry) {
                if (gamlAccessEntry == null) {
                    return;
                }
                IGamlDescription iGamlDescription = gamlAccessEntry.element;
                String string2 = "https://gama-platform.org/search?q=" + iGamlDescription.getName();
                WebHelper.openPage(string2);
            }

            @Override
            public IPopupProvider.PopupText getPopupText() {
                GamlAccessEntry gamlAccessEntry;
                TableItem[] tableItemArray = this.table.getSelection();
                if (tableItemArray != null && tableItemArray.length > 0 && (gamlAccessEntry = (GamlAccessEntry)tableItemArray[0].getData()) != null) {
                    IGamlDescription iGamlDescription = gamlAccessEntry.element;
                    return IPopupProvider.PopupText.with(IGamaColors.BLUE, gamlAccessEntry.provider.document(iGamlDescription));
                }
                return null;
            }

            @Override
            public Shell getControllingShell() {
                return GamlSearchField.this.shell;
            }

            @Override
            public Point getAbsoluteOrigin() {
                return GamlSearchField.this.shell.toDisplay(0, GamlSearchField.this.shell.getSize().y);
            }

            @Override
            public int getPopupWidth() {
                return this.table.getSize().x;
            }
        };
        this.quickAccessContents.hookFilterText(this.text);
        this.shell = new Shell(composite.getShell(), 18448);
        this.shell.setBackground(IGamaColors.VERY_LIGHT_GRAY.color());
        this.shell.setText("");
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.shell);
        this.table = this.quickAccessContents.createTable((Composite)this.shell, Window.getDefaultOrientation());
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                GamlSearchField.this.table.getDisplay().asyncExec(() -> GamlSearchField.this.checkFocusLost(GamlSearchField.this.table, GamlSearchField.this.text));
            }

            public void focusGained(FocusEvent focusEvent) {
                GamlSearchField.this.hookUpCommands();
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                GamlSearchField.this.table.getDisplay().asyncExec(() -> GamlSearchField.this.checkFocusLost(GamlSearchField.this.table, GamlSearchField.this.text));
            }
        });
        this.text.addModifyListener(modifyEvent -> {
            boolean bl;
            boolean bl2 = this.shell.getVisible();
            boolean bl3 = bl = this.text.getText().length() > 0;
            if (!bl2 && bl) {
                this.layoutShell();
                this.addAccessibleListener();
            }
            if (bl2 && !bl) {
                this.removeAccessibleListener();
            }
            if (bl) {
                this.notifyAccessibleTextChanged();
            }
            this.shell.setVisible(bl);
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 27: {
                        GamlSearchField.this.text.setText("");
                        if (GamlSearchField.this.previousFocusControl == null || GamlSearchField.this.previousFocusControl.isDisposed()) break;
                        GamlSearchField.this.previousFocusControl.setFocus();
                        break;
                    }
                    case 0x1000001: {
                        keyEvent.doit = false;
                        break;
                    }
                    case 0x1000002: {
                        keyEvent.doit = false;
                        break;
                    }
                }
                if (!keyEvent.doit) {
                    GamlSearchField.this.notifyAccessibleTextChanged();
                }
            }
        });
        return this.composite;
    }

    private Text createText(Composite composite) {
        Text text = new Text(composite, 640);
        String string = "GAML reference (" + GamaKeyBindings.SEARCH_STRING + ")";
        text.setMessage(string);
        return text;
    }

    private static Monitor getClosestMonitor(Display display, Point point) {
        int n = Integer.MAX_VALUE;
        Monitor[] monitorArray = display.getMonitors();
        Monitor monitor = monitorArray[0];
        Monitor[] monitorArray2 = monitorArray;
        int n2 = monitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Monitor monitor2 = monitorArray2[n3];
            Rectangle rectangle = monitor2.getClientArea();
            if (rectangle.contains(point)) {
                return monitor2;
            }
            int n4 = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)rectangle), (Point)point);
            if (n4 < n) {
                n = n4;
                monitor = monitor2;
            }
            ++n3;
        }
        return monitor;
    }

    private Rectangle getConstrainedShellBounds(Display display, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Point point = new Point(rectangle.x, rectangle.y);
        Monitor monitor = GamlSearchField.getClosestMonitor(display, point);
        Rectangle rectangle3 = monitor.getClientArea();
        if (rectangle2.height > rectangle3.height) {
            rectangle2.height = rectangle3.height;
        }
        if (rectangle2.width > rectangle3.width) {
            rectangle2.width = rectangle3.width;
        }
        rectangle2.x = Math.max(rectangle3.x, Math.min(rectangle2.x, rectangle3.x + rectangle3.width - rectangle2.width));
        rectangle2.y = Math.max(rectangle3.y, Math.min(rectangle2.y, rectangle3.y + rectangle3.height - rectangle2.height));
        return rectangle2;
    }

    void layoutShell() {
        Display display = this.text.getDisplay();
        Rectangle rectangle = this.text.getBounds();
        Rectangle rectangle2 = display.map((Control)this.text, null, rectangle);
        int n = this.quickAccessContents.maxDefinitionWidth + this.quickAccessContents.maxProviderWidth;
        int n2 = this.dialogWidth == -1 ? n : this.dialogWidth;
        int n3 = Math.max(n2, rectangle2.width);
        int n4 = this.dialogHeight == -1 ? 400 : this.dialogHeight;
        Rectangle rectangle3 = this.text.getShell().getBounds();
        if (rectangle2.x + n3 > rectangle3.x + rectangle3.width) {
            rectangle2.x = Math.max(rectangle3.x, rectangle2.x + rectangle2.width - n3);
        }
        this.shell.setBounds(this.getConstrainedShellBounds(display, new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height, n3, n4)));
        this.shell.layout();
    }

    public void activate(Control control) {
        this.previousFocusControl = control;
        if (!this.shell.isVisible()) {
            this.layoutShell();
            this.shell.setVisible(true);
            this.addAccessibleListener();
            this.quickAccessContents.refresh(this.text.getText().toLowerCase());
        }
    }

    protected void checkFocusLost(Table table, Text text) {
        if (!(this.shell.isDisposed() || table.isDisposed() || text.isDisposed())) {
            if (table.getDisplay().getActiveShell() == table.getShell()) {
                text.setFocus();
                return;
            }
            if (!(this.shell.isFocusControl() || table.isFocusControl() || text.isFocusControl())) {
                this.quickAccessContents.doClose();
            }
        }
    }

    private void addAccessibleListener() {
        if (this.accessibleListener == null) {
            this.accessibleListener = new AccessibleAdapter(){

                public void getName(AccessibleEvent accessibleEvent) {
                    accessibleEvent.result = GamlSearchField.this.selectedString;
                }
            };
            this.text.getAccessible().addAccessibleListener((AccessibleListener)this.accessibleListener);
        }
    }

    void removeAccessibleListener() {
        if (this.accessibleListener != null) {
            this.text.getAccessible().removeAccessibleListener((AccessibleListener)this.accessibleListener);
            this.accessibleListener = null;
        }
        this.selectedString = "";
    }

    void notifyAccessibleTextChanged() {
        if (this.table.getSelection().length == 0) {
            return;
        }
        TableItem tableItem = this.table.getSelection()[0];
        this.selectedString = NLS.bind((String)"{0}: {1}", (Object)tableItem.getText(0), (Object)tableItem.getText(1));
        this.text.getAccessible().sendEvent(32780, null);
    }

    public void search() {
        ISelection iSelection;
        ISelectionProvider iSelectionProvider;
        IEditorPart iEditorPart;
        IWorkbenchPartSite iWorkbenchPartSite;
        IWorkbenchPart iWorkbenchPart = WorkbenchHelper.getActivePart();
        if (iWorkbenchPart instanceof IEditorPart && (iWorkbenchPartSite = (iEditorPart = (IEditorPart)iWorkbenchPart).getSite()) != null && (iSelectionProvider = iWorkbenchPartSite.getSelectionProvider()) != null && (iSelection = iSelectionProvider.getSelection()) instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)iSelection;
            this.text.setText(textSelection.getText());
        }
        this.activate(null);
        this.text.setFocus();
    }

    public static Control installOn(Composite composite) {
        INSTANCE = new GamlSearchField();
        return INSTANCE.createWidget(composite);
    }
}

