/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.resources;

import gama.core.util.GamaColor;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;

public class GamaColors {
    static HashMap<RGB, GamaUIColor> colors = new HashMap();

    static org.eclipse.swt.graphics.Color computeInactive(org.eclipse.swt.graphics.Color color) {
        RGB rGB = color.getRGB();
        float[] fArray = rGB.getHSB();
        float[] fArray2 = new float[]{fArray[0], fArray[1] / 2.0f, Math.min(1.0f, fArray[2] + 0.2f)};
        RGB rGB2 = new RGB(fArray2[0], fArray2[1], fArray2[2]);
        return GamaColors.getColor(rGB2.red, rGB2.green, rGB2.blue);
    }

    static org.eclipse.swt.graphics.Color computeDarker(org.eclipse.swt.graphics.Color color) {
        RGB rGB = color.getRGB();
        float[] fArray = rGB.getHSB();
        float[] fArray2 = new float[]{fArray[0], fArray[1], Math.max(0.0f, fArray[2] - 0.1f)};
        RGB rGB2 = new RGB(fArray2[0], fArray2[1], fArray2[2]);
        return GamaColors.getColor(rGB2.red, rGB2.green, rGB2.blue);
    }

    static org.eclipse.swt.graphics.Color computeReverse(org.eclipse.swt.graphics.Color color) {
        RGB rGB = color.getRGB();
        return GamaColors.getColor(255 - rGB.red, 255 - rGB.green, 255 - rGB.blue);
    }

    static org.eclipse.swt.graphics.Color computeLighter(org.eclipse.swt.graphics.Color color) {
        RGB rGB = color.getRGB();
        float[] fArray = rGB.getHSB();
        float[] fArray2 = new float[]{fArray[0], fArray[1], Math.min(1.0f, fArray[2] + 0.2f)};
        RGB rGB2 = new RGB(fArray2[0], fArray2[1], fArray2[2]);
        return GamaColors.getColor(rGB2.red, rGB2.green, rGB2.blue);
    }

    static org.eclipse.swt.graphics.Color computeGray(org.eclipse.swt.graphics.Color color) {
        RGB rGB = color.getRGB();
        float[] fArray = rGB.getHSB();
        float[] fArray2 = new float[]{fArray[0], 0.0f, fArray[2]};
        RGB rGB2 = new RGB(fArray2[0], fArray2[1], fArray2[2]);
        return GamaColors.getColor(rGB2.red, rGB2.green, rGB2.blue);
    }

    private static org.eclipse.swt.graphics.Color getColor(int n, int n2, int n3) {
        return new org.eclipse.swt.graphics.Color((Device)WorkbenchHelper.getDisplay(), n, n2, n3);
    }

    public static GamaUIColor get(Color color) {
        if (color == null) {
            return null;
        }
        return GamaColors.get(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static GamaUIColor get(RGB rGB) {
        if (rGB == null) {
            return null;
        }
        GamaUIColor gamaUIColor = colors.get(rGB);
        if (gamaUIColor == null) {
            org.eclipse.swt.graphics.Color color = GamaColors.getColor(rGB.red, rGB.green, rGB.blue);
            gamaUIColor = new GamaUIColor(color);
            colors.put(rGB, gamaUIColor);
        }
        return gamaUIColor;
    }

    public static GamaUIColor get(org.eclipse.swt.graphics.Color color) {
        if (color == null) {
            return null;
        }
        return GamaColors.get(color.getRGB());
    }

    public static GamaUIColor get(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n < 0 ? 0 : (n5 = n > 255 ? 255 : n);
        int n7 = n2 < 0 ? 0 : (n4 = n2 > 255 ? 255 : n2);
        int n8 = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
        RGB rGB = new RGB(n5, n4, n8);
        return GamaColors.get(rGB);
    }

    public static org.eclipse.swt.graphics.Color system(int n) {
        return WorkbenchHelper.getDisplay().getSystemColor(n);
    }

    public static GamaUIColor get(int ... nArray) {
        if (nArray.length >= 3) {
            return GamaColors.get(nArray[0], nArray[1], nArray[2]);
        }
        int n = nArray[0];
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return GamaColors.get(n2, n3, n4);
    }

    public static GamaUIColor get(GamaIcon gamaIcon) {
        Image image = gamaIcon.image();
        ImageData imageData = image.getImageData();
        PaletteData paletteData = imageData.palette;
        int n = imageData.getPixel(0, 0);
        return GamaColors.get(paletteData.getRGB(n));
    }

    public static boolean isDark(org.eclipse.swt.graphics.Color color) {
        return GamaColors.luminanceOf(color) < 130;
    }

    public static int luminanceOf(org.eclipse.swt.graphics.Color color) {
        return (int)(0.299 * (double)color.getRed() * (double)color.getRed() / 255.0 + 0.587 * (double)color.getGreen() * (double)color.getGreen() / 255.0 + 0.114 * (double)color.getBlue() * (double)color.getBlue() / 255.0);
    }

    public static Color toAwtColor(org.eclipse.swt.graphics.Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static org.eclipse.swt.graphics.Color toSwtColor(Color color) {
        if (color == null) {
            return GamaColors.toSwtColor(Color.BLACK);
        }
        return new org.eclipse.swt.graphics.Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static GamaColor toGamaColor(org.eclipse.swt.graphics.Color color) {
        return GamaColor.get((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
    }

    public static GamaColor toGamaColor(RGB rGB) {
        if (rGB == null) {
            return GamaColor.get((int)0);
        }
        return GamaColor.get((int)rGB.red, (int)rGB.green, (int)rGB.blue);
    }

    public static GamaUIColor getTextColorForBackground(org.eclipse.swt.graphics.Color color) {
        return GamaColors.isDark(color) ? IGamaColors.WHITE : IGamaColors.BLACK;
    }

    public static GamaUIColor getTextColorForBackground(GamaUIColor gamaUIColor) {
        return GamaColors.getTextColorForBackground(gamaUIColor.color());
    }

    public static String getCSSProperty(String string, GamaUIColor gamaUIColor) {
        return ThemeHelper.getCSSProperty((String)string, (org.eclipse.swt.graphics.Color)gamaUIColor.color());
    }

    public static void setBackground(org.eclipse.swt.graphics.Color color, Control ... controlArray) {
        String string = ThemeHelper.getCSSProperty((String)"background-color", (org.eclipse.swt.graphics.Color)color);
        Control[] controlArray2 = controlArray;
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            if (control != null) {
                control.setBackground(color);
                control.setData("style", (Object)(color == null ? null : string));
            }
            ++n2;
        }
    }

    public static void setForeground(org.eclipse.swt.graphics.Color color, Control ... controlArray) {
        String string = ThemeHelper.getCSSProperty((String)"color", (org.eclipse.swt.graphics.Color)color);
        Control[] controlArray2 = controlArray;
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            if (control != null) {
                control.setForeground(color);
                control.setData("style", (Object)(color == null ? null : string));
            }
            ++n2;
        }
    }

    public static void setBackAndForeground(org.eclipse.swt.graphics.Color color, org.eclipse.swt.graphics.Color color2, Control ... controlArray) {
        Control[] controlArray2 = controlArray;
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            if (control != null) {
                if (color == null) {
                    GamaColors.setForeground(color2, control);
                } else if (color2 == null) {
                    GamaColors.setBackground(color, control);
                } else {
                    control.setBackground(color);
                    control.setForeground(color2);
                    control.setData("style", (Object)(ThemeHelper.getCSSProperty((String)"background-color", (org.eclipse.swt.graphics.Color)color) + ThemeHelper.getCSSProperty((String)"color", (org.eclipse.swt.graphics.Color)color2)));
                }
            }
            ++n2;
        }
    }

    public static class GamaUIColor {
        org.eclipse.swt.graphics.Color active;
        org.eclipse.swt.graphics.Color inactive;
        org.eclipse.swt.graphics.Color darker;
        org.eclipse.swt.graphics.Color gray;
        org.eclipse.swt.graphics.Color lighter;
        org.eclipse.swt.graphics.Color reverse;

        public GamaUIColor(org.eclipse.swt.graphics.Color color) {
            this.active = color;
        }

        public GamaUIColor validate() {
            return this;
        }

        public String toString() {
            return this.active.getRed() + ", " + this.active.getGreen() + ", " + this.active.getBlue();
        }

        public boolean isDark() {
            return GamaColors.isDark(this.active);
        }

        public GamaUIColor(org.eclipse.swt.graphics.Color color, org.eclipse.swt.graphics.Color color2) {
            this.active = color;
            this.inactive = color2;
        }

        public org.eclipse.swt.graphics.Color color() {
            return this.active;
        }

        public org.eclipse.swt.graphics.Color inactive() {
            if (this.inactive == null) {
                this.inactive = GamaColors.computeInactive(this.active);
            }
            return this.inactive;
        }

        public org.eclipse.swt.graphics.Color darker() {
            if (this.darker == null) {
                this.darker = GamaColors.computeDarker(this.active);
            }
            return this.darker;
        }

        public org.eclipse.swt.graphics.Color lighter() {
            if (this.lighter == null) {
                this.lighter = GamaColors.computeLighter(this.active);
            }
            return this.lighter;
        }

        public RGB getRGB() {
            return this.active.getRGB();
        }

        public GamaColor gamaColor() {
            return GamaColor.get((int)this.active.getRed(), (int)this.active.getGreen(), (int)this.active.getBlue(), (int)this.active.getAlpha());
        }
    }
}

