/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import gama.ui.shared.views.toolbar.Selector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class GamaToolbar2
extends Composite {
    private GamaToolbarSimple left;
    private GamaToolbarSimple right;
    private boolean hasTooltip;
    boolean isVisible;
    private GamaToolbarFactory.ToggleAction toggle;

    public GamaToolbar2(Composite composite, int n) {
        super(composite, 0);
        DEBUG.ON();
        this.isVisible = true;
        this.createLayout();
        this.createToolbars();
    }

    public void setBackground(Color color) {
    }

    public void setBackgroundColor(Color color) {
        Color color2 = color;
        if (color2 == null) {
            color2 = ThemeHelper.isDark() ? this.getShell().getBackground() : IGamaColors.WHITE.color();
        }
        super.setBackground(color2);
        GamaColors.setBackground(color2, new Control[]{this, this.left, this.right});
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void createLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
    }

    public void createToolbars() {
        this.left = new GamaToolbarSimple(this, 8913218);
        GridData gridData = new GridData(16384, 0x1000000, true, true);
        this.left.setLayoutData(gridData);
        this.right = new GamaToolbarSimple(this, 0x880100);
        gridData = new GridData(131072, 4, true, false);
        this.right.setLayoutData(gridData);
        this.setBackgroundColor(null);
    }

    public void noLeftToolbar() {
        GridData gridData = (GridData)this.left.getLayoutData();
        gridData.minimumWidth = 0;
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 0;
        gridData = (GridData)this.right.getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
    }

    protected void checkSubclass() {
    }

    public ToolItem sep(int n, int n2) {
        return this.sep(n2);
    }

    public ToolItem sep(int n) {
        return new ToolItem((ToolBar)(n == 16384 ? this.left : this.right), 2);
    }

    public ToolItem status(Image image, String string, GamaColors.GamaUIColor gamaUIColor, int n) {
        this.wipe(n, true);
        ToolItem toolItem = this.button(gamaUIColor, string, image, n);
        this.getToolbar(n).requestLayout();
        return toolItem;
    }

    public ToolItem status(Image image, String string, Selector selector, GamaColors.GamaUIColor gamaUIColor, int n) {
        this.wipe(n, true);
        ToolItem toolItem = this.button(gamaUIColor, string, image, n);
        ((FlatButton)toolItem.getControl()).addSelectionListener(selector);
        this.requestLayout();
        return toolItem;
    }

    public ToolItem tooltip(String string, GamaColors.GamaUIColor gamaUIColor, int n) {
        BufferedReader bufferedReader;
        Color color;
        Color color2 = color = gamaUIColor == null ? this.getBackground() : gamaUIColor.color();
        if (string == null) {
            return null;
        }
        this.hasTooltip = true;
        GamaToolbarSimple gamaToolbarSimple = this.getToolbar(n);
        this.wipe(n, false);
        GamaToolbarSimple gamaToolbarSimple2 = gamaToolbarSimple == this.right ? this.left : this.right;
        int n2 = this.getSize().x;
        int n3 = gamaToolbarSimple.getSize().x;
        int n4 = gamaToolbarSimple2.getSize().x;
        int n5 = n2 - n3 - n4 - 50;
        gamaToolbarSimple.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label((Composite)gamaToolbarSimple, 16448);
        GridData gridData = new GridData(4, 4, true, false);
        label.setLayoutData((Object)gridData);
        label.setForeground(GamaColors.getTextColorForBackground(color).color());
        StringBuilder stringBuilder = new StringBuilder();
        try {
            bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!string2.trim().isEmpty()) {
                    stringBuilder.append(string2).append(System.lineSeparator());
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {}
        label.setText(stringBuilder.toString());
        label.setBackground(color);
        bufferedReader = this.control((Control)label, n5, n);
        this.requestLayout();
        return bufferedReader;
    }

    public ToolItem check(String string, String string2, String string3, Selector selector, int n) {
        return this.create(string, string2, string3, selector, 32, false, null, n);
    }

    public ToolItem check(GamaCommand gamaCommand, int n) {
        return this.check(gamaCommand.getImage(), gamaCommand.getText(), gamaCommand.getTooltip(), gamaCommand.getListener(), n);
    }

    public ToolItem button(String string, String string2, String string3, Selector selector, int n) {
        return this.create(string, string2, string3, selector, 8, false, null, n);
    }

    public ToolItem button(GamaCommand gamaCommand, int n) {
        return this.button(gamaCommand.getImage(), gamaCommand.getText(), gamaCommand.getTooltip(), gamaCommand.getListener(), n);
    }

    public ToolItem button(GamaColors.GamaUIColor gamaUIColor, String string, Selector selector, int n) {
        FlatButton flatButton = FlatButton.button((Composite)(n == 16384 ? this.left : this.right), gamaUIColor, string, null);
        flatButton.addSelectionListener(selector);
        return this.control((Control)flatButton, flatButton.computeSize((int)-1, (int)flatButton.getHeight(), (boolean)false).x + 4, n);
    }

    public ToolItem button(GamaColors.GamaUIColor gamaUIColor, String string, Image image, int n) {
        FlatButton flatButton = FlatButton.button((Composite)(n == 16384 ? this.left : this.right), gamaUIColor, string, image);
        return this.control((Control)flatButton, flatButton.computeSize((int)-1, (int)flatButton.getHeight(), (boolean)false).x + 4, n);
    }

    public ToolItem button(GamaColors.GamaUIColor gamaUIColor, String string, Image image, Selector selector, int n) {
        FlatButton flatButton = FlatButton.button((Composite)(n == 16384 ? this.left : this.right), gamaUIColor, string, image);
        flatButton.addSelectionListener(selector);
        return this.control((Control)flatButton, flatButton.computeSize((int)-1, (int)flatButton.getHeight(), (boolean)false).x + 4, n);
    }

    public ToolItem menu(GamaColors.GamaUIColor gamaUIColor, String string, int n) {
        FlatButton flatButton = FlatButton.menu((Composite)(n == 16384 ? this.left : this.right), gamaUIColor, string);
        return this.control((Control)flatButton, flatButton.computeSize((int)-1, (int)flatButton.getHeight(), (boolean)false).x + 4, n);
    }

    public ToolItem menu(String string, String string2, String string3, Selector selector, int n) {
        return this.create(string, string2, string3, selector, 4, false, null, n);
    }

    public ToolItem control(Control control, int n, int n2) {
        ToolItem toolItem = this.create(null, null, null, null, 2, false, control, n2);
        if (n == -1) {
            toolItem.setWidth(control.computeSize((int)-1, (int)-1).x);
        } else {
            toolItem.setWidth(n);
        }
        return toolItem;
    }

    public void requestLayout() {
        this.left.requestLayout();
        this.right.requestLayout();
        super.requestLayout();
        this.getParent().requestLayout();
    }

    public void wipe(int n, boolean bl) {
        ToolItem[] toolItemArray;
        ToolItem[] toolItemArray2 = toolItemArray = this.getToolbar(n).getItems();
        int n2 = toolItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ToolItem toolItem = toolItemArray2[n3];
            Control control = toolItem.getControl();
            if (control == null && bl || control != null) {
                if (control != null) {
                    control.dispose();
                }
                toolItem.dispose();
            }
            ++n3;
        }
        this.normalizeToolbars();
        this.requestLayout();
    }

    public void item(IContributionItem iContributionItem, int n) {
        iContributionItem.fill((ToolBar)this.getToolbar(n), this.getToolbar(n).getItemCount());
    }

    private ToolItem create(String string, String string2, String string3, SelectionListener selectionListener, int n, boolean bl, Control control, int n2) {
        Object object;
        Object object2;
        GamaToolbarSimple gamaToolbarSimple = this.getToolbar(n2);
        if (gamaToolbarSimple.getItemCount() == 0 && PlatformHelper.isWindows() && control != null) {
            object2 = GamaIcon.ofSize(2, 24);
            object = new ToolItem((ToolBar)gamaToolbarSimple, 0);
            Image image = ((GamaIcon)object2).image();
            object.setImage(image);
            object.setDisabledImage(image);
            object.setEnabled(false);
        }
        object2 = new ToolItem((ToolBar)gamaToolbarSimple, n);
        if (string2 != null && bl) {
            object2.setText(string2);
        }
        if (string3 != null) {
            object2.setToolTipText(string3);
        }
        if (string != null) {
            object2.setData((Object)string);
            object = GamaIcon.named(string);
            object2.setImage(((GamaIcon)object).image());
            object2.setDisabledImage(((GamaIcon)object).disabled());
        }
        if (selectionListener != null) {
            if (n == 32) {
                object2.addSelectionListener(arg_0 -> this.lambda$0((ToolItem)object2, selectionListener, arg_0));
            } else {
                object2.addSelectionListener(selectionListener);
            }
        }
        if (control != null) {
            object2.setControl(control);
            control.requestLayout();
        }
        this.normalizeToolbars();
        gamaToolbarSimple.requestLayout();
        return object2;
    }

    private void normalizeToolbars() {
        int n = 0;
        ToolItem[] toolItemArray = this.right.getItems();
        int n2 = toolItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ToolItem toolItem = toolItemArray[n3];
            n += toolItem.getWidth();
            ++n3;
        }
        ((GridData)this.right.getLayoutData()).minimumWidth = n;
    }

    public GamaToolbarSimple getToolbar(int n) {
        return n == 16384 ? this.left : this.right;
    }

    public boolean hasTooltip() {
        return this.hasTooltip;
    }

    public void setToogleAction(GamaToolbarFactory.ToggleAction toggleAction) {
        this.toggle = toggleAction;
    }

    public void hide() {
        this.isVisible = true;
        this.toggle.run();
    }

    public void show() {
        this.isVisible = false;
        this.toggle.run();
    }

    private void checkSelectionIcon(ToolItem toolItem) {
        String string = (String)toolItem.getData();
        if (string == null) {
            return;
        }
        if (PlatformHelper.isMac() && GamaColors.isDark(this.getBackground()) && !ThemeHelper.isDark()) {
            if (toolItem.getSelection()) {
                toolItem.setImage(GamaIcon.named(string).checked());
            } else {
                toolItem.setImage(GamaIcon.named(string).image());
            }
        }
    }

    public void setSelection(ToolItem toolItem, boolean bl) {
        toolItem.setSelection(bl);
        this.checkSelectionIcon(toolItem);
    }

    private /* synthetic */ void lambda$0(ToolItem toolItem, SelectionListener selectionListener, SelectionEvent selectionEvent) {
        this.checkSelectionIcon(toolItem);
        selectionListener.widgetSelected(selectionEvent);
    }
}

