/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.views.toolbar.Selector;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class GamaCommand {
    String text;
    String tooltip;
    String image;
    Selector selector;

    public static GamaCommand build(String string, String string2, String string3, Selector selector) {
        return new GamaCommand(string, string2, string3, selector);
    }

    public GamaCommand(String string, String string2, String string3, Selector selector) {
        this.text = string2;
        this.tooltip = string3;
        this.image = string;
        this.selector = selector;
    }

    public GamaCommand(String string, String string2, Selector selector) {
        this(string, string2, string2, selector);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String string) {
        this.image = string;
    }

    public Selector getListener() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public String getId() {
        return this.image;
    }

    public Action toAction() {
        Action action = new Action(this.text){

            public void runWithEvent(Event event) {
                GamaCommand.this.selector.widgetSelected(new SelectionEvent(event));
            }
        };
        action.setImageDescriptor(GamaIcon.named(this.image).descriptor());
        action.setToolTipText(this.tooltip);
        action.setId(this.image);
        return action;
    }

    public Action toCheckAction() {
        Action action = new Action(this.text, 2){

            public void runWithEvent(Event event) {
                GamaCommand.this.selector.widgetSelected(new SelectionEvent(event));
            }
        };
        action.setImageDescriptor(GamaIcon.named(this.image).descriptor());
        action.setToolTipText(this.tooltip);
        action.setId(this.image);
        return action;
    }

    public ToolItem toItem(ToolBar toolBar) {
        return this.toItem(toolBar, this.selector);
    }

    public ToolItem toItem(ToolBar toolBar, Selector selector) {
        ToolItem toolItem = new ToolItem(toolBar, 0x800008);
        toolItem.setToolTipText(this.tooltip);
        if (this.image != null) {
            GamaIcon gamaIcon = GamaIcon.named(this.image);
            toolItem.setImage(gamaIcon.image());
            toolItem.setDisabledImage(gamaIcon.disabled());
        }
        toolItem.addSelectionListener((SelectionListener)selector);
        return toolItem;
    }

    public MenuItem toItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        if (this.text != null) {
            menuItem.setText(this.text);
        }
        menuItem.setToolTipText(this.tooltip);
        if (this.image != null) {
            menuItem.setImage(GamaIcon.named(this.image).image());
        }
        menuItem.addSelectionListener((SelectionListener)this.selector);
        return menuItem;
    }

    public Button toButton(Composite composite, Selector selector) {
        Button button = new Button(composite, 0x40800008);
        if (this.text != null) {
            button.setText(this.text);
        }
        button.setToolTipText(this.tooltip);
        if (this.image != null) {
            button.setImage(GamaIcon.named(this.image).image());
        }
        button.addSelectionListener((SelectionListener)selector);
        return button;
    }

    public Label toLabel(Composite composite, MouseListener mouseListener) {
        Label label = new Label(composite, 0);
        if (this.text != null) {
            label.setText(this.text);
        }
        label.setToolTipText(this.tooltip);
        if (this.image != null) {
            label.setImage(GamaIcon.named(this.image).image());
        }
        label.addMouseListener(mouseListener);
        return label;
    }

    public Hyperlink toLink(Composite composite, Selector selector) {
        if (this.image == null) {
            Hyperlink hyperlink = new Hyperlink(composite, 0x800000);
            hyperlink.setText(this.text);
            hyperlink.setToolTipText(this.tooltip);
            hyperlink.setUnderlined(false);
            return hyperlink;
        }
        ImageHyperlink imageHyperlink = new ImageHyperlink(composite, 0x800000);
        if (this.text != null) {
            imageHyperlink.setText(this.text);
        }
        imageHyperlink.setToolTipText(this.tooltip);
        imageHyperlink.setImage(GamaIcon.named(this.image).image());
        imageHyperlink.setUnderlined(false);
        return imageHyperlink;
    }
}

