/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.access;

import gama.gaml.compilation.GamlIdiomsProvider;
import gama.gaml.interfaces.IGamlDescription;
import gama.ui.shared.access.GamlAccessEntry;
import gama.ui.shared.controls.IPopupProvider;
import gama.ui.shared.controls.Popup2;
import gama.ui.shared.resources.IGamaColors;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class GamlAccessContents
implements IPopupProvider {
    private static final int[][] EMPTY_INDICES = new int[0][];
    protected Text filterText;
    protected Table table;
    TextLayout textLayout;
    Popup2 popup;
    public int maxProviderWidth = 145;
    public int maxDefinitionWidth = 1000;

    public void refresh(String string) {
        if (this.table != null) {
            boolean bl = string.length() == 0;
            List<GamlAccessEntry>[] listArray = this.computeMatchingEntries(string);
            int n = this.refreshTable(listArray);
            if (this.table.getItemCount() > 0) {
                this.table.setSelection(n);
            } else if (bl) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(0, "");
                tableItem.setText(1, "Start typing to get results");
                tableItem.setForeground(1, IGamaColors.GRAY_LABEL.color());
            } else {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(0, "No result");
                tableItem.setForeground(0, IGamaColors.GRAY_LABEL.color());
            }
        }
    }

    private int refreshTable(List<GamlAccessEntry>[] listArray) {
        if (this.table.getItemCount() > listArray.length && this.table.getItemCount() - listArray.length > 20) {
            this.table.removeAll();
        }
        TableItem[] tableItemArray = this.table.getItems();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < GamlIdiomsProvider.PROVIDERS.size()) {
            if (listArray[n3] != null) {
                boolean bl = true;
                Iterator<GamlAccessEntry> iterator = listArray[n3].iterator();
                while (iterator.hasNext()) {
                    TableItem tableItem;
                    GamlAccessEntry gamlAccessEntry = iterator.next();
                    gamlAccessEntry.firstInCategory = bl;
                    bl = false;
                    if (!iterator.hasNext()) {
                        gamlAccessEntry.lastInCategory = true;
                    }
                    if (n2 < tableItemArray.length) {
                        tableItem = tableItemArray[n2];
                        this.table.clear(n2);
                    } else {
                        tableItem = new TableItem(this.table, 0);
                    }
                    tableItem.setData((Object)gamlAccessEntry);
                    tableItem.setText(0, gamlAccessEntry.provider.name);
                    tableItem.setText(1, gamlAccessEntry.element.getTitle());
                    ++n2;
                }
            }
            ++n3;
        }
        if (n2 < tableItemArray.length) {
            this.table.remove(n2, tableItemArray.length - 1);
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    private List<GamlAccessEntry>[] computeMatchingEntries(String string) {
        boolean bl;
        List[] listArray = new List[GamlIdiomsProvider.PROVIDERS.size()];
        int[] nArray = new int[GamlIdiomsProvider.PROVIDERS.size()];
        do {
            bl = true;
            int n = 0;
            while (n < GamlIdiomsProvider.PROVIDERS.size()) {
                if (listArray[n] == null) {
                    listArray[n] = new ArrayList();
                    nArray[n] = 0;
                }
                GamlIdiomsProvider gamlIdiomsProvider = (GamlIdiomsProvider)GamlIdiomsProvider.PROVIDERS.get(n);
                if (string.length() > 0) {
                    IGamlDescription[] iGamlDescriptionArray = gamlIdiomsProvider.getSortedElements();
                    ArrayList<GamlAccessEntry> arrayList = new ArrayList<GamlAccessEntry>();
                    int n2 = nArray[n];
                    while (n2 < iGamlDescriptionArray.length) {
                        IGamlDescription iGamlDescription = iGamlDescriptionArray[n2];
                        Object object = null;
                        GamlAccessEntry gamlAccessEntry = this.match(iGamlDescription, string, gamlIdiomsProvider);
                        if (gamlAccessEntry != null) {
                            if (gamlAccessEntry.getMatchQuality() <= 5) {
                                object = gamlAccessEntry;
                            } else {
                                arrayList.add(gamlAccessEntry);
                            }
                        }
                        if (this.entryEnabled((GamlIdiomsProvider<?>)gamlIdiomsProvider, (GamlAccessEntry)object)) {
                            listArray[n].add(object);
                        }
                        ++n2;
                    }
                    nArray[n] = n2;
                    for (GamlAccessEntry gamlAccessEntry : arrayList) {
                        listArray[n].add(gamlAccessEntry);
                    }
                    if (n2 < iGamlDescriptionArray.length) {
                        bl = false;
                    }
                }
                ++n;
            }
        } while (!bl);
        return listArray;
    }

    public GamlAccessEntry match(IGamlDescription iGamlDescription, String string, GamlIdiomsProvider<?> gamlIdiomsProvider) {
        String string2 = iGamlDescription.getTitle();
        int n = string2.toLowerCase().indexOf(string);
        if (n != -1) {
            int n2 = string2.toLowerCase().equals(string) ? 0 : (string2.toLowerCase().startsWith(string) ? 5 : 10);
            return new GamlAccessEntry(iGamlDescription, gamlIdiomsProvider, new int[][]{{n, n + string.length() - 1}}, EMPTY_INDICES, n2);
        }
        String string3 = gamlIdiomsProvider.name + " " + iGamlDescription.getTitle();
        n = string3.toLowerCase().indexOf(string);
        if (n != -1) {
            int n3 = n + string.length() - gamlIdiomsProvider.name.length() - 1;
            if (n3 > 0) {
                int[][] nArrayArray = new int[1][];
                int[] nArray = new int[2];
                nArray[1] = n3 - 1;
                nArrayArray[0] = nArray;
                return new GamlAccessEntry(iGamlDescription, gamlIdiomsProvider, nArrayArray, new int[][]{{n, n + string.length() - 1}}, 10);
            }
            return new GamlAccessEntry(iGamlDescription, gamlIdiomsProvider, EMPTY_INDICES, new int[][]{{n, n + string.length() - 1}}, 10);
        }
        return null;
    }

    private boolean entryEnabled(GamlIdiomsProvider<?> gamlIdiomsProvider, GamlAccessEntry gamlAccessEntry) {
        return gamlAccessEntry != null;
    }

    private void doDispose() {
        if (this.textLayout != null && !this.textLayout.isDisposed()) {
            this.textLayout.dispose();
        }
    }

    protected abstract void handleElementSelected(String var1, GamlAccessEntry var2);

    void handleClick() {
    }

    void handleSelection() {
        GamlAccessEntry gamlAccessEntry;
        String string = this.filterText.getText().toLowerCase();
        if (this.table.getSelectionCount() == 1 && (gamlAccessEntry = (GamlAccessEntry)this.table.getSelection()[0].getData()) != null) {
            this.doClose();
            this.handleElementSelected(string, gamlAccessEntry);
        }
    }

    protected abstract void doClose();

    public void hookFilterText(Text text) {
        this.filterText = text;
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        GamlAccessContents.this.handleSelection();
                        break;
                    }
                    case 0x1000002: {
                        int n = GamlAccessContents.this.table.getSelectionIndex();
                        if (n == -1 || GamlAccessContents.this.table.getItemCount() <= n + 1) break;
                        GamlAccessContents.this.table.setSelection(n + 1);
                        break;
                    }
                    case 0x1000001: {
                        int n = GamlAccessContents.this.table.getSelectionIndex();
                        if (n == -1 || n < 1) break;
                        GamlAccessContents.this.table.setSelection(n - 1);
                        break;
                    }
                    case 27: {
                        GamlAccessContents.this.doClose();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        text.addModifyListener(modifyEvent -> {
            String string = ((Text)modifyEvent.widget).getText().toLowerCase();
            this.refresh(string);
        });
    }

    public Table createTable(Composite composite, int n) {
        composite.addDisposeListener(disposeEvent -> this.doDispose());
        Composite composite2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite2);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite2.setLayout((Layout)tableColumnLayout);
        this.table = new Table(composite2, 65536);
        this.table.setBackground(IGamaColors.VERY_LIGHT_GRAY.color());
        this.table.setLinesVisible(true);
        this.textLayout = new TextLayout((Device)this.table.getDisplay());
        this.textLayout.setOrientation(n);
        this.textLayout.setText("Available categories");
        TableColumn tableColumn = new TableColumn(this.table, 0);
        TableColumn tableColumn2 = new TableColumn(this.table, 0);
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(0, this.maxProviderWidth, false));
        tableColumnLayout.setColumnData((Widget)tableColumn2, (ColumnLayoutData)new ColumnWeightData(0, this.maxDefinitionWidth, false));
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000001 && GamlAccessContents.this.table.getSelectionIndex() == 0) {
                    GamlAccessContents.this.filterText.setFocus();
                } else if (keyEvent.character == '\u001b') {
                    GamlAccessContents.this.doClose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (GamlAccessContents.this.table.getSelectionCount() < 1 || mouseEvent.button != 1) {
                    return;
                }
                if (GamlAccessContents.this.table.equals(mouseEvent.getSource())) {
                    TableItem tableItem = GamlAccessContents.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    TableItem tableItem2 = GamlAccessContents.this.table.getSelection()[0];
                    if (tableItem2.equals(tableItem)) {
                        GamlAccessContents.this.handleClick();
                    }
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (GamlAccessContents.this.table.getSelectionCount() < 1 || mouseEvent.button != 1) {
                    return;
                }
                if (GamlAccessContents.this.table.equals(mouseEvent.getSource())) {
                    TableItem tableItem = GamlAccessContents.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    TableItem tableItem2 = GamlAccessContents.this.table.getSelection()[0];
                    if (tableItem2.equals(tableItem)) {
                        GamlAccessContents.this.handleSelection();
                    }
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){
            TableItem lastItem = null;

            public void mouseMove(MouseEvent mouseEvent) {
                if (GamlAccessContents.this.table.equals(mouseEvent.getSource())) {
                    TableItem tableItem = GamlAccessContents.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    if (tableItem instanceof TableItem) {
                        if (!tableItem.equals(this.lastItem)) {
                            this.lastItem = tableItem;
                            GamlAccessContents.this.table.setSelection(new TableItem[]{this.lastItem});
                            GamlAccessContents.this.popup.display();
                        }
                    } else if (tableItem == null) {
                        this.lastItem = null;
                    }
                }
            }
        });
        this.table.addMouseTrackListener(new MouseTrackListener(){
            TableItem lastItem = null;

            public void mouseHover(MouseEvent mouseEvent) {
                if (GamlAccessContents.this.table.equals(mouseEvent.getSource())) {
                    TableItem tableItem;
                    if (this.lastItem == null ^ (tableItem = GamlAccessContents.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y))) == null) {
                        GamlAccessContents.this.table.setCursor(tableItem == null ? null : GamlAccessContents.this.table.getDisplay().getSystemCursor(21));
                    }
                    if (tableItem instanceof TableItem) {
                        if (!tableItem.equals(this.lastItem)) {
                            this.lastItem = tableItem;
                            GamlAccessContents.this.table.setSelection(new TableItem[]{this.lastItem});
                            GamlAccessContents.this.popup.display();
                        }
                    } else if (tableItem == null) {
                        this.lastItem = null;
                    }
                }
            }

            public void mouseEnter(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GamlAccessContents.this.handleSelection();
            }
        });
        this.popup = new Popup2(this, new Widget[]{this.table});
        Listener listener = event -> {
            GamlAccessEntry gamlAccessEntry = (GamlAccessEntry)event.item.getData();
            if (gamlAccessEntry != null) {
                switch (event.type) {
                    case 41: {
                        gamlAccessEntry.measure(event, this.textLayout);
                        break;
                    }
                    case 42: {
                        gamlAccessEntry.paint(event, this.textLayout);
                        break;
                    }
                    case 40: {
                        gamlAccessEntry.erase(event);
                    }
                }
            }
        };
        this.table.addListener(41, listener);
        this.table.addListener(40, listener);
        this.table.addListener(42, listener);
        return this.table;
    }
}

