/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views;

import com.google.common.collect.Iterables;
import gama.core.common.interfaces.IGamaView;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.outputs.IOutput;
import gama.core.outputs.IOutputManager;
import gama.core.outputs.SimulationOutputManager;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.dev.DEBUG;
import gama.ui.shared.controls.ITooltipDisplayer;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.OutputPartsManager;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public abstract class GamaViewPart
extends ViewPart
implements DisposeListener,
IGamaView,
IToolbarDecoratedView,
ITooltipDisplayer {
    public final List<IOutput> outputs = new ArrayList<IOutput>();
    private Composite parent;
    protected GamaToolbar2 toolbar;
    private Job updateJob;
    private IToolbarDecoratedView.StateListener toolbarUpdater;
    private Composite rootComposite;

    static {
        DEBUG.ON();
    }

    public void reset() {
    }

    @Override
    public void addStateListener(IToolbarDecoratedView.StateListener stateListener) {
        this.toolbarUpdater = stateListener;
    }

    public void updateToolbarState() {
        if (this.toolbarUpdater != null) {
            this.toolbarUpdater.updateToReflectState();
        }
    }

    public void showToolbar(boolean bl) {
        if (this.toolbar != null) {
            if (bl) {
                this.toolbar.show();
            } else {
                this.toolbar.hide();
            }
        }
    }

    @Override
    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.toolbar = gamaToolbar2;
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        int n;
        super.init(iViewSite);
        OutputPartsManager.install();
        String string = iViewSite.getSecondaryId();
        if (string != null && (n = string.indexOf("@@@")) != -1) {
            string = string.substring(0, n);
        }
        String string2 = iViewSite.getId() + (string == null ? "" : string);
        IOutput iOutput = null;
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan != null) {
            IPopulation iPopulation;
            IOutputManager iOutputManager;
            String[] stringArray = Iterables.concat((Iterable)Iterables.transform((Iterable)GAMA.getControllers(), iExperimentController -> iExperimentController.getExperiment().getActiveOutputManagers())).iterator();
            while (stringArray.hasNext()) {
                iOutputManager = (IOutputManager)stringArray.next();
                iOutput = iOutputManager.getOutputWithId(string2);
                if (iOutput != null) break;
            }
            if (iOutput == null && (iOutputManager = GAMA.getExperiment().getCurrentSimulation()) != null && (stringArray = string2.split("#")).length > 1 && (iPopulation = iOutputManager.getExternMicroPopulationFor(stringArray[1] + "." + stringArray[2])) != null) {
                for (IAgent iAgent : iPopulation) {
                    SimulationOutputManager simulationOutputManager;
                    SimulationAgent simulationAgent = ((ExperimentAgent)iAgent).getSimulation();
                    if (simulationAgent == null || (simulationOutputManager = simulationAgent.getOutputManager()) == null) continue;
                    iOutput = simulationOutputManager.getOutputWithId(string);
                }
            }
        } else if (this.shouldBeClosedWhenNoExperiments()) {
            WorkbenchHelper.asyncRun(() -> {
                if (this.shouldBeClosedWhenNoExperiments()) {
                    this.close(GAMA.getRuntimeScope());
                }
            });
        }
        this.addOutput(iOutput);
    }

    protected boolean shouldBeClosedWhenNoExperiments() {
        return true;
    }

    public boolean containsPoint(int n, int n2) {
        Point point = this.rootComposite.toDisplay(0, 0);
        Point point2 = this.rootComposite.getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, point2.x, point2.y);
        return rectangle.contains(n, n2);
    }

    public void createPartControl(Composite composite) {
        this.rootComposite = composite;
        composite.addDisposeListener((DisposeListener)this);
        if (this.needsOutput() && this.getOutput() == null) {
            return;
        }
        this.setParentComposite(GamaToolbarFactory.createToolbars(this, composite));
        this.ownCreatePartControl(this.getParentComposite());
    }

    protected boolean needsOutput() {
        return true;
    }

    public abstract void ownCreatePartControl(Composite var1);

    protected final Job getUpdateJob() {
        if (this.updateJob == null) {
            this.updateJob = this.createUpdateJob();
            if (this.updateJob != null) {
                this.updateJob.setSystem(true);
            }
        }
        return this.updateJob;
    }

    protected abstract Job createUpdateJob();

    public void update(IOutput iOutput) {
        Job job = this.getUpdateJob();
        if (job != null) {
            job.schedule();
            if (GAMA.isSynchronized() && !WorkbenchHelper.isDisplayThread()) {
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {
                    DEBUG.OUT((Object)("Update of " + this.getTitle() + " interrupted."));
                }
            }
        }
    }

    public IOutput getOutput() {
        if (this.outputs.isEmpty()) {
            return null;
        }
        return this.outputs.get(0);
    }

    public void addOutput(IOutput iOutput) {
        if (iOutput == null) {
            return;
        }
        if (!this.outputs.contains(iOutput)) {
            this.outputs.add(iOutput);
        } else if (this.toolbar != null) {
            this.toolbar.wipe(16384, true);
            this.toolbar.wipe(131072, true);
            GamaToolbarFactory.buildToolbar(this, this.toolbar);
        }
    }

    public void setFocus() {
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.toolbar = null;
        this.outputs.clear();
    }

    public void dispose() {
        this.toolbarUpdater = null;
        WorkbenchHelper.run(() -> super.dispose());
    }

    @Override
    public void stopDisplayingTooltips() {
        if (this.toolbar == null || this.toolbar.isDisposed()) {
            return;
        }
        if (this.toolbar.hasTooltip()) {
            this.toolbar.wipe(16384, false);
        }
    }

    @Override
    public void displayTooltip(String string, GamaColors.GamaUIColor gamaUIColor) {
        if (this.toolbar == null || this.toolbar.isDisposed()) {
            return;
        }
        this.toolbar.tooltip(string, gamaUIColor, 16384);
    }

    public void close(IScope iScope) {
        WorkbenchHelper.asyncRun(() -> {
            try {
                ViewsHelper.hideView((IViewPart)this);
                Job job = this.getUpdateJob();
                if (job != null && job.getThread() != null) {
                    job.getThread().interrupt();
                }
            }
            catch (Exception exception) {}
        });
    }

    public void removeOutput(IOutput iOutput) {
        this.outputs.remove(iOutput);
        if (this.outputs.isEmpty()) {
            this.close(iOutput.getScope());
        }
    }

    public void changePartNameWithSimulation(SimulationAgent simulationAgent) {
        String string = this.getPartName();
        int n = string.lastIndexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n == -1) {
            if (simulationAgent.getPopulation().size() > 1) {
                this.setPartName(string + " (" + simulationAgent.getName() + ")");
            }
        } else {
            this.setPartName(this.overlay(string, simulationAgent.getName(), n + 1, n2));
        }
    }

    private String overlay(String string, String string2, int n, int n2) {
        String string3 = string2;
        int n3 = n;
        int n4 = n2;
        if (string == null) {
            return null;
        }
        if (string3 == null) {
            string3 = "";
        }
        int n5 = string.length();
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > n5) {
            n3 = n5;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > n5) {
            n4 = n5;
        }
        if (n3 > n4) {
            int n6 = n3;
            n3 = n4;
            n4 = n6;
        }
        return new StringBuilder(n5 + n3 - n4 + string3.length() + 1).append(string.substring(0, n3)).append(string3).append(string.substring(n4)).toString();
    }

    public void setName(String string) {
        super.setPartName(string);
    }

    public Composite getParentComposite() {
        return this.parent;
    }

    public void setParentComposite(Composite composite) {
        this.parent = composite;
    }

    public boolean isVisible() {
        return true;
    }

    public abstract class GamaUIJob
    extends UIJob {
        public GamaUIJob() {
            super("Updating " + GamaViewPart.this.getPartName());
            this.setSystem(true);
            UpdatePriority updatePriority = this.jobPriority();
            switch (updatePriority) {
                case HIGHEST: {
                    this.setPriority(10);
                    break;
                }
                case LOWEST: {
                    this.setPriority(50);
                    break;
                }
                case HIGH: {
                    this.setPriority(20);
                    break;
                }
                case LOW: {
                    this.setPriority(30);
                }
            }
        }

        protected abstract UpdatePriority jobPriority();
    }

    public static enum UpdatePriority {
        HIGH,
        LOW,
        HIGHEST,
        LOWEST;

    }
}

