/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls;

import gama.dev.DEBUG;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import java.util.EventListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class FlatButton
extends Canvas
implements PaintListener,
Listener {
    static final Image menuImage;
    static final Rectangle menuImageBounds;
    private static final int innerMarginWidth = 5;
    private static final int imagePadding = 5;
    private Image image;
    private boolean addMenuSign;
    private String text;
    private RGB colorCode;
    private int preferredHeight = -1;
    private int minimalHeight = -1;
    private int preferredWidth = -1;
    private boolean enabled = true;
    private boolean hovered = false;
    private boolean down = false;
    private int forcedWidth = -1;
    private int rightPadding = 0;
    private boolean border;

    static {
        DEBUG.OFF();
        menuImage = GamaIcon.named("overlays/small.dropdown").image();
        menuImageBounds = menuImage.getBounds();
    }

    public static FlatButton create(Composite composite, int n) {
        return new FlatButton(composite, n);
    }

    public static FlatButton label(Composite composite, GamaColors.GamaUIColor gamaUIColor, String string) {
        return FlatButton.button(composite, gamaUIColor, string).disabled();
    }

    public static FlatButton label(Composite composite, GamaColors.GamaUIColor gamaUIColor, String string, int n) {
        return FlatButton.create(composite, 0).withWidth(n).setText(string).setColor(gamaUIColor);
    }

    public static FlatButton label(Composite composite, GamaColors.GamaUIColor gamaUIColor, String string, Image image) {
        return FlatButton.label(composite, gamaUIColor, string).setImage(image);
    }

    public static FlatButton button(Composite composite, GamaColors.GamaUIColor gamaUIColor, String string) {
        return FlatButton.create(composite, 0).setText(string).setColor(gamaUIColor);
    }

    public static FlatButton button(Composite composite, GamaColors.GamaUIColor gamaUIColor, String string, Image image) {
        return FlatButton.button(composite, gamaUIColor, string).setImage(image);
    }

    public static FlatButton menu(Composite composite, GamaColors.GamaUIColor gamaUIColor, String string) {
        return FlatButton.button(composite, gamaUIColor, string).addMenuSign();
    }

    private FlatButton(Composite composite, int n) {
        super(composite, n | 0x20000000);
        this.addPaintListener(this);
        this.addListeners();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 7: {
                this.doHover(false);
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 32: {
                this.doHover(true);
                event.doit = true;
                break;
            }
            case 4: {
                if (event.button != 1 || !this.getClientArea().contains(event.x, event.y)) break;
                this.doButtonUp();
                break;
            }
            case 3: {
                if (event.button != 1 || !this.getClientArea().contains(event.x, event.y)) break;
                this.doButtonDown();
            }
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.addListener(13, (Listener)new TypedListener((EventListener)selectionListener));
    }

    public void doButtonDown() {
        if (!this.enabled) {
            return;
        }
        this.down = true;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    private void doButtonUp() {
        if (!this.enabled) {
            return;
        }
        Event event = new Event();
        event.item = this;
        event.widget = this;
        event.type = 13;
        this.notifyListeners(13, event);
        this.down = false;
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    private void doHover(boolean bl) {
        this.hovered = bl;
        if (!bl) {
            this.down = false;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        int n;
        GC gC = paintEvent.gc;
        gC.setAntialias(1);
        Font font = this.getFont();
        gC.setFont(font);
        int n2 = this.preferredHeight < this.getBounds().height ? (this.getBounds().height - this.preferredHeight) / 2 : 0;
        Rectangle rectangle = new Rectangle(0, n2, this.preferredWidth - this.rightPadding, this.preferredHeight);
        this.setBackground(this.getParent().getBackground());
        GamaColors.GamaUIColor gamaUIColor = GamaColors.get(this.colorCode);
        Color color = gamaUIColor == null ? this.getParent().getBackground() : (this.hovered ? gamaUIColor.lighter() : gamaUIColor.color());
        Color color2 = GamaColors.getTextColorForBackground(color).color();
        gC.setBackground(color);
        if (this.down) {
            gC.fillRoundRectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 8, 8);
            if (this.border) {
                var9_9 = ThemeHelper.isDark() ? GamaColors.get(color).lighter() : GamaColors.get(color).darker();
                gC.setForeground(var9_9);
                gC.drawRoundRectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 8, 8);
            }
        } else {
            gC.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 8, 8);
            if (this.border) {
                var9_9 = ThemeHelper.isDark() ? GamaColors.get(color).lighter() : GamaColors.get(color).darker();
                gC.setForeground(var9_9);
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 8, 8);
            }
        }
        gC.setForeground(color2);
        int n3 = 5;
        Image image = this.getImage();
        int n4 = 0;
        String string = this.newText();
        if (string != null) {
            n4 += (this.getBounds().height - gC.textExtent((String)string).y) / 2;
        }
        if (image != null) {
            n = (this.getBounds().height - image.getBounds().height) / 2;
            n3 = this.drawImage(image, gC, n3, n);
        }
        gC.drawString(string, n3, n4);
        if (this.addMenuSign) {
            n = (this.getBounds().height - FlatButton.menuImageBounds.height) / 2;
            n3 = 5;
            n3 = rectangle.width - n3 - FlatButton.menuImageBounds.width;
            this.drawImage(menuImage, gC, n3, n);
        }
    }

    private int drawImage(Image image, GC gC, int n, int n2) {
        if (image == null) {
            return n;
        }
        gC.drawImage(image, n, n2);
        return n + image.getBounds().width + 5;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        n3 = n != -1 ? n : this.preferredWidth;
        n4 = n2 != -1 ? n2 : this.preferredHeight;
        return new Point(n3, n4);
    }

    public String newText() {
        if (this.text == null) {
            return null;
        }
        int n = this.getParent().getBounds().width;
        int n2 = this.preferredWidth;
        int n3 = this.computeWidthOfText();
        if (n < n2 || n3 > n2) {
            int n4 = 0;
            Image image = this.getImage();
            if (image != null || this.addMenuSign) {
                if (image != null) {
                    n4 = image.getBounds().width + 5;
                }
                if (this.addMenuSign) {
                    n4 += (FlatButton.menuImageBounds.width + 5) * 2;
                }
            }
            float f = n < n2 ? (float)(n - n4) / (float)n2 : (float)(n2 - n4) / (float)n3;
            int n5 = this.text.length();
            int n6 = Math.max(0, (int)((float)n5 * f));
            return this.text.substring(0, n6 / 2) + "..." + this.text.substring(n5 - n6 / 2, n5);
        }
        return this.text;
    }

    public FlatButton setImage(Image image) {
        if (this.image == image) {
            return this;
        }
        this.image = image;
        this.computePreferredSize();
        this.redraw();
        return this;
    }

    public FlatButton setImageWithoutRecomputingSize(Image image) {
        if (this.image == image) {
            return this;
        }
        this.image = image;
        this.redraw();
        return this;
    }

    public FlatButton addMenuSign() {
        this.addMenuSign = true;
        return this;
    }

    public FlatButton removeMenuSign() {
        this.addMenuSign = false;
        return this;
    }

    private int computeWidthOfText() {
        if (this.text != null) {
            GC gC = new GC((Drawable)this);
            gC.setFont(this.getFont());
            Point point = gC.textExtent(this.text);
            gC.dispose();
            return point.x;
        }
        return 0;
    }

    private void computePreferredSize() {
        Rectangle rectangle;
        Image image = this.getImage();
        if (image != null || this.addMenuSign) {
            rectangle = new Rectangle(0, 0, 0, 0);
            if (image != null) {
                rectangle = image.getBounds();
                this.preferredWidth = rectangle.width + 5;
            }
            if (this.addMenuSign) {
                rectangle.height = Math.max(rectangle.height, FlatButton.menuImageBounds.height);
                this.preferredWidth += (FlatButton.menuImageBounds.width + 5) * 2;
            }
            this.preferredHeight = rectangle.height + 5;
        }
        if (this.text != null) {
            rectangle = new GC((Drawable)this);
            rectangle.setFont(this.getFont());
            Point point = rectangle.textExtent(this.text + " ... ");
            rectangle.dispose();
            this.preferredWidth += point.x + 10;
            this.preferredHeight = Math.max(this.preferredHeight, point.y + 5);
        }
        this.preferredWidth += this.rightPadding;
        if (this.forcedWidth > 0) {
            this.preferredWidth = this.forcedWidth;
        }
        if (this.minimalHeight > this.preferredHeight) {
            this.preferredHeight = this.minimalHeight;
        }
    }

    public String getText() {
        return this.text;
    }

    public FlatButton setText(String string) {
        if (string == null || string.equals(this.text)) {
            return this;
        }
        this.text = string;
        this.computePreferredSize();
        this.redraw();
        return this;
    }

    public FlatButton setTextWithoutRecomputingSize(String string) {
        if (string == null || string.equals(this.text)) {
            return this;
        }
        this.text = string;
        this.redraw();
        return this;
    }

    private void addListeners() {
        this.addListener(3, this);
        this.addListener(7, this);
        this.addListener(6, this);
        this.addListener(32, this);
        this.addListener(4, this);
        this.addListener(5, this);
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        if (bl2 != bl) {
            if (bl) {
                this.addListeners();
            } else {
                this.removeListener(3, this);
                this.removeListener(7, this);
                this.removeListener(6, this);
                this.removeListener(32, this);
                this.removeListener(4, this);
                this.removeListener(5, this);
            }
            this.redraw();
        }
    }

    public FlatButton disabled() {
        this.setEnabled(false);
        return this;
    }

    public FlatButton light() {
        return this;
    }

    public FlatButton small() {
        return this;
    }

    public FlatButton setColor(GamaColors.GamaUIColor gamaUIColor) {
        if (gamaUIColor == null) {
            return this;
        }
        RGB rGB = this.colorCode;
        RGB rGB2 = gamaUIColor.getRGB();
        if (rGB2.equals((Object)rGB)) {
            return this;
        }
        this.colorCode = gamaUIColor.getRGB();
        this.redraw();
        return this;
    }

    public int getHeight() {
        return this.preferredHeight;
    }

    public FlatButton withWidth(int n) {
        this.forcedWidth = n;
        this.preferredWidth = n;
        return this;
    }

    public FlatButton withMinimalHeight(int n) {
        this.minimalHeight = n;
        this.preferredHeight = n;
        return this;
    }

    public GamaColors.GamaUIColor getColor() {
        return GamaColors.get(this.colorCode);
    }

    private Image getImage() {
        return this.image;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.withWidth(n3);
        super.setBounds(n, n2, n3, n4);
    }

    public void setRightPadding(int n) {
        this.rightPadding = n;
    }

    public FlatButton withBorder() {
        this.border = true;
        return this;
    }

    public void disposeImage() {
        if (this.image == null) {
            return;
        }
        this.image.dispose();
        this.image = null;
    }
}

