/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.util.GamaDate;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.AbstractEditor;
import java.awt.Color;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;

public class DateEditor
extends AbstractEditor<GamaDate> {
    private Composite edit;
    private DateTime date;
    private DateTime time;

    DateEditor(IAgent iAgent, IParameter iParameter, EditorListener<GamaDate> editorListener) {
        super(iAgent, iParameter, editorListener);
    }

    @Override
    public void widgetSelected(SelectionEvent selectionEvent) {
        this.modifyAndDisplayValue(GamaDate.of((Temporal)LocalDateTime.of(this.date.getYear(), this.date.getMonth() + 1, this.date.getDay(), this.time.getHours(), this.time.getMinutes(), this.time.getSeconds())));
    }

    @Override
    public Control createCustomParameterControl(Composite composite) {
        this.edit = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.edit.setLayout((Layout)gridLayout);
        this.date = new DateTime(this.edit, 268435492);
        this.time = new DateTime(this.edit, 268435588);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        this.date.setBackground(this.parent.getBackground());
        this.date.addSelectionListener((SelectionListener)this);
        this.date.setLayoutData((Object)gridData);
        this.time.setBackground(this.parent.getBackground());
        this.time.addSelectionListener((SelectionListener)this);
        this.time.setLayoutData((Object)GridDataFactory.copyData((GridData)gridData));
        this.edit.setBackground(this.parent.getBackground());
        this.displayParameterValue();
        return this.edit;
    }

    @Override
    protected void displayParameterValue() {
        this.internalModification = true;
        GamaDate gamaDate = (GamaDate)this.getCurrentValue();
        if (gamaDate != null) {
            this.date.setDate(gamaDate.getYear(), gamaDate.getMonth() - 1, gamaDate.getDay());
            this.time.setTime(gamaDate.getHour(), gamaDate.getMinute(), gamaDate.getSecond());
        }
        this.internalModification = false;
    }

    @Override
    public IType<Color> getExpectedType() {
        return Types.DATE;
    }

    @Override
    protected int[] getToolItems() {
        return new int[]{6};
    }
}

