/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gama.core.util.GamaColor;
import gama.dev.DEBUG;
import gama.extension.image.GamaImage;
import gama.extension.image.ImageOperators;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.resources.IGamaIcons;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class GamaIcon
implements IGamaIcons {
    private static final Cache<String, GamaIcon> ICON_CACHE;
    private static final java.nio.file.Path PATH_TO_ICONS;
    final String code;
    final URL url;
    final URL disabledUrl;
    final ImageDescriptor descriptor;
    final ImageDescriptor disabledDescriptor;
    static final DisabledFilter FILTER;
    RenderingHints HINTS = new RenderingHints(Map.of(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC, RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
    RescaleOp OP_DARKER = new RescaleOp(0.9f, 0.0f, this.HINTS);

    static {
        DEBUG.ON();
        ICON_CACHE = CacheBuilder.newBuilder().build();
        java.nio.file.Path path = null;
        try {
            URL uRL = FileLocator.toFileURL((URL)Platform.getBundle((String)"gama.ui.shared").getEntry(ICONS_PATH));
            path = java.nio.file.Path.of(new URI(uRL.getProtocol(), uRL.getPath(), null).normalize());
        }
        catch (Exception exception) {}
        PATH_TO_ICONS = path;
        FILTER = new DisabledFilter();
    }

    public static void preloadAllIcons() throws IOException {
        DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"Preloading icons", (String)"done in", () -> Files.walkFileTree(PATH_TO_ICONS, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String string;
                if (basicFileAttributes.isRegularFile() && FilenameUtils.isExtension((String)(string = FilenameUtils.separatorsToUnix((String)PATH_TO_ICONS.relativize(path).toString())), (String)"png") && !string.contains("@") && !string.contains("_disabled")) {
                    GamaIcon.named(FilenameUtils.removeExtension((String)string));
                }
                return FileVisitResult.CONTINUE;
            }
        }));
    }

    public static GamaIcon named(String string) {
        try {
            if (string != null && string.contains("\\")) {
                DEBUG.OUT((Object)("Looking for icon " + string));
            }
            if (string != null) {
                return (GamaIcon)ICON_CACHE.get((Object)string, () -> new GamaIcon(string));
            }
        }
        catch (ExecutionException executionException) {}
        return GamaIcon.named("gaml/_unknown");
    }

    public static GamaIcon ofSize(int n, int n2) {
        String string = "size" + n + "x" + n2;
        try {
            return (GamaIcon)ICON_CACHE.get((Object)string, () -> {
                GamaImage gamaImage = GamaImage.ofDimensions((int)n, (int)n2, (boolean)true);
                return new GamaIcon(string, gamaImage);
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static GamaIcon ofColor(GamaColor gamaColor) {
        String string = "colors/square.color." + String.format("%X", gamaColor.getRGB()) + ".16";
        try {
            return (GamaIcon)ICON_CACHE.get((Object)string, () -> {
                GamaImage gamaImage = GamaImage.from((Image)ImageIO.read(GamaIcon.computeURL("spacer16")), (boolean)true);
                Graphics2D graphics2D = gamaImage.createGraphics();
                int n = gamaImage.getWidth();
                graphics2D.setColor((Color)gamaColor);
                graphics2D.fillRect(1, 1, n - 2, n - 2);
                graphics2D.setColor((Color)(ThemeHelper.isDark() ? GamaColor.get((int)227, (int)230, (int)225) : Color.DARK_GRAY));
                graphics2D.drawRoundRect(0, 0, n - 1, n - 1, 4, 4);
                graphics2D.dispose();
                return new GamaIcon(string, gamaImage);
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    private GamaIcon(String string) {
        DEBUG.OUT((Object)("Creation of icon " + string), (boolean)false);
        this.code = string;
        this.url = GamaIcon.computeURL(this.code);
        DEBUG.OUT((Object)(" with URL " + String.valueOf(this.url)));
        this.disabledUrl = GamaIcon.computeURL(this.code + "_disabled");
        this.descriptor = ImageDescriptor.createFromURL((URL)this.url);
        this.disabledDescriptor = ImageDescriptor.createFromURL((URL)this.disabledUrl);
    }

    private GamaIcon(String string, org.eclipse.swt.graphics.Image image, org.eclipse.swt.graphics.Image image2) {
        this.code = string;
        this.disabledUrl = this.url = GamaIcon.computeURL(this.code);
        this.descriptor = ImageDescriptor.createFromImage((org.eclipse.swt.graphics.Image)image);
        this.disabledDescriptor = ImageDescriptor.createFromImage((org.eclipse.swt.graphics.Image)image2);
    }

    private GamaIcon(String string, GamaImage gamaImage) {
        this(string, GamaIcon.toSWTImage(gamaImage), GamaIcon.toDisabledSWTImage((BufferedImage)gamaImage));
    }

    public static org.eclipse.swt.graphics.Image toSWTImage(GamaImage gamaImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)gamaImage, "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {}
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), new ImageData((InputStream)byteArrayInputStream));
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static org.eclipse.swt.graphics.Image toDisabledSWTImage(BufferedImage bufferedImage) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), FILTER);
        Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)GamaIcon.toBufferedImage(image), "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {}
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), new ImageData((InputStream)byteArrayInputStream));
    }

    public static org.eclipse.swt.graphics.Image toCheckedSWTImage(GamaImage gamaImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)ImageOperators.darker(null, (GamaImage)gamaImage, (double)0.5), "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {}
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), new ImageData((InputStream)byteArrayInputStream));
    }

    public ImageDescriptor descriptor() {
        return this.descriptor;
    }

    public ImageDescriptor disabledDescriptor() {
        return this.disabledDescriptor;
    }

    private org.eclipse.swt.graphics.Image image(String string, Callable<org.eclipse.swt.graphics.Image> callable) {
        org.eclipse.swt.graphics.Image image = JFaceResources.getImage((String)string);
        if (image == null) {
            try {
                image = callable.call();
            }
            catch (Exception exception) {}
            if (image == null) {
                image = GamaIcon.named("gaml/_unknown").image();
            }
            if (JFaceResources.getImageRegistry().get(string) == null) {
                JFaceResources.getImageRegistry().put(string, image);
            }
        }
        return image;
    }

    public org.eclipse.swt.graphics.Image image() {
        return this.image(this.url.toString(), () -> this.descriptor.createImage(false));
    }

    public org.eclipse.swt.graphics.Image disabled() {
        return this.image(this.disabledUrl.toString(), () -> this.disabledDescriptor.createImage(false));
    }

    public org.eclipse.swt.graphics.Image checked() {
        return this.image(this.code + "_checked", () -> {
            GamaImage gamaImage = GamaImage.from((Image)ImageIO.read(this.url), (boolean)true);
            return GamaIcon.toCheckedSWTImage(gamaImage);
        });
    }

    public String getCode() {
        return this.code;
    }

    public static URL computeURL(String string) {
        IPath iPath = new Path("/plugin").append("gama.ui.shared").append(ICONS_PATH + string + ".png");
        try {
            URI uRI = new URI("platform", null, iPath.toPortableString(), null);
            return uRI.toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return GamaIcon.computeURL("gaml/_unknown");
        }
    }

    public static boolean exist(String string) {
        return ICON_CACHE.getIfPresent((Object)string) != null;
    }

    private static class DisabledFilter
    extends RGBImageFilter {
        private final float min;
        private final float factor;

        DisabledFilter() {
            this.canFilterIndexColorModel = true;
            this.min = 160.0f;
            this.factor = (255.0f - this.min) / 255.0f;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = Math.min(255, (int)((0.2125f * (float)(n3 >> 16 & 0xFF) + 0.7154f * (float)(n3 >> 8 & 0xFF) + 0.0721f * (float)(n3 & 0xFF) + 0.5f) * this.factor + this.min));
            return n3 & 0xFF000000 | n4 << 16 | n4 << 8 | n4 << 0;
        }
    }
}

