/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.core.outputs.IOutput;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import org.eclipse.swt.widgets.ToolItem;

public class FrequencyController
implements IToolbarDecoratedView.StateListener {
    final IToolbarDecoratedView.Pausable view;
    ToolItem pauseItem;
    boolean internalChange;

    public FrequencyController(IToolbarDecoratedView.Pausable pausable) {
        this.view = pausable;
        pausable.addStateListener(this);
    }

    void togglePause(ToolItem toolItem, IOutput iOutput) {
        if (iOutput != null) {
            toolItem.setToolTipText((iOutput.isPaused() ? "Resume " : "Pause ") + iOutput.getName());
        }
        this.view.pauseChanged();
    }

    public void install(GamaToolbar2 gamaToolbar2) {
        this.createPauseItem(gamaToolbar2);
        gamaToolbar2.sep(4, 131072);
    }

    private void createPauseItem(GamaToolbar2 gamaToolbar2) {
        this.pauseItem = gamaToolbar2.check("display/action.pause", "Pause", "Pause or resume the current view", selectionEvent -> {
            IOutput iOutput = this.view.getOutput();
            if (!this.internalChange && iOutput != null) {
                if (iOutput.isPaused()) {
                    iOutput.setPaused(false);
                } else {
                    iOutput.setPaused(true);
                }
            }
            this.togglePause((ToolItem)selectionEvent.widget, iOutput);
        }, 131072);
    }

    @Override
    public void updateToReflectState() {
        if (this.view == null) {
            return;
        }
        IOutput iOutput = this.view.getOutput();
        if (iOutput == null) {
            return;
        }
        WorkbenchHelper.run(() -> {
            this.internalChange = true;
            if (this.pauseItem != null && !this.pauseItem.isDisposed()) {
                ((GamaToolbar2)this.pauseItem.getParent().getParent()).setSelection(this.pauseItem, iOutput.isPaused());
            }
            this.internalChange = false;
        });
    }
}

