/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.common.interfaces.IValue;
import gama.core.kernel.experiment.InputParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.outputs.MonitorOutput;
import gama.core.outputs.ValuedDisplayOutputFactory;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.System;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.parameters.AbstractStatementEditor;
import gama.ui.shared.parameters.EditorLabel;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class MonitorDisplayer
extends AbstractStatementEditor<MonitorOutput> {
    private Runnable closer;

    public MonitorDisplayer(IScope iScope, MonitorOutput monitorOutput) {
        super(iScope, monitorOutput, null);
    }

    @Override
    Composite createValueComposite() {
        this.composite = new Composite((Composite)this.parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 100;
        gridData.horizontalSpan = 2;
        this.composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        this.composite.setLayout((Layout)gridLayout);
        return this.composite;
    }

    @Override
    public void createControls(EditorsGroup editorsGroup) {
        super.createControls(editorsGroup);
        if (((MonitorOutput)this.getStatement()).shouldBeInitialized()) {
            ((MonitorOutput)this.getStatement()).shouldNotBeInitialized();
            this.applyEdit();
        }
    }

    @Override
    protected FlatButton createCustomParameterControl(Composite composite) throws GamaRuntimeException {
        this.textBox = FlatButton.menu(composite, GamaColors.get((Color)((MonitorOutput)this.getStatement()).getColor(this.getScope())), ((MonitorOutput)this.getStatement()).getTitle());
        this.textBox.addSelectionListener(selectionEvent2 -> {
            IType iType;
            Menu menu = new Menu((Control)this.textBox);
            GamaMenu.action(menu, "Edit...", selectionEvent -> this.applyEdit());
            GamaMenu.action(menu, ((MonitorOutput)this.getStatement()).isPaused() ? "Resume" : "Pause", selectionEvent -> {
                ((MonitorOutput)this.getStatement()).setPaused(!((MonitorOutput)this.getStatement()).isPaused());
                this.updateWithValueOfParameter(false, false);
            });
            GamaMenu.action(menu, "Close", selectionEvent -> {
                this.closer.run();
                this.parent.requestLayout();
            });
            GamaMenu.separate(menu);
            GamaMenu.action(menu, "Copy value", selectionEvent -> {
                Object object = ((MonitorOutput)this.getStatement()).getLastValue();
                WorkbenchHelper.copy(object == null ? "nil" : (object instanceof IValue ? ((IValue)object).serializeToGaml(true) : object.toString()));
            });
            IExpression iExpression = ((MonitorOutput)this.getStatement()).getValue();
            IType iType2 = iType = iExpression == null ? Types.NO_TYPE : iExpression.getGamlType();
            if (iType.isNumber() || iType.isContainer() && iType.getContentType().isNumber()) {
                GamaMenu.action(menu, "Save as CSV", selectionEvent -> this.applySave());
            } else if (iType.isAgentType()) {
                GamaMenu.action(menu, "Inspect agent", selectionEvent -> ((MonitorOutput)this.getStatement()).getScope().getGui().setSelectedAgent((IAgent)((MonitorOutput)this.getStatement()).getLastValue()));
            } else if (iType.isContainer() && iType.getContentType().isAgentType()) {
                GamaMenu.action(menu, "Browse agents", selectionEvent -> ValuedDisplayOutputFactory.browse((Collection)((Collection)((MonitorOutput)this.getStatement()).getLastValue())));
            }
            menu.setVisible(true);
        });
        composite.requestLayout();
        return this.textBox;
    }

    @Override
    EditorLabel createEditorLabel() {
        return null;
    }

    @Override
    public void updateWithValueOfParameter(boolean bl, boolean bl2) {
        try {
            Runnable runnable = () -> {
                this.internalModification = true;
                if (this.parent != null && !this.parent.isDisposed() && !this.textBox.isDisposed()) {
                    this.textBox.setText(((MonitorOutput)this.getStatement()).getTitle());
                    this.composite.update();
                }
                this.internalModification = false;
            };
            if (bl) {
                WorkbenchHelper.run(runnable);
            } else {
                WorkbenchHelper.asyncRun(runnable);
            }
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Unable to obtain the value of " + this.name);
            GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
            return;
        }
    }

    @Override
    protected void applySave() {
        ((MonitorOutput)this.getStatement()).saveHistory();
    }

    @Override
    protected void applyEdit() {
        GamaColor gamaColor = ((MonitorOutput)this.getStatement()).getColor(this.getScope());
        if (gamaColor == null) {
            gamaColor = IGamaColors.NEUTRAL.gamaColor();
        }
        IMap iMap = System.userInputDialog((IScope)this.getScope(), (String)"Edit monitor", (IList)GamaListFactory.wrap((IType)Types.NO_TYPE, List.of(System.enterValue((IScope)this.getScope(), (String)"Title", (String)((MonitorOutput)this.getStatement()).getName()), System.enterValue((IScope)this.getScope(), (String)"Color", (IType)Types.COLOR, (Object)gamaColor), new InputParameter("Expression", ((MonitorOutput)this.getStatement()).getValue()){

            public boolean isExpression() {
                return true;
            }
        })));
        ((MonitorOutput)this.getStatement()).setName((String)iMap.get("Title"));
        ((MonitorOutput)this.getStatement()).setColor((GamaColor)iMap.get("Color"));
        this.textBox.setColor(GamaColors.get((Color)((MonitorOutput)this.getStatement()).getColor(this.getScope())));
        ((MonitorOutput)this.getStatement()).setNewExpression((IExpression)iMap.get("Expression"));
        this.updateWithValueOfParameter(false, false);
    }

    @Override
    protected GridData getEditorControlGridData() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.minimumWidth = 50;
        return gridData;
    }

    public void setCloser(Runnable runnable) {
        this.closer = runnable;
    }
}

