/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls;

import gama.core.kernel.experiment.IParameter;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class SwitchButton
extends Canvas {
    boolean selection;
    private String trueText;
    private String falseText;
    private String text;
    private final Color trueBackgroundColor;
    private final Color falseBackgroundColor;
    private final int gap;
    private static final int INSIDE_BUTTON_MARGIN = 3;
    private GC gc;
    private final Set<SelectionListener> listOfSelectionListeners;

    public SwitchButton(Composite composite, int n, String string, String string2, String string3) {
        this(composite, n, IGamaColors.OK.color(), IGamaColors.ERROR.color(), new String[]{string, string2});
        this.trueText = string;
        this.falseText = string2;
        this.text = string3;
    }

    public SwitchButton(Composite composite, int n, Color color, Color color2, String[] stringArray) {
        super(composite, n | 0x20000000);
        String[] stringArray2 = stringArray == null || stringArray.length < 2 ? IParameter.SWITCH_STRINGS : stringArray;
        this.trueText = " " + stringArray2[0] + " ";
        this.falseText = " " + stringArray2[1] + " ";
        this.text = "";
        this.trueBackgroundColor = color;
        this.falseBackgroundColor = color2;
        this.gap = 10;
        this.listOfSelectionListeners = new HashSet<SelectionListener>();
        this.addPaintListener(this::onPaint);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                SwitchButton.this.setSelection(!SwitchButton.this.selection);
                SwitchButton.this.fireSelectionListeners(mouseEvent);
            }
        });
    }

    private void onPaint(PaintEvent paintEvent) {
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        this.gc = paintEvent.gc;
        Point point = this.computeButtonSize();
        this.drawSwitchButton(point);
        if (this.text != null && !this.text.isEmpty()) {
            this.drawText(point);
        }
    }

    public int getBackgroundMode() {
        return 0;
    }

    private void drawSwitchButton(Point point) {
        Color color = this.getParent().getBackground();
        this.gc.setBackground(ThemeHelper.isDark() ? GamaColors.get(color).lighter() : GamaColors.get(color).darker());
        this.gc.fillRoundRectangle(2, 2, point.x - 1, point.y + 1, 5, 5);
        this.gc.setBackground(this.selection ? this.trueBackgroundColor : this.falseBackgroundColor);
        this.gc.setForeground(GamaColors.getTextColorForBackground(this.gc.getBackground()).color());
        String string = this.selection ? this.trueText : this.falseText;
        Point point2 = this.gc.textExtent(string);
        int n = (point.x / 2 - point2.x) / 2 + 2;
        int n2 = (point.y - point2.y) / 2 + 2;
        int n3 = this.selection ? 2 : point.x / 2 + 1;
        this.gc.fillRoundRectangle(n3, 2, point.x / 2 + 1, point.y + 1, 5, 5);
        this.gc.drawString(string, n3 + n, n2);
    }

    Point computeButtonSize() {
        this.gc.setFont(this.getFont());
        Point point = this.gc.stringExtent(this.trueText);
        Point point2 = this.gc.stringExtent(this.falseText);
        int n = Math.max(point.x, point2.x) * 2 + 6;
        int n2 = Math.max(point.y, point2.y) + 3;
        return new Point(n, n2);
    }

    void drawText(Point point) {
        this.gc.setForeground(this.selection ? this.trueBackgroundColor : this.falseBackgroundColor);
        this.gc.setBackground(this.getParent().getBackground());
        int n = point.y + 6;
        int n2 = this.gc.stringExtent((String)this.text).y;
        int n3 = 2 + point.x + this.gap;
        this.gc.drawText(this.text, n3, (n - n2) / 2);
    }

    boolean fireSelectionListeners(MouseEvent mouseEvent) {
        for (SelectionListener selectionListener : this.listOfSelectionListeners) {
            Event event = new Event();
            event.button = mouseEvent.button;
            event.display = this.getDisplay();
            event.item = null;
            event.widget = this;
            event.data = null;
            event.time = mouseEvent.time;
            event.x = mouseEvent.x;
            event.y = mouseEvent.y;
            SelectionEvent selectionEvent = new SelectionEvent(event);
            selectionListener.widgetSelected(selectionEvent);
            if (selectionEvent.doit) continue;
            return false;
        }
        return true;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.listOfSelectionListeners.add(selectionListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        boolean bl2 = false;
        if (this.gc == null || this.gc.isDisposed()) {
            this.gc = new GC((Drawable)this);
            bl2 = true;
        }
        Point point = this.computeButtonSize();
        int n3 = point.x;
        int n4 = point.y;
        if (this.text != null && this.text.trim().length() > 0) {
            Point point2 = this.gc.textExtent(this.text);
            n3 += point2.x + this.gap + 1;
        }
        n3 += 6;
        n4 += 6;
        if (bl2) {
            this.gc.dispose();
        }
        return new Point(n3, n4);
    }

    public boolean getSelection() {
        return this.selection;
    }

    public void setSelection(boolean bl) {
        this.selection = bl;
        this.redraw();
    }

    public String getText() {
        return this.text;
    }
}

