/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.utils;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.core.runtime.GAMA;
import gama.core.runtime.MemoryUtils;
import gama.core.util.GamaColor;
import gama.ui.shared.menus.GamaColorMenu;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.GamaPreferencesView;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IDecoratorManager;

public class PreferencesHelper {
    public static final Pref<Boolean> CORE_EDITORS_HIGHLIGHT = GamaPreferences.create((String)"pref_editors_highlight", (String)"Highlight in yellow the title of value editors when they change", (Object)true, (int)3, (boolean)false).in("Interface", "Appearance");
    public static final Pref<GamaColor> SHAPEFILE_VIEWER_FILL = GamaPreferences.create((String)"pref_shapefile_background_color", (String)"Shapefile viewer fill color", () -> GamaColor.get((String)"lightgray"), (int)6, (boolean)false).in("Interface", "Appearance").hidden();
    public static final Pref<GamaColor> SHAPEFILE_VIEWER_LINE_COLOR = GamaPreferences.create((String)"pref_shapefile_line_color", (String)"Shapefile viewer line color", () -> GamaColor.get((String)"black"), (int)6, (boolean)false).in("Interface", "Appearance").hidden();
    public static final Pref<GamaColor> ERROR_TEXT_COLOR = GamaPreferences.create((String)"pref_error_text_color", (String)"Text color of errors", () -> GamaColors.toGamaColor(IGamaColors.ERROR.inactive()), (int)6, (boolean)false).in("Execution", "Runtime errors").hidden();
    public static final Pref<GamaColor> WARNING_TEXT_COLOR = GamaPreferences.create((String)"pref_warning_text_color", (String)"Text color of warnings", () -> GamaColors.toGamaColor(IGamaColors.WARNING.inactive()), (int)6, (boolean)false).in("Execution", "Runtime errors").hidden();
    public static final Pref<GamaColor> IMAGE_VIEWER_BACKGROUND = GamaPreferences.create((String)"pref_image_background_color", (String)"Image viewer background color", () -> GamaColor.get((String)"white"), (int)6, (boolean)false).in("Interface", "Appearance").hidden();
    public static final Pref<String> COLOR_MENU_SORT = GamaPreferences.create((String)"pref_menu_colors_sort", (String)"Sort colors menu by", (Object)"RGB value", (int)4, (boolean)false).among((Object[])GamaColorMenu.SORT_NAMES).activates(new String[]{"menu.colors.reverse", "menu.colors.group"}).in("Interface", "Menus").onChange(string -> {
        GamaColorMenu.colorComp = string.equals(GamaColorMenu.SORT_NAMES[0]) ? GamaColorMenu.byRGB : (string.equals(GamaColorMenu.SORT_NAMES[1]) ? GamaColorMenu.byName : (string.equals(GamaColorMenu.SORT_NAMES[2]) ? GamaColorMenu.byBrightness : GamaColorMenu.byLuminescence));
    });
    public static final Pref<Boolean> COLOR_MENU_REVERSE = GamaPreferences.create((String)"pref_menu_colors_reverse", (String)"Reverse order", (Object)false, (int)3, (boolean)false).in("Interface", "Menus").onChange(bl -> GamaColorMenu.setReverse(bl != false ? -1 : 1)).hidden();
    public static final Pref<Boolean> COLOR_MENU_GROUP = GamaPreferences.create((String)"pref_menu_colors_group", (String)"Group colors", (Object)false, (int)3, (boolean)false).in("Interface", "Menus").onChange(bl -> {
        Boolean bl2 = GamaColorMenu.breakdown = bl;
    }).hidden();
    public static final Pref<Boolean> NAVIGATOR_METADATA = GamaPreferences.create((String)"pref_navigator_display_metadata", (String)"Display metadata in navigator", (Object)true, (int)3, (boolean)false).in("Interface", "Navigator").onChange(bl -> {
        IDecoratorManager iDecoratorManager = WorkbenchHelper.getWorkbench().getDecoratorManager();
        try {
            iDecoratorManager.setEnabled("gama.ui.application.decorator", bl.booleanValue());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    });
    public static final Pref<Boolean> KEEP_NAVIGATOR_STATE = GamaPreferences.create((String)"pref_keep_navigator_state", (String)"Maintain the state of the navigator across sessions", (Object)true, (int)3, (boolean)false).in("Interface", "Navigator").hidden();
    public static final Pref<Boolean> NAVIGATOR_HIDDEN = GamaPreferences.create((String)"pref_navigator_display_hidden", (String)"Display hidden files in navigator", (Object)false, (int)3, (boolean)false).in("Interface", "Navigator").onChange(bl -> GAMA.getGui().refreshNavigator());
    public static final Pref<Boolean> NAVIGATOR_OUTLINE = GamaPreferences.create((String)"pref_navigator_display_outline", (String)"Display the outline of GAML files in navigator", (Object)false, (int)3, (boolean)false).in("Interface", "Navigator").onChange(bl -> GAMA.getGui().refreshNavigator());

    public static void initialize() {
        File file = MemoryUtils.findIniFile();
        Integer n2 = file == null ? null : Integer.valueOf(MemoryUtils.readMaxMemoryInMegabytes((File)file));
        String string = file == null || n2 == null ? "The max. memory allocated in Megabytes. It can be modified in Eclipse (developer version) or in Gama.ini file" : "Maximum memory allocated in Mb (requires to restart GAMA)";
        int n3 = n2 == null ? MemoryUtils.maxMemory() : n2;
        Pref pref = GamaPreferences.create((String)"pref_memory_max", (String)string, (Object)n3, (int)1, (boolean)false).in("Execution", "Memory");
        pref.getValue();
        pref.set((Object)n3);
        if (n2 == null) {
            pref.disabled();
        }
        pref.onChange(n -> {
            MemoryUtils.changeMaxMemory((File)file, (int)n);
            GamaPreferencesView.setRestartRequired();
        });
    }
}

