/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.ui.shared.resources.GamaFonts;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Control;

public class FontSizer {
    public static void changeFontSize(int n, Control control) {
        if (control != null) {
            control.setFont(GamaFonts.withMagnification(control.getFont(), n));
        }
    }

    public static void install(final IToolbarDecoratedView.Sizable sizable, final GamaToolbar2 gamaToolbar2) {
        gamaToolbar2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Control control = sizable.getSizableFontControl();
                if (control != null) {
                    control.addGestureListener(gestureEvent -> {
                        if (gestureEvent.detail == 32) {
                            FontSizer.changeFontSize((int)(2.0 * Math.signum(gestureEvent.magnification - 1.0)), control);
                        }
                    });
                    gamaToolbar2.removeControlListener((ControlListener)this);
                }
            }
        });
        gamaToolbar2.button("toolbar/font.increase", "Increase font size", "Increase font size", selectionEvent -> FontSizer.changeFontSize(2, sizable.getSizableFontControl()), 131072);
        gamaToolbar2.button("toolbar/font.decrease", "Decrease font size", "Decrease font size", selectionEvent -> FontSizer.changeFontSize(-2, sizable.getSizableFontControl()), 131072);
    }
}

