/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views.toolbar;

import gama.dev.DEBUG;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.ITooltipDisplayer;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.views.toolbar.Expander;
import gama.ui.shared.views.toolbar.FontSizer;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gama.ui.shared.views.toolbar.Pauser;
import gama.ui.shared.views.toolbar.ZoomController;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GamaToolbarFactory {
    public static final int TOOLBAR_HEIGHT = 24;
    public static final int TOOLBAR_SEP = 4;

    static {
        DEBUG.OFF();
    }

    public static ITooltipDisplayer findTooltipDisplayer(Control control) {
        GamaComposite gamaComposite = GamaToolbarFactory.findGamaComposite(control);
        return gamaComposite == null ? null : gamaComposite.displayer;
    }

    public static GamaComposite findGamaComposite(Control control) {
        if (control instanceof Shell) {
            return null;
        }
        if (control instanceof GamaComposite) {
            return (GamaComposite)control;
        }
        return GamaToolbarFactory.findGamaComposite((Control)control.getParent());
    }

    private static Composite createIntermediateCompositeFor(IToolbarDecoratedView iToolbarDecoratedView, Composite composite) {
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 0;
        composite.setLayout((Layout)fillLayout);
        Composite composite2 = iToolbarDecoratedView instanceof ITooltipDisplayer ? new GamaComposite(composite, (ITooltipDisplayer)((Object)iToolbarDecoratedView)) : new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    public static GridData getLayoutDataForChild() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 5;
        return gridData;
    }

    public static FillLayout getLayoutForChild() {
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        return fillLayout;
    }

    public static Composite createToolbarComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GamaColors.setBackground(ThemeHelper.isDark() ? composite.getShell().getBackground() : IGamaColors.WHITE.color(), new Control[]{composite2});
        return composite2;
    }

    public static Composite createToolbars(IToolbarDecoratedView iToolbarDecoratedView, Composite composite) {
        Composite composite2 = GamaToolbarFactory.createIntermediateCompositeFor(iToolbarDecoratedView, composite);
        Composite composite3 = GamaToolbarFactory.createToolbarComposite(composite2);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayoutData((Object)GamaToolbarFactory.getLayoutDataForChild());
        composite4.setLayout((Layout)GamaToolbarFactory.getLayoutForChild());
        GamaToolbar2 gamaToolbar2 = new GamaToolbar2(composite3, 0x880100);
        GridData gridData = GamaToolbarFactory.layoutDataForToolbar();
        gamaToolbar2.setLayoutData(gridData);
        composite.addDisposeListener(disposeEvent -> GamaToolbarFactory.disposeToolbar(iToolbarDecoratedView, gamaToolbar2));
        GamaToolbarFactory.buildToolbar(iToolbarDecoratedView, gamaToolbar2);
        return composite4;
    }

    public static GridData layoutDataForToolbar() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 24;
        gridData.minimumWidth = 48;
        return gridData;
    }

    public static void disposeToolbar(IToolbarDecoratedView iToolbarDecoratedView, GamaToolbar2 gamaToolbar2) {
        if (gamaToolbar2 != null && !gamaToolbar2.isDisposed()) {
            gamaToolbar2.dispose();
        }
    }

    public static void buildToolbar(IToolbarDecoratedView iToolbarDecoratedView, GamaToolbar2 gamaToolbar2) {
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Expandable) {
            IToolbarDecoratedView.Expandable expandable = (IToolbarDecoratedView.Expandable)iToolbarDecoratedView;
            Expander.install(expandable, gamaToolbar2);
        }
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Sizable) {
            IToolbarDecoratedView.Sizable sizable = (IToolbarDecoratedView.Sizable)iToolbarDecoratedView;
            FontSizer.install(sizable, gamaToolbar2);
        }
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Pausable) {
            IToolbarDecoratedView.Pausable pausable = (IToolbarDecoratedView.Pausable)iToolbarDecoratedView;
            new Pauser(pausable).install(gamaToolbar2);
        }
        if (iToolbarDecoratedView instanceof IToolbarDecoratedView.Zoomable) {
            IToolbarDecoratedView.Zoomable zoomable = (IToolbarDecoratedView.Zoomable)iToolbarDecoratedView;
            new ZoomController(zoomable).install(gamaToolbar2);
        }
        iToolbarDecoratedView.createToolItems(gamaToolbar2);
        gamaToolbar2.requestLayout();
    }

    public static class GamaComposite
    extends Composite {
        ITooltipDisplayer displayer;

        public GamaComposite(Composite composite, ITooltipDisplayer iTooltipDisplayer) {
            super(composite, 0);
            this.displayer = iTooltipDisplayer;
        }
    }
}

