/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.resources.GamaColors;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class EditorControl<T extends Control> {
    final T control;
    final AbstractEditor<?> editor;

    EditorControl(AbstractEditor<?> abstractEditor, T t) {
        this.editor = abstractEditor;
        this.control = t;
        t.setLayoutData((Object)abstractEditor.getEditorControlGridData());
        Color color = abstractEditor.getEditorControlBackground();
        Color color2 = abstractEditor.getEditorControlForeground();
        if (t instanceof FlatButton) {
            FlatButton flatButton = (FlatButton)((Object)t);
            flatButton.setColor(GamaColors.get(color));
        } else {
            GamaColors.setBackAndForeground(color, color2, new Control[]{t});
        }
    }

    T getControl() {
        return this.control;
    }

    public void setLayoutData(GridData gridData) {
        if (this.control.isDisposed()) {
            return;
        }
        this.control.setLayoutData((Object)gridData);
    }

    public void setText(String string) {
        if (this.control.isDisposed()) {
            return;
        }
        T t = this.control;
        if (t instanceof Text) {
            Text text = (Text)t;
            text.setText(string);
        } else {
            T t2 = this.control;
            if (t2 instanceof Button) {
                Button button = (Button)t2;
                button.setText(string);
            } else {
                T t3 = this.control;
                if (t3 instanceof FlatButton) {
                    FlatButton flatButton = (FlatButton)((Object)t3);
                    flatButton.setText(string);
                } else {
                    T t4 = this.control;
                    if (t4 instanceof Label) {
                        Label label = (Label)t4;
                        label.setText(string);
                    } else {
                        T t5 = this.control;
                        if (t5 instanceof CLabel) {
                            CLabel cLabel = (CLabel)t5;
                            cLabel.setText(string);
                        }
                    }
                }
            }
        }
    }

    public void setActive(boolean bl) {
        if (this.control.isDisposed()) {
            return;
        }
        this.control.setEnabled(bl);
    }

    public boolean isDisposed() {
        return this.control != null && this.control.isDisposed();
    }

    public void displayParameterValue() {
        if (this.control.isDisposed()) {
            return;
        }
        this.editor.displayParameterValue();
    }

    public void updateAmongValues(List list) {
    }
}

