/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.runtime.IScope;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.EditorFactory;
import gama.ui.shared.parameters.EditorsGroup;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GamaWizardPage
extends WizardPage {
    private final IMap<String, Object> values = GamaMapFactory.createUnordered();
    private final List<IParameter> parameters;
    private final IScope scope;

    public GamaWizardPage(IScope iScope, List<IParameter> list, String string, String string2) {
        super(string);
        this.setTitle(string);
        this.setDescription(string2);
        this.scope = iScope;
        this.parameters = list;
        list.forEach(iParameter -> this.values.put((Object)iParameter.getName(), iParameter.getInitialValue(iScope)));
    }

    public void createControl(Composite composite) {
        EditorsGroup editorsGroup = new EditorsGroup(composite, 0);
        this.parameters.forEach(iParameter -> {
            EditorListener<Object> editorListener = object -> {
                iParameter.setValue(this.scope, object);
                this.values.put((Object)iParameter.getName(), object);
            };
            EditorFactory.create(this.scope, editorsGroup, iParameter, editorListener, false);
        });
        editorsGroup.layout();
        this.setControl((Control)editorsGroup);
    }

    public IMap<String, Object> getValues() {
        return this.values;
    }

    public boolean isPageComplete() {
        return true;
    }
}

