/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.util.GamaColor;
import gama.gaml.types.GamaColorType;
import gama.gaml.types.Types;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.menus.GamaColorMenu;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import java.awt.Color;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;

public class ColorEditor
extends AbstractEditor<Color> {
    final GamaColorMenu.IColorRunnable runnable = (n, n2, n3) -> this.modifyAndDisplayValue(GamaColor.get((int)n, (int)n2, (int)n3, (int)255));
    final SelectionListener listener = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            String string = menuItem.getText().replace("#", "");
            GamaColor gamaColor = (GamaColor)GamaColor.colors.get(string);
            if (gamaColor == null) {
                return;
            }
            ColorEditor.this.modifyAndDisplayValue(gamaColor);
        }
    };
    private FlatButton edit;

    ColorEditor(IAgent iAgent, IParameter iParameter, EditorListener<Color> editorListener) {
        super(iAgent, iParameter, editorListener);
    }

    @Override
    public void widgetSelected(SelectionEvent selectionEvent) {
        new GamaColorMenu(null).open((Control)this.edit, selectionEvent, this.listener, this.runnable);
    }

    @Override
    public Control createCustomParameterControl(Composite composite) {
        this.edit = FlatButton.menu(composite, IGamaColors.WHITE, "").light().small();
        this.edit.addSelectionListener(this);
        this.displayParameterValue();
        return this.edit;
    }

    @Override
    protected void displayParameterValue() {
        this.internalModification = true;
        GamaColors.GamaUIColor gamaUIColor = GamaColors.get((Color)(this.currentValue == null ? GamaColor.get((int)0) : (Color)this.currentValue));
        this.edit.setText(gamaUIColor.toString());
        this.edit.setColor(gamaUIColor);
        this.internalModification = false;
    }

    public GamaColorType getExpectedType() {
        return Types.COLOR;
    }

    @Override
    protected void applyEdit() {
        Color color = (Color)this.currentValue;
        RGB rGB = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        GamaColorMenu.openView(this.runnable, rGB);
    }

    @Override
    protected int[] getToolItems() {
        return new int[]{2, 6};
    }
}

