/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.views.toolbar.GamaCommand;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EditorToolbar<T> {
    final AbstractEditor<T> editor;
    boolean active;
    protected static final GamaCommand[] commands = new GamaCommand[10];
    protected final Item[] items = new Item[9];
    final Composite group;

    static {
        EditorToolbar.commands[6] = GamaCommand.build("overlays/small.revert", null, "Revert to original value", null);
        EditorToolbar.commands[0] = GamaCommand.build("overlays/small.plus", null, "Increment the value", null);
        EditorToolbar.commands[1] = GamaCommand.build("overlays/small.minus", null, "Decrement the value ", null);
        EditorToolbar.commands[2] = GamaCommand.build("overlays/small.edit", null, "Edit the parameter", null);
        EditorToolbar.commands[3] = GamaCommand.build("overlays/small.inspect", null, "Inspect the agent", null);
        EditorToolbar.commands[4] = GamaCommand.build("overlays/small.browse", null, "Browse the list of agents", null);
        EditorToolbar.commands[5] = GamaCommand.build("overlays/small.change", null, "Choose another agent", null);
        EditorToolbar.commands[7] = GamaCommand.build("overlays/small.undefine", null, "Set the parameter to undefined", null);
        EditorToolbar.commands[8] = GamaCommand.build(null, "", "Value of the parameter", null);
    }

    EditorToolbar(AbstractEditor<T> abstractEditor, Composite composite) {
        this.editor = abstractEditor;
        this.group = new Composite(composite, 0);
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        this.group.setLayoutData((Object)gridData);
        RowLayout rowLayout = RowLayoutFactory.fillDefaults().center(true).spacing(2).margins(0, 0).type(256).fill(true).pack(true).extendedMargins(0, 0, 0, 0).justify(false).wrap(false).create();
        RowData rowData = RowDataFactory.swtDefaults().create();
        this.group.setLayout((Layout)rowLayout);
        IParameter iParameter = abstractEditor.getParam();
        if (iParameter == null || iParameter.isEditable()) {
            int[] nArray = abstractEditor.getToolItems();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                final int n3 = nArray[n2];
                MouseAdapter mouseAdapter = new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        EditorToolbar.this.execute(n3, 0);
                    }
                };
                this.items[n3] = new Item(this.group, commands[n3], (MouseListener)mouseAdapter);
                this.items[n3].label.setLayoutData((Object)RowDataFactory.copyData((RowData)rowData));
                ++n2;
            }
        }
        Color color = abstractEditor.parent.getBackground();
        GamaColors.setBackground(color, new Control[]{this.group});
        GamaColors.setBackground(color, this.group.getChildren());
    }

    private void execute(int n, int n2) {
        switch (n) {
            case 6: {
                this.editor.modifyAndDisplayValue(this.editor.applyRevert());
                break;
            }
            case 0: {
                this.editor.modifyAndDisplayValue(this.editor.applyPlus());
                break;
            }
            case 1: {
                this.editor.modifyAndDisplayValue(this.editor.applyMinus());
                break;
            }
            case 2: {
                this.editor.applyEdit();
                break;
            }
            case 3: {
                this.editor.applyInspect();
                break;
            }
            case 4: {
                this.editor.applyBrowse();
                break;
            }
            case 5: {
                this.editor.applyChange();
                break;
            }
            case 7: {
                this.editor.applyDefine();
            }
        }
    }

    public void enable(int n, boolean bl) {
        if (!this.active && bl) {
            return;
        }
        Item item = this.items[n];
        if (item == null) {
            return;
        }
        item.enable(bl);
    }

    protected void update() {
        Item item = this.items[6];
        if (item != null && !item.isDisposed()) {
            item.enable(this.editor.isValueModified());
        }
    }

    public void updateValue(String string) {
        Item item = this.items[8];
        if (item != null && !item.isDisposed()) {
            item.label.setText(string);
        }
    }

    public void setActive(Boolean bl) {
        this.active = bl;
        Item[] itemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item != null) {
                item.enable(bl);
            }
            ++n2;
        }
        if (bl.booleanValue()) {
            this.update();
        }
    }

    public Label getItem(int n) {
        Item item = this.items[n];
        if (item == null) {
            return null;
        }
        return item.label;
    }

    public void setHorizontalAlignment(int n) {
        if (this.group.isDisposed()) {
            return;
        }
        ((GridData)this.group.getLayoutData()).horizontalAlignment = n;
    }

    public boolean isDisposed() {
        Item[] itemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item != null && item.isDisposed()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static class Item {
        final Label label;
        final MouseListener listener;
        final GamaCommand command;

        Item(Composite composite, GamaCommand gamaCommand, MouseListener mouseListener) {
            this.command = gamaCommand;
            this.listener = mouseListener;
            this.label = new Label(composite, 0);
            if (gamaCommand.text() != null) {
                this.label.setText(gamaCommand.text());
            }
            this.label.setToolTipText(gamaCommand.tooltip());
            this.enable(true);
        }

        void enable(boolean bl) {
            if (this.command.image() != null) {
                this.label.setImage(bl ? GamaIcon.named(this.command.image()).image() : GamaIcon.named(this.command.image()).disabled());
            }
            this.label.removeMouseListener(this.listener);
            if (bl) {
                this.label.addMouseListener(this.listener);
            }
        }

        public boolean isDisposed() {
            return this.label != null && this.label.isDisposed();
        }
    }
}

