/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.common.util.StringUtils;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.GAML;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.GamaStringType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.ITooltipDisplayer;
import gama.ui.shared.parameters.ExpressionBasedEditor;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExpressionControl
implements SelectionListener,
ModifyListener,
FocusListener {
    private final Text text;
    private final ExpressionBasedEditor<Object> editor;
    private Object currentValue;
    protected Exception currentException;
    final boolean evaluateExpression;
    private final IAgent hostAgent;
    private final IScope scope;
    private final IType<?> expectedType;
    MouseTrackListener tooltipListener = new MouseTrackAdapter(){

        public void mouseExit(MouseEvent mouseEvent) {
            ExpressionControl.this.removeTooltip();
        }
    };

    public ExpressionControl(IScope iScope, Composite composite, ExpressionBasedEditor expressionBasedEditor, IAgent iAgent, IType<?> iType, int n, boolean bl) {
        this.scope = iScope;
        this.editor = expressionBasedEditor;
        this.evaluateExpression = bl;
        this.hostAgent = iAgent;
        this.expectedType = iType;
        this.text = this.createTextBox(composite, n);
        this.text.addModifyListener((ModifyListener)this);
        this.text.addFocusListener((FocusListener)this);
        this.text.addSelectionListener((SelectionListener)this);
        this.text.addMouseTrackListener(this.tooltipListener);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (this.editor != null && this.editor.internalModification) {
            return;
        }
        this.modifyValue();
        this.displayTooltip();
    }

    protected void displayTooltip() {
        String string = this.getPopupText();
        if (string == null || string.isEmpty()) {
            this.removeTooltip();
        } else {
            ITooltipDisplayer iTooltipDisplayer = GamaToolbarFactory.findTooltipDisplayer((Control)this.text);
            if (iTooltipDisplayer != null) {
                iTooltipDisplayer.displayTooltip(string, null);
            }
        }
        if (this.editor != null && this.currentException != null) {
            this.editor.getLabel().signalErrored();
        }
    }

    protected void removeTooltip() {
        ITooltipDisplayer iTooltipDisplayer = GamaToolbarFactory.findTooltipDisplayer((Control)this.text);
        if (iTooltipDisplayer != null) {
            iTooltipDisplayer.stopDisplayingTooltips();
        }
        if (this.editor != null) {
            this.editor.getLabel().cancelErrored();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        try {
            if (this.text == null || this.text.isDisposed()) {
                return;
            }
            this.modifyValue();
            this.displayValue(this.getCurrentValue());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private Object computeValue() {
        IAgent iAgent;
        block12: {
            try {
                this.currentException = null;
                iAgent = this.getHostAgent();
                if (this.text != null && !this.text.isDisposed()) break block12;
                return null;
            }
            catch (Exception exception) {
                this.currentException = exception;
                return null;
            }
        }
        String string = this.text.getText();
        if (this.expectedType == Types.STRING && !StringUtils.isGamaString((String)string)) {
            string = StringUtils.toGamlString((String)string);
        }
        if (iAgent != null && (iAgent.getScope().interrupted() || iAgent.dead()) && iAgent instanceof SimulationAgent && (iAgent = iAgent.getScope().getExperiment()) == null) {
            iAgent = GAMA.getRuntimeScope().getExperiment();
        }
        if ("-- Undefined --".equals(string)) {
            this.setCurrentValue(null);
        } else if (iAgent == null) {
            if (this.expectedType == Types.STRING) {
                this.setCurrentValue(StringUtils.toJavaString((String)GamaStringType.staticCast(null, (Object)string, (boolean)false)));
            } else {
                this.setCurrentValue(this.expectedType.cast(this.scope, (Object)string, null, false));
            }
        } else if (!iAgent.dead()) {
            this.setCurrentValue(this.evaluateExpression ? GAML.evaluateExpression((String)string, (IAgent)iAgent) : GAML.compileExpression((String)string, (IAgent)iAgent, (boolean)true));
        }
        return this.getCurrentValue();
    }

    public void modifyValue() {
        Object object = this.getCurrentValue();
        Object object2 = this.computeValue();
        if (this.currentException != null) {
            this.setCurrentValue(object);
            return;
        }
        if (this.editor != null) {
            try {
                if (this.editor.acceptNull && object2 == null) {
                    this.editor.modifyValue(null);
                } else if (this.expectedType == Types.STRING) {
                    this.editor.modifyValue(this.evaluateExpression ? StringUtils.toJavaString((String)GamaStringType.staticCast((IScope)this.scope, (Object)object2, (boolean)false)) : object2);
                } else {
                    this.editor.modifyValue(this.evaluateExpression ? this.expectedType.cast(this.scope, object2, null, false) : object2);
                }
                this.editor.updateToolbar();
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                this.setCurrentValue(object);
                this.currentException = gamaRuntimeException;
            }
        }
    }

    protected Text createTextBox(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 2;
        fillLayout.marginWidth = 2;
        composite2.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        composite2.setLayoutData((Object)gridData);
        composite2.addListener(9, event -> {
            GC gC = event.gc;
            Rectangle rectangle = composite2.getBounds();
            Color color = composite.getBackground();
            gC.setBackground(ThemeHelper.isDark() ? GamaColors.get(color).lighter() : GamaColors.get(color).darker());
            gC.fillRoundRectangle(0, 0, rectangle.width, rectangle.height, 5, 5);
        });
        Text text = new Text(composite2, n);
        text.setForeground(GamaColors.getTextColorForBackground(composite.getBackground()).color());
        return text;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == null || !focusEvent.widget.equals(this.text)) {
            return;
        }
        this.widgetDefaultSelected(null);
    }

    public Text getControl() {
        return this.text;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public String getPopupText() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.getCurrentValue();
        if (this.currentException != null) {
            stringBuilder.append(this.currentException.getMessage());
        } else if (!this.isOK(object).booleanValue()) {
            stringBuilder.append("The current value should be of type ").append(this.expectedType);
        }
        return stringBuilder.toString();
    }

    private Boolean isOK(Object object) {
        if (this.evaluateExpression) {
            return this.expectedType.canBeTypeOf(this.scope, object);
        }
        if (object instanceof IExpression) {
            return this.expectedType.isAssignableFrom(((IExpression)object).getGamlType());
        }
        return false;
    }

    IAgent getHostAgent() {
        return this.hostAgent == null ? (this.editor == null ? null : this.editor.getAgent()) : this.hostAgent;
    }

    protected Object getCurrentValue() {
        return this.currentValue;
    }

    protected void setCurrentValue(Object object) {
        this.currentValue = object;
    }

    public void displayValue(Object object) {
        this.setCurrentValue(this.evaluateExpression ? (this.expectedType == Types.STRING ? StringUtils.toJavaString((String)GamaStringType.staticCast((IScope)this.scope, (Object)object, (boolean)false)) : this.expectedType.cast(this.scope, object, null, false)) : object);
        if (this.text.isDisposed()) {
            return;
        }
        if (this.expectedType == Types.STRING) {
            this.text.setText(this.currentValue == null ? "" : StringUtils.toJavaString((String)this.currentValue.toString()));
        } else {
            this.text.setText(StringUtils.toGaml((Object)object, (boolean)false));
        }
    }
}

