/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.commands;

import gama.core.common.interfaces.IGui;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.gaml.statements.test.CompoundSummary;
import gama.gaml.statements.test.TestExperimentSummary;
import gama.ui.shared.access.ModelsFinder;
import gama.ui.shared.utils.SwtGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;

public class TestsRunner {
    public static CompoundSummary<TestExperimentSummary, ?> LAST_RUN;

    public static void start() {
        List<IFile> list;
        if (SwtGui.ALL_TESTS_RUNNING) {
            return;
        }
        LAST_RUN = new CompoundSummary();
        IGui iGui = GAMA.getRegularGui();
        IScope iScope = GAMA.getRuntimeScope();
        iGui.openTestView(iScope, true);
        try {
            list = TestsRunner.findTestModels();
        }
        catch (CoreException coreException) {
            return;
        }
        int n = list.size();
        int[] nArray = new int[]{1};
        Job.createSystem((String)"All tests", iProgressMonitor -> {
            for (IFile iFile : list) {
                int n2 = nArray[0];
                nArray[0] = n2 + 1;
                iGui.displayTestsProgress(iScope, n2, n);
                List list2 = iGui.runHeadlessTests((Object)iFile);
                if (list2 == null) continue;
                LAST_RUN.addSummaries((Collection)list2);
            }
            iGui.displayTestsResults(iScope, LAST_RUN);
            SwtGui.ALL_TESTS_RUNNING = false;
            iGui.endTestDisplay();
        }).schedule();
    }

    private static List<IFile> findTestModels() throws CoreException {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (TestsRunner.isInteresting(iProject)) {
                arrayList.addAll(ModelsFinder.getAllGamaFilesInProject(iProject));
            }
            ++n2;
        }
        return arrayList;
    }

    private static boolean isInteresting(IProject iProject) throws CoreException {
        if (iProject == null || !iProject.exists() || !iProject.isAccessible()) {
            return false;
        }
        if (iProject.getDescription().hasNature("gama.ui.application.testNature")) {
            return true;
        }
        if (((Boolean)GamaPreferences.Runtime.USER_TESTS.getValue()).booleanValue()) {
            if (iProject.getDescription().hasNature("gama.ui.application.builtinNature")) {
                return false;
            }
            IResource iResource = iProject.findMember("tests");
            if (iResource != null && iResource.exists() && iResource.isAccessible() && iResource.getType() == 2) {
                return true;
            }
        }
        return false;
    }
}

