/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.InputParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.shared.interfaces.EditorListener;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.parameters.NumberEditor;

public class FloatEditor
extends NumberEditor<Double> {
    FloatEditor(IAgent iAgent, IParameter iParameter, boolean bl, EditorListener<Double> editorListener) {
        super(iAgent, iParameter, editorListener, bl);
    }

    FloatEditor(IScope iScope, EditorsGroup editorsGroup, String string, Double d, Double d2, Double d3, Double d4, boolean bl, EditorListener<Double> editorListener) {
        super(iScope.getAgent(), (IParameter)new InputParameter(string, (Object)d, (Comparable)d2, (Comparable)d3, (Comparable)d4), editorListener, bl);
        this.createControls(editorsGroup);
    }

    @Override
    protected Double defaultStepValue() {
        return 0.1;
    }

    @Override
    protected boolean modifyValue(Object object) throws GamaRuntimeException {
        Double d = Cast.asFloat((IScope)this.getScope(), (Object)object);
        if (this.acceptNull && object == null) {
            d = null;
        } else {
            if (this.getMinValue() != null && d < Cast.asFloat((IScope)this.getScope(), this.getMinValue())) {
                throw GamaRuntimeException.error((String)("Value " + String.valueOf(d) + " should be greater than " + String.valueOf(this.getMinValue())), (IScope)this.getScope());
            }
            if (this.getMaxValue() != null && d > Cast.asFloat((IScope)this.getScope(), this.getMaxValue())) {
                throw GamaRuntimeException.error((String)("Value " + String.valueOf(d) + " should be smaller than " + String.valueOf(this.getMaxValue())), (IScope)this.getScope());
            }
        }
        return super.modifyValue(d);
    }

    @Override
    protected Double normalizeValues() throws GamaRuntimeException {
        Double d = this.getOriginalValue() == null ? 0.0 : Cast.asFloat((IScope)this.getScope(), this.getOriginalValue());
        this.currentValue = this.getOriginalValue() == null ? null : d;
        return d;
    }

    @Override
    public IType<Double> getExpectedType() {
        return Types.FLOAT;
    }

    @Override
    protected Double applyPlus() {
        if (this.currentValue == null) {
            return 0.0;
        }
        Double d = (Double)this.currentValue;
        return d + (Double)this.getStepValue();
    }

    @Override
    protected Double applyMinus() {
        if (this.currentValue == null) {
            return 0.0;
        }
        Double d = (Double)this.currentValue;
        return d - (Double)this.getStepValue();
    }

    @Override
    protected void updateToolbar() {
        super.updateToolbar();
        this.editorToolbar.enable(0, this.param.isDefined() && (this.getMaxValue() == null || this.applyPlus() < Cast.asFloat((IScope)this.getScope(), this.getMaxValue())));
        this.editorToolbar.enable(1, this.param.isDefined() && (this.getMinValue() == null || this.applyMinus() > Cast.asFloat((IScope)this.getScope(), this.getMinValue())));
    }
}

