/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.utils;

import gama.dev.DEBUG;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.GamaPreferencesView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.CoolBarToTrimManager;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.wizards.AbstractExtensionWizardRegistry;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CleanupHelper {
    static {
        DEBUG.ON();
    }

    public static void run() {
        RemoveUnwantedWizards.run();
        RemoveUnwantedActionSets.run();
        RearrangeMenus.run();
        ForceMaximizeRestoration.run();
        RemoveActivities.run();
        Job job = new Job("Preloading preferences"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                GamaPreferencesView.preload();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(50);
        job.schedule();
    }

    static class ForceMaximizeRestoration {
        ForceMaximizeRestoration() {
        }

        public static void run() {
            IWorkbenchWindow[] iWorkbenchWindowArray;
            IWorkbenchWindow[] iWorkbenchWindowArray2 = iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray2[n2];
                final IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage != null) {
                    iWorkbenchPage.addPartListener(new IPartListener2(){

                        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
                        }

                        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
                            IViewReference iViewReference;
                            IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
                            IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                            IViewReference[] iViewReferenceArray2 = iViewReferenceArray;
                            int n = iViewReferenceArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                iViewReference = iViewReferenceArray2[n2];
                                if (!iWorkbenchPartReference.equals(iViewReference) && iWorkbenchPage.getPartState((IWorkbenchPartReference)iViewReference) == 1) {
                                    iWorkbenchPage.toggleZoom((IWorkbenchPartReference)iViewReference);
                                    break;
                                }
                                ++n2;
                            }
                            iViewReferenceArray2 = iEditorReferenceArray;
                            n = iEditorReferenceArray.length;
                            n2 = 0;
                            while (n2 < n) {
                                iViewReference = iViewReferenceArray2[n2];
                                if (!iWorkbenchPartReference.equals(iViewReference) && iWorkbenchPage.getPartState((IWorkbenchPartReference)iViewReference) == 1) {
                                    iWorkbenchPage.toggleZoom((IWorkbenchPartReference)iViewReference);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    });
                }
                ++n2;
            }
        }
    }

    public static class RearrangeMenus {
        public static final Set<String> MENU_ITEMS_TO_REMOVE = new HashSet<String>(Arrays.asList("openWorkspace", "helpSearch", "org.eclipse.search.OpenFileSearchPage", "textSearchSubMenu", "reopenEditors", "converstLineDelimitersTo", "org.eclipse.equinox.p2.ui.sdk.update", "org.eclipse.ui.edit.text.toggleBlockSelectionMode", "org.eclipse.ui.edit.text.toMultiSelection", "org.eclipse.equinox.p2.ui.sdk.install", "org.eclipse.equinox.p2.ui.sdk.installationDetails", "org.eclipse.e4.ui.importer.openDirectory.menu"));
        public static final Map<String, String> MENU_IMAGES = new HashMap<String, String>(){
            {
                this.put("print", "generic/menu.print");
                this.put("save", "generic/menu.save");
                this.put("saveAs", "generic/menu.saveas");
                this.put("saveAll", "generic/menu.saveall");
                this.put("revert", "generic/menu.revert");
                this.put("refresh", "navigator/file.refresh");
                this.put("new", "navigator/navigator.new2");
                this.put("import", "navigator/menu.import");
                this.put("export", "navigator/menu.export");
                this.put("undo", "generic/menu.undo");
                this.put("redo", "generic/menu.redo");
                this.put("cut", "generic/menu.cut");
                this.put("copy", "generic/menu.copy");
                this.put("paste", "generic/menu.paste");
                this.put("delete", "generic/menu.delete");
                this.put("helpContents", "generic/menu.help");
                this.put("org.eclipse.search.OpenSearchDialog", "generic/menu.search");
                this.put("org.eclipse.ui.openLocalFile", "navigator/navigator.open2");
                this.put("converstLineDelimitersTo", "editor/menu.delimiter");
            }
        };

        public static void run() {
            WorkbenchHelper.runInUI("Rearranging menus", 0, iProgressMonitor -> {
                IWorkbenchWindow iWorkbenchWindow = Workbench.getInstance().getActiveWorkbenchWindow();
                if (iWorkbenchWindow instanceof WorkbenchWindow) {
                    MenuManager menuManager = ((WorkbenchWindow)iWorkbenchWindow).getMenuManager();
                    IContributionItem[] iContributionItemArray = menuManager.getItems();
                    int n = iContributionItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem iContributionItem = iContributionItemArray[n2];
                        MenuManager menuManager2 = null;
                        if (iContributionItem instanceof MenuManager) {
                            menuManager2 = (MenuManager)iContributionItem;
                        } else if (iContributionItem instanceof ActionSetContributionItem && ((ActionSetContributionItem)iContributionItem).getInnerItem() instanceof MenuManager) {
                            menuManager2 = (MenuManager)((ActionSetContributionItem)iContributionItem).getInnerItem();
                        }
                        if (menuManager2 != null) {
                            RearrangeMenus.processItems((IMenuManager)menuManager2);
                        }
                        ++n2;
                    }
                    menuManager.updateAll(true);
                }
            });
        }

        private static void processItems(IMenuManager iMenuManager) {
            IContributionItem[] iContributionItemArray = iMenuManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem iContributionItem = iContributionItemArray[n2];
                String string = iContributionItem.getId();
                if (MENU_ITEMS_TO_REMOVE.contains(string)) {
                    iContributionItem.setVisible(false);
                } else {
                    RearrangeMenus.changeIcon(iMenuManager, iContributionItem, string);
                }
                ++n2;
            }
        }

        public static void changeIcon(IMenuManager iMenuManager, IContributionItem iContributionItem, String string) {
            if (iContributionItem.isGroupMarker() || iContributionItem.isSeparator() || !iContributionItem.isVisible()) {
                return;
            }
            String string2 = MENU_IMAGES.get(string);
            if (string2 != null) {
                RearrangeMenus.changeIcon(iMenuManager, iContributionItem, GamaIcon.named(string2).descriptor());
            }
        }

        private static void changeIcon(IMenuManager iMenuManager, IContributionItem iContributionItem, ImageDescriptor imageDescriptor) {
            if (iContributionItem instanceof ActionContributionItem) {
                ((ActionContributionItem)iContributionItem).getAction().setImageDescriptor(imageDescriptor);
            } else if (iContributionItem instanceof CommandContributionItem) {
                CommandContributionItemParameter commandContributionItemParameter = ((CommandContributionItem)iContributionItem).getData();
                commandContributionItemParameter.commandId = ((CommandContributionItem)iContributionItem).getCommand().getId();
                commandContributionItemParameter.icon = imageDescriptor;
                CommandContributionItem commandContributionItem = new CommandContributionItem(commandContributionItemParameter);
                commandContributionItem.setId(iContributionItem.getId());
                iMenuManager.insertAfter(iContributionItem.getId(), (IContributionItem)commandContributionItem);
                iMenuManager.remove(iContributionItem);
                iContributionItem.dispose();
            } else if (iContributionItem instanceof ActionSetContributionItem) {
                RearrangeMenus.changeIcon(iMenuManager, ((ActionSetContributionItem)iContributionItem).getInnerItem(), imageDescriptor);
            } else if (iContributionItem instanceof MenuManager) {
                ((MenuManager)iContributionItem).setImageDescriptor(imageDescriptor);
            }
        }
    }

    static class RemoveActivities {
        RemoveActivities() {
        }

        static void run() {
            IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            iWorkbenchActivitySupport.setEnabledActivityIds(new HashSet());
        }
    }

    static class RemoveUnwantedActionSets
    extends PerspectiveAdapter {
        String[] TOOLBAR_ACTION_SETS_TO_REMOVE = new String[]{"org.eclipse", "gaml.compiler.Gaml", "org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo"};
        String[] MENUS_TO_REMOVE = new String[]{"org.eclipse.ui.run", "window", "navigate", "project"};

        RemoveUnwantedActionSets() {
        }

        public static void run() {
            IWorkbenchWindow[] iWorkbenchWindowArray;
            RemoveUnwantedActionSets removeUnwantedActionSets = new RemoveUnwantedActionSets();
            IWorkbenchWindow[] iWorkbenchWindowArray2 = iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray2[n2];
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage != null) {
                    removeUnwantedActionSets.perspectiveActivated(iWorkbenchPage, null);
                }
                iWorkbenchWindow.addPerspectiveListener((IPerspectiveListener)removeUnwantedActionSets);
                ++n2;
            }
        }

        public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchPage.getWorkbenchWindow();
            if (workbenchWindow.isClosing()) {
                return;
            }
            WorkbenchHelper.runInUI("Cleaning menus", 0, iProgressMonitor -> {
                try {
                    IContributionItem iContributionItem;
                    IContributionItem[] iContributionItemArray;
                    if (workbenchWindow.isClosing()) {
                        return;
                    }
                    CoolBarToTrimManager coolBarToTrimManager = (CoolBarToTrimManager)workbenchWindow.getCoolBarManager2();
                    Object[] objectArray = iContributionItemArray = coolBarToTrimManager.getItems();
                    int n = iContributionItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        iContributionItem = objectArray[n2];
                        String[] stringArray = this.TOOLBAR_ACTION_SETS_TO_REMOVE;
                        int n3 = this.TOOLBAR_ACTION_SETS_TO_REMOVE.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String string = stringArray[n4];
                            if (iContributionItem.getId().contains(string)) {
                                try {
                                    if (workbenchWindow.getCoolBarManager2().find(iContributionItem.getId()) != null) {
                                        workbenchWindow.getCoolBarManager2().remove(iContributionItem);
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    objectArray = this.MENUS_TO_REMOVE;
                    n = this.MENUS_TO_REMOVE.length;
                    n2 = 0;
                    while (n2 < n) {
                        iContributionItem = objectArray[n2];
                        workbenchWindow.getMenuBarManager().remove((String)iContributionItem);
                        workbenchWindow.getMenuManager().remove((String)iContributionItem);
                        ++n2;
                    }
                    workbenchWindow.getMenuManager().update(true);
                    workbenchWindow.getMenuBarManager().update(true);
                    coolBarToTrimManager.resetItemOrder();
                }
                catch (Exception exception) {}
            });
        }

        public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
            if ("resetComplete".equals(string)) {
                this.perspectiveActivated(iWorkbenchPage, iPerspectiveDescriptor);
            }
        }
    }

    static class RemoveUnwantedWizards {
        private static Set<String> CATEGORIES_TO_REMOVE = new HashSet<String>(Arrays.asList("org.eclipse.pde.PDE", "org.eclipse.emf.codegen.ecore.ui.wizardCategory"));
        private static Set<String> IDS_TO_REMOVE = new HashSet<String>(Arrays.asList("org.eclipse.ui.wizards.new.project", "org.eclipse.equinox.p2.replication.import", "org.eclipse.equinox.p2.replication.importfrominstallation", "org.eclipse.team.ui.ProjectSetImportWizard", "org.eclipse.equinox.p2.replication.export", "org.eclipse.team.ui.ProjectSetExportWizard"));

        RemoveUnwantedWizards() {
        }

        static void run() {
            ArrayList<IWizardCategory> arrayList = new ArrayList<IWizardCategory>();
            AbstractExtensionWizardRegistry abstractExtensionWizardRegistry = (AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getNewWizardRegistry();
            arrayList.addAll(Arrays.asList(abstractExtensionWizardRegistry.getRootCategory().getCategories()));
            abstractExtensionWizardRegistry = (AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getImportWizardRegistry();
            arrayList.addAll(Arrays.asList(abstractExtensionWizardRegistry.getRootCategory().getCategories()));
            abstractExtensionWizardRegistry = (AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getExportWizardRegistry();
            arrayList.addAll(Arrays.asList(abstractExtensionWizardRegistry.getRootCategory().getCategories()));
            IWizardDescriptor[] iWizardDescriptorArray = RemoveUnwantedWizards.getAllWizards(arrayList.toArray(new IWizardCategory[0]));
            int n = iWizardDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardDescriptor iWizardDescriptor = iWizardDescriptorArray[n2];
                String string = iWizardDescriptor.getCategory().getId();
                if (CATEGORIES_TO_REMOVE.contains(string) || IDS_TO_REMOVE.contains(iWizardDescriptor.getId())) {
                    WorkbenchWizardElement workbenchWizardElement = (WorkbenchWizardElement)iWizardDescriptor;
                    abstractExtensionWizardRegistry.removeExtension(workbenchWizardElement.getConfigurationElement().getDeclaringExtension(), new Object[]{workbenchWizardElement});
                }
                ++n2;
            }
        }

        private static IWizardDescriptor[] getAllWizards(IWizardCategory[] iWizardCategoryArray) {
            ArrayList<IWizardDescriptor> arrayList = new ArrayList<IWizardDescriptor>();
            IWizardCategory[] iWizardCategoryArray2 = iWizardCategoryArray;
            int n = iWizardCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardCategory iWizardCategory = iWizardCategoryArray2[n2];
                arrayList.addAll(Arrays.asList(iWizardCategory.getWizards()));
                arrayList.addAll(Arrays.asList(RemoveUnwantedWizards.getAllWizards(iWizardCategory.getCategories())));
                ++n2;
            }
            return arrayList.toArray(new IWizardDescriptor[0]);
        }
    }
}

