/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls;

import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.dev.DEBUG;
import gama.ui.shared.controls.StatusControlContribution;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class HistoryPopUpMenu
extends PopupDialog {
    Composite parent;
    Composite contents;
    Composite labelComposite;
    Label labelButton;
    Label labelText;
    final Listener hide = event -> this.hide();
    private final StatusControlContribution status;

    static {
        DEBUG.ON();
    }

    public HistoryPopUpMenu(StatusControlContribution statusControlContribution) {
        super(WorkbenchHelper.getShell(), 540676, false, false, false, false, false, null, null);
        this.status = statusControlContribution;
        Shell shell = statusControlContribution.getControllingShell();
        shell.addListener(10, this.hide);
        shell.addListener(11, this.hide);
        shell.addListener(21, this.hide);
        shell.addListener(27, this.hide);
        shell.addListener(23, this.hide);
        shell.addListener(12, event -> {
            boolean bl = this.close();
        });
    }

    protected Control createContents(Composite composite) {
        if (this.parent != composite || this.parent.isDisposed()) {
            this.parent = composite;
            GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(this.parent);
        }
        if (this.contents == null || this.contents.isDisposed()) {
            this.contents = (Composite)super.createDialogArea(this.parent);
            GridDataFactory.swtDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)this.contents);
            GridLayoutFactory.swtDefaults().numColumns(1).margins(5, 5).spacing(0, 5).applyTo(this.contents);
        }
        if (this.labelComposite == null || this.labelComposite.isDisposed()) {
            this.createLabel();
        }
        return this.contents;
    }

    private void createLabel() {
        try {
            this.labelComposite = new Composite(this.contents, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).spacing(5, 0).applyTo(this.labelComposite);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.labelComposite);
            this.labelButton = new Label(this.labelComposite, 0);
            this.labelButton.setImage(GamaIcon.named("experiment/errors.show").image());
            this.labelText = new Label(this.labelComposite, 64);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, true).applyTo((Control)this.labelButton);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.labelText);
            this.labelText.addMouseTrackListener(new MouseTrackListener(){
                Color background;
                Color foreground;

                public void mouseHover(MouseEvent mouseEvent) {
                }

                public void mouseEnter(MouseEvent mouseEvent) {
                    this.background = HistoryPopUpMenu.this.labelText.getBackground();
                    this.foreground = HistoryPopUpMenu.this.labelText.getForeground();
                    GamaColor gamaColor = IGamaColors.ERROR.gamaColor();
                    Color color = GamaColors.toSwtColor((java.awt.Color)gamaColor);
                    GamaColors.setBackAndForeground(color, GamaColors.getTextColorForBackground(color).color(), new Control[]{HistoryPopUpMenu.this.labelText});
                }

                public void mouseExit(MouseEvent mouseEvent) {
                    GamaColors.setBackAndForeground(this.background, this.foreground, new Control[]{HistoryPopUpMenu.this.labelText});
                }
            });
            this.labelText.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    HistoryPopUpMenu.this.hide();
                    EObject eObject = (EObject)HistoryPopUpMenu.this.labelText.getData();
                    if (eObject != null) {
                        WorkbenchHelper.asyncRun(() -> GAMA.getGui().editModel((Object)eObject));
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean hasTitleArea() {
        return false;
    }

    protected boolean hasInfoArea() {
        return false;
    }

    protected void showDialogMenu() {
    }

    protected void setInfoText(String string) {
    }

    protected void setTitleText(String string) {
    }

    protected void saveDialogBounds(Shell shell) {
    }

    protected Point getDefaultLocation(Point point) {
        Point point2 = this.status.getLocation();
        return new Point(point2.x, point2.y + this.status.getHeight() - 4);
    }

    protected Point getDefaultSize() {
        int n = this.status.getWidth();
        if (n <= 0) {
            n = -1;
        }
        return this.getShell().computeSize(n, -1, true);
    }

    public boolean isVisible() {
        return this.getShell() != null && this.getShell().isVisible();
    }

    public void display(GamaRuntimeException gamaRuntimeException) {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            this.open();
            shell = this.getShell();
        }
        this.createContents(this.parent);
        this.labelText.setText(gamaRuntimeException.getAllText());
        this.labelText.setData((Object)gamaRuntimeException.getEditorContext());
        this.labelComposite.requestLayout();
        shell.setLocation(this.getDefaultLocation(null));
        shell.setSize(this.getDefaultSize());
        shell.setVisible(true);
    }

    public void hide() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setVisible(false);
        }
    }
}

