/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls;

import com.google.common.base.Strings;
import com.google.common.collect.ForwardingList;
import gama.core.common.IStatusMessage;
import gama.core.common.StatusMessage;
import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamlIdiomsProvider;
import gama.ui.shared.controls.StatusControlContribution;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class StatusHistoryPopUpMenu
extends PopupDialog {
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    int limit = 30;
    Composite parent;
    Composite contents;
    List<Composite> labels = new CopyOnWriteArrayList<Composite>();
    List<IStatusMessage> events = new BoundedList();
    final Listener hide = event -> this.hide();
    private final StatusControlContribution status;

    static {
        DEBUG.ON();
    }

    public StatusHistoryPopUpMenu(StatusControlContribution statusControlContribution) {
        super(WorkbenchHelper.getShell(), 540676, false, false, false, false, false, null, null);
        this.status = statusControlContribution;
        Shell shell = statusControlContribution.getControllingShell();
        shell.addListener(10, this.hide);
        shell.addListener(11, this.hide);
        shell.addListener(21, this.hide);
        shell.addListener(27, this.hide);
        shell.addListener(23, this.hide);
        shell.addListener(12, event -> {
            boolean bl = this.close();
        });
    }

    protected Control createContents(Composite composite) {
        if (this.parent != composite || this.parent.isDisposed()) {
            this.parent = composite;
            GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(this.parent);
        }
        this.createToolbar();
        if (this.contents == null || this.contents.isDisposed()) {
            this.contents = (Composite)super.createDialogArea(this.parent);
            GridDataFactory.swtDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)this.contents);
            GridLayoutFactory.swtDefaults().numColumns(1).margins(5, 5).spacing(0, 5).applyTo(this.contents);
        }
        this.fillLabels();
        this.contents.requestLayout();
        return this.contents;
    }

    private void fillLabels() {
        int n = this.events.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                IStatusMessage iStatusMessage = this.events.get(n2);
                Composite composite = this.getOrCreateLabel(n2);
                Label label = (Label)composite.getChildren()[1];
                Label label2 = (Label)composite.getChildren()[0];
                Label label3 = (Label)composite.getChildren()[2];
                label2.setText(this.sdf.format(new Date(iStatusMessage.timeStamp())));
                label.setImage(GamaIcon.named(iStatusMessage.icon()).image());
                composite.setData((Object)iStatusMessage);
                label3.setText(GamlIdiomsProvider.toText((String)iStatusMessage.message()));
                label3.setToolTipText(iStatusMessage.message());
                label2.pack(true);
                label.pack(true);
                composite.requestLayout();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        if (n < this.labels.size()) {
            n2 = n;
            while (n2 < this.labels.size()) {
                this.labels.get(n2).dispose();
                this.labels.remove(n2);
                ++n2;
            }
        }
    }

    Composite getOrCreateLabel(int n) {
        Composite composite;
        if (n > this.labels.size() - 1) {
            this.labels.add(this.createLabel());
        }
        if ((composite = this.labels.get(n)) == null || composite.isDisposed()) {
            this.labels.remove(n);
            composite = this.createLabel();
            this.labels.add(n, composite);
        }
        return composite;
    }

    private Composite createLabel() {
        try {
            Composite composite = new Composite(this.contents, 0);
            GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).spacing(5, 0).applyTo(composite);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
            Label label = new Label(composite, 0);
            Label label2 = new Label(composite, 0);
            final Label label3 = new Label(composite, 0);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)label);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)label2);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)label3);
            label3.addMouseTrackListener(new MouseTrackListener(){
                Color background;
                Color foreground;

                public void mouseHover(MouseEvent mouseEvent) {
                }

                public void mouseEnter(MouseEvent mouseEvent) {
                    if (this.background == null && this.foreground == null) {
                        this.background = label3.getBackground();
                        this.foreground = label3.getForeground();
                    }
                    GamaColors.setBackAndForeground(this.foreground, this.background, new Control[]{label3});
                }

                public void mouseExit(MouseEvent mouseEvent) {
                    GamaColors.setBackAndForeground(this.background, this.foreground, new Control[]{label3});
                }
            });
            label3.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    StatusHistoryPopUpMenu.this.hide();
                    StatusMessage statusMessage = (StatusMessage)label3.getParent().getData();
                    if (statusMessage.isError()) {
                        GAMA.getGui().editModel((Object)statusMessage.exception().getEditorContext());
                    } else {
                        GAMA.getGui().showView(null, "org.eclipse.ui.views.ProgressView", null, 1);
                    }
                }
            });
            return composite;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void createToolbar() {
    }

    protected boolean hasTitleArea() {
        return false;
    }

    protected boolean hasInfoArea() {
        return false;
    }

    protected void showDialogMenu() {
    }

    protected void setInfoText(String string) {
    }

    protected void setTitleText(String string) {
    }

    protected void saveDialogBounds(Shell shell) {
    }

    protected Point getDefaultLocation(Point point) {
        Point point2 = this.status.getLocation();
        return new Point(point2.x, point2.y + this.status.getHeight() - 4);
    }

    protected Point getDefaultSize() {
        int n = this.status.getWidth();
        if (n <= 0) {
            n = -1;
        }
        return this.getShell().computeSize(n, -1, true);
    }

    public boolean isVisible() {
        return this.getShell() != null && this.getShell().isVisible();
    }

    public void display() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.createContents(this.parent);
            shell.setLocation(this.getDefaultLocation(null));
            shell.setSize(this.getDefaultSize());
            shell.setVisible(true);
        } else {
            this.open();
        }
    }

    public void hide() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setVisible(false);
        }
    }

    public void wipe() {
        for (Control control : this.labels) {
            if (control.isDisposed()) continue;
            control.setData(null);
        }
    }

    public void addStatus(IStatusMessage iStatusMessage) {
        String string = iStatusMessage.message();
        if (Strings.isNullOrEmpty((String)string)) {
            return;
        }
        Iterator<IStatusMessage> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            IStatusMessage iStatusMessage2 = iterator.next();
            if (!string.equals(iStatusMessage2.message())) continue;
            iterator.remove();
            break;
        }
        this.events.add(iStatusMessage);
    }

    public class BoundedList<T>
    extends ForwardingList<T> {
        LinkedList<T> delegate = new LinkedList();

        protected List<T> delegate() {
            return this.delegate;
        }

        public void add(int n, T t) {
            if (this.delegate.size() > StatusHistoryPopUpMenu.this.limit) {
                this.delegate.removeLast();
            }
            super.add(n, t);
        }

        public boolean addAll(int n, Collection<? extends T> collection) {
            for (T t : collection) {
                this.add(n, t);
            }
            return true;
        }

        public boolean add(T t) {
            if (this.delegate.size() > StatusHistoryPopUpMenu.this.limit) {
                this.delegate.removeLast();
            }
            this.delegate.addFirst(t);
            return true;
        }

        public boolean addAll(Collection<? extends T> collection) {
            for (T t : collection) {
                this.add(t);
            }
            return true;
        }
    }
}

