/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.factories;

import gama.core.common.IStatusMessage;
import gama.core.common.StatusMessageFactory;
import gama.core.common.interfaces.IStatusControl;
import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.common.interfaces.ITopLevelAgentChangeListener;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExperimentStateListener;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class StatusDisplayer
implements IStatusDisplayer,
IExperimentStateListener {
    private IStatusControl experimentControl = new IStatusControl(){};
    private IStatusControl statusControl = new IStatusControl(){};
    private final StatusRefresher statusRefresher = new StatusRefresher("Status refresh");
    private final ExperimentRefresher experimentRefresher = new ExperimentRefresher("Experiment refresh");

    StatusDisplayer() {
        GAMA.registerTopLevelAgentChangeListener((ITopLevelAgentChangeListener)this);
        GAMA.addExperimentStateListener((IExperimentStateListener)this);
    }

    public void topLevelAgentChanged(ITopLevelAgent iTopLevelAgent) {
        this.updateExperimentStatus();
    }

    public void updateStateTo(IExperimentPlan iExperimentPlan, IExperimentStateListener.State state) {
        this.updateExperimentStatus();
    }

    public void informStatus(String string, String string2) {
        this.setStatus(string, IStatusMessage.StatusType.REGULAR, string2);
    }

    public void errorStatus(GamaRuntimeException gamaRuntimeException) {
        this.statusRefresher.updateWith(StatusMessageFactory.ERROR((GamaRuntimeException)gamaRuntimeException));
    }

    private void setStatus(String string, IStatusMessage.StatusType statusType, String string2) {
        this.statusRefresher.updateWith(StatusMessageFactory.CUSTOM((String)string, (IStatusMessage.StatusType)statusType, (String)string2, null));
    }

    public void setTaskCompletion(String string, Double d) {
        this.statusRefresher.updateWith(StatusMessageFactory.COMPLETION((String)string, (Double)d));
    }

    public void updateExperimentStatus() {
        this.experimentRefresher.schedule();
    }

    public void beginTask(String string, String string2) {
        this.setStatus(string, IStatusMessage.StatusType.REGULAR, string2);
    }

    public void endTask(String string, String string2) {
        this.setStatus(string, IStatusMessage.StatusType.REGULAR, string2);
    }

    public void setStatus(String string, String string2, GamaColor gamaColor) {
        if (string != null) {
            this.statusRefresher.updateWith(StatusMessageFactory.CUSTOM((String)string, (IStatusMessage.StatusType)IStatusMessage.StatusType.REGULAR, (String)string2, (GamaColor)gamaColor));
        }
    }

    public void setExperimentTarget(IStatusControl iStatusControl) {
        this.experimentControl = iStatusControl;
    }

    public void setStatusTarget(IStatusControl iStatusControl) {
        this.statusControl = iStatusControl;
    }

    private class ExperimentRefresher
    extends UIJob {
        public ExperimentRefresher(String string) {
            super(WorkbenchHelper.getDisplay(), string);
            this.setProperty(IStatusMessage.JOB_KEY, "internal");
            this.setPriority(10);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (StatusDisplayer.this.experimentControl.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            StatusDisplayer.this.experimentControl.updateWith(StatusMessageFactory.EXPERIMENT());
            return Status.OK_STATUS;
        }
    }

    private class StatusRefresher
    extends UIJob {
        IStatusMessage message;

        public StatusRefresher(String string) {
            super(WorkbenchHelper.getDisplay(), string);
            this.message = null;
            this.setProperty(IStatusMessage.JOB_KEY, "internal");
            this.setPriority(50);
            this.setSystem(true);
        }

        public void updateWith(IStatusMessage iStatusMessage) {
            this.message = iStatusMessage;
            if (iStatusMessage != null) {
                this.schedule();
            }
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            try {
                if (this.message != null) {
                    if (StatusDisplayer.this.statusControl.isDisposed()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    StatusDisplayer.this.statusControl.updateWith(this.message);
                }
            }
            finally {
                this.message = null;
            }
            return Status.OK_STATUS;
        }
    }
}

