/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import gama.core.util.GamaFont;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class GamaFonts {
    static int MAX_SIZE = 512;
    static int MIN_SIZE = 6;
    static LoadingCache<FontData, Font> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<FontData, Font>(){

        public Font load(FontData fontData) throws Exception {
            return new Font((Device)WorkbenchHelper.getDisplay(), fontData);
        }
    });

    public static Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        return (Font)CACHE.getUnchecked((Object)fontData);
    }

    public static Font getFont(GamaFont gamaFont) {
        if (gamaFont == null) {
            return null;
        }
        return GamaFonts.getFont(new FontData(gamaFont.getName(), gamaFont.getSize(), gamaFont.getStyle()));
    }

    public static Font withSize(Font font, int n) {
        return GamaFonts.getFont(GamaFonts.withSize(font.getFontData()[0], n));
    }

    private static FontData withSize(FontData fontData, int n) {
        int n2 = GamaFonts.cap(n);
        if (n2 != fontData.getHeight()) {
            fontData.setHeight(n2);
        }
        return fontData;
    }

    public static Font withMagnification(Font font, int n) {
        FontData fontData = font.getFontData()[0];
        return GamaFonts.getFont(GamaFonts.withSize(fontData, fontData.getHeight() + n));
    }

    private static int cap(int n) {
        return Math.min(MAX_SIZE, Math.max(MIN_SIZE, n));
    }
}

