/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.utils;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Monitor;

public class DPIHelper {
    public static boolean isHiDPI(Monitor monitor) {
        int n;
        int n2 = n = monitor == null ? DPIUtil.getDeviceZoom() : monitor.getZoom();
        return n > 100;
    }

    public static int getDeviceZoom(Monitor monitor) {
        return monitor == null ? DPIUtil.getDeviceZoom() : monitor.getZoom();
    }

    public static int autoScaleUp(Monitor monitor, int n) {
        int n2;
        int n3 = n2 = monitor == null ? DPIUtil.getDeviceZoom() : monitor.getZoom();
        if (100 == n2 || DPIUtil.useCairoAutoScale()) {
            return n;
        }
        float f = (float)n2 / 100.0f;
        return Math.round((float)n * f);
    }

    public static double autoScaleUp(Monitor monitor, double d) {
        int n;
        int n2 = n = monitor == null ? DPIUtil.getDeviceZoom() : monitor.getZoom();
        if (100 == n || DPIUtil.useCairoAutoScale()) {
            return d;
        }
        double d2 = (double)n / 100.0;
        return d * d2;
    }

    public static int autoScaleDown(Monitor monitor, int n) {
        int n2;
        int n3 = n2 = monitor == null ? DPIUtil.getDeviceZoom() : monitor.getZoom();
        if (100 == n2 || DPIUtil.useCairoAutoScale()) {
            return n;
        }
        float f = (float)n2 / 100.0f;
        return Math.round((float)n / f);
    }

    public static Rectangle autoScaleUp(Monitor monitor, Rectangle rectangle) {
        int n;
        int n2 = n = monitor == null ? DPIUtil.getDeviceZoom() : monitor.getZoom();
        if (n == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIHelper.autoScaleUp(monitor, new Point(rectangle.x, rectangle.y));
        Point point2 = DPIHelper.autoScaleUp(monitor, new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    public static Point autoScaleUp(Monitor monitor, Point point) {
        int n;
        int n2 = n = monitor == null ? DPIUtil.getDeviceZoom() : monitor.getZoom();
        if (n == 100 || point == null) {
            return point;
        }
        float f = (float)n / 100.0f;
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x * f);
        point2.y = Math.round((float)point.y * f);
        return point2;
    }

    public static double autoScaleDown(Monitor monitor, double d) {
        int n;
        int n2 = n = monitor == null ? DPIUtil.getDeviceZoom() : monitor.getZoom();
        if (100 == n || DPIUtil.useCairoAutoScale()) {
            return d;
        }
        double d2 = (double)n / 100.0;
        return d / d2;
    }
}

