/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import gama.dev.DEBUG;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.progress.UIJob;

public class WorkbenchHelper {
    static final Object NULL;
    public static final LoadingCache<Class<?>, Object> SERVICES;
    public static final String GAMA_NATURE = "gama.ui.application.gamaNature";
    public static final String XTEXT_NATURE = "org.eclipse.xtext.ui.shared.xtextNature";
    public static final String PLUGIN_NATURE = "gama.ui.application.pluginNature";
    public static final String TEST_NATURE = "gama.ui.application.testNature";
    public static final String BUILTIN_NATURE = "gama.ui.application.builtinNature";
    private static volatile Clipboard CLIPBOARD;
    private static final Transfer[] TRANSFERS;

    static {
        DEBUG.ON();
        NULL = new Object();
        SERVICES = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Object>(){

            public Object load(Class<?> clazz) throws Exception {
                Object object = WorkbenchHelper.getWorkbench().getService(clazz);
                if (object == null) {
                    return NULL;
                }
                return object;
            }
        });
        TRANSFERS = new Transfer[]{TextTransfer.getInstance()};
    }

    public static boolean isDisplayThread() {
        Display display = WorkbenchHelper.getDisplay();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    public static Clipboard getClipboard() {
        if (CLIPBOARD == null) {
            CLIPBOARD = WorkbenchHelper.run(() -> new Clipboard(WorkbenchHelper.getDisplay()));
        }
        return CLIPBOARD;
    }

    public static void asyncRun(Runnable runnable) {
        Display display = WorkbenchHelper.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public static void asyncRun(Runnable runnable, int n, Callable<Boolean> callable) {
        Display display = WorkbenchHelper.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(() -> display.timerExec(n, () -> {
                runnable.run();
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        WorkbenchHelper.asyncRun(runnable, n, callable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }));
        } else {
            runnable.run();
        }
    }

    public static void run(Runnable runnable) {
        Display display = WorkbenchHelper.getDisplay();
        if (display == null || display.isDisposed() || display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            display.syncExec(runnable);
        }
    }

    public static <T> T run(Callable<T> callable) {
        Display display = WorkbenchHelper.getDisplay();
        if (display == null || display.isDisposed() || display.getThread() == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                return null;
            }
        }
        Object[] objectArray = new Object[1];
        display.syncExec(() -> {
            try {
                objectArray[0] = callable.call();
            }
            catch (Exception exception) {}
        });
        return (T)objectArray[0];
    }

    public static Display getDisplay() {
        return WorkbenchHelper.getWorkbench().getDisplay();
    }

    public static IWorkbenchPage getPage() {
        WorkbenchWindow workbenchWindow = WorkbenchHelper.getWindow();
        if (workbenchWindow == null) {
            return null;
        }
        return workbenchWindow.getActivePage();
    }

    public static Shell getShell() {
        return WorkbenchHelper.getDisplay().getActiveShell();
    }

    public static WorkbenchWindow getWindow() {
        IWorkbenchWindow[] iWorkbenchWindowArray;
        WorkbenchWindow workbenchWindow = null;
        try {
            workbenchWindow = (WorkbenchWindow)WorkbenchHelper.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)"SWT bug: Window not found ");
        }
        if (workbenchWindow == null && (iWorkbenchWindowArray = WorkbenchHelper.getWorkbench().getWorkbenchWindows()) != null && iWorkbenchWindowArray.length > 0) {
            return (WorkbenchWindow)iWorkbenchWindowArray[0];
        }
        return workbenchWindow;
    }

    public static IEditorPart getActiveEditor() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage != null && ((iEditorPart = iWorkbenchPage.getActiveEditor()).getTitle().endsWith(".gaml") || iEditorPart.getTitle().endsWith(".experiment"))) {
            return iEditorPart;
        }
        return null;
    }

    public static IWorkbenchPart getActivePart() {
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage.getActivePart();
        }
        return null;
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static void setWorkbenchWindowTitle(String string) {
        WorkbenchHelper.asyncRun(() -> {
            if (WorkbenchHelper.getShell() != null) {
                WorkbenchHelper.getShell().setText(string);
            }
        });
    }

    public static <T> T getService(Class<T> clazz) {
        Object object = SERVICES.getUnchecked(clazz);
        if (object == NULL) {
            SERVICES.invalidate(clazz);
            return null;
        }
        return (T)object;
    }

    public static void copy(String string) {
        Runnable runnable = () -> WorkbenchHelper.getClipboard().setContents((Object[])new String[]{string}, TRANSFERS);
        WorkbenchHelper.asyncRun(runnable);
    }

    public static Rectangle displaySizeOf(Control control) {
        return WorkbenchHelper.run(() -> WorkbenchHelper.getDisplay().map(control, null, control.getBounds()));
    }

    public static Object runCommand(String string, Map map) {
        try {
            Command command = WorkbenchHelper.getCommand(string);
            IHandlerService iHandlerService = WorkbenchHelper.getService(IHandlerService.class);
            ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)command, (Map)map);
            return iHandlerService.executeCommand(parameterizedCommand, null);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException throwable) {
            return null;
        }
    }

    public static boolean runCommand(String string) {
        try {
            Command command = WorkbenchHelper.getCommand(string);
            IHandlerService iHandlerService = WorkbenchHelper.getService(IHandlerService.class);
            ExecutionEvent executionEvent = iHandlerService.createExecutionEvent(command, null);
            return WorkbenchHelper.runCommand(command, executionEvent);
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            return false;
        }
    }

    public static boolean runCommand(Command command, ExecutionEvent executionEvent) throws ExecutionException {
        if (command.isEnabled()) {
            try {
                command.executeWithChecks(executionEvent);
                return true;
            }
            catch (NotEnabledException | NotHandledException | NotDefinedException throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    public static Command getCommand(String string) {
        ICommandService iCommandService = WorkbenchHelper.getService(ICommandService.class);
        return iCommandService.getCommand(string);
    }

    public static void runInUI(String string, int n, final Consumer<IProgressMonitor> consumer) {
        UIJob uIJob = new UIJob(string){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                consumer.accept(iProgressMonitor);
                return Status.OK_STATUS;
            }
        };
        uIJob.setSystem(true);
        uIJob.schedule((long)n);
    }

    public static void close() {
        WorkbenchHelper.asyncRun(() -> {
            boolean bl = WorkbenchHelper.getWorkbench().close();
        });
    }

    public static void refreshNavigator() {
        IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
        if (iWorkbenchPage == null) {
            return;
        }
        CommonNavigator commonNavigator = (CommonNavigator)iWorkbenchPage.findView("gama.ui.application.view.GamaNavigator");
        if (commonNavigator != null) {
            WorkbenchHelper.runInUI("Refreshing navigator", 0, iProgressMonitor -> commonNavigator.getCommonViewer().refresh(true));
        }
    }

    public static int getMonitorUnderCursor() {
        return WorkbenchHelper.getMonitorContaining(WorkbenchHelper.getDisplay().getCursorLocation());
    }

    public static int getMonitorContaining(Point point) {
        int n = Integer.MAX_VALUE;
        Monitor[] monitorArray = WorkbenchHelper.getDisplay().getMonitors();
        int n2 = 0;
        int n3 = 0;
        while (n3 < monitorArray.length) {
            Monitor monitor = monitorArray[n3];
            Rectangle rectangle = monitor.getClientArea();
            if (rectangle.contains(point)) {
                return n3;
            }
            int n4 = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)rectangle), (Point)point);
            if (n4 < n) {
                n = n4;
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    public static int getMonitorContaining(Rectangle rectangle) {
        Monitor[] monitorArray = WorkbenchHelper.getDisplay().getMonitors();
        int n = 0;
        int n2 = 0;
        while (n2 < monitorArray.length) {
            Monitor monitor = monitorArray[n2];
            Rectangle rectangle2 = monitor.getClientArea();
            if (rectangle2.intersects(rectangle)) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    public static int getNumberOfMonitors() {
        return WorkbenchHelper.getMonitors().length;
    }

    public static Monitor[] getMonitors() {
        Display display = WorkbenchHelper.getDisplay();
        return display == null ? new Monitor[]{} : display.getMonitors();
    }

    public static MenuManager findMenuManager(String string, String string2) {
        IMenuService iMenuService = WorkbenchHelper.getService(IMenuService.class);
        MenuManager menuManager = new MenuManager();
        iMenuService.populateContributionManager((ContributionManager)menuManager, string);
        return WorkbenchHelper.findMenuManager(menuManager, string2);
    }

    private static MenuManager findMenuManager(MenuManager menuManager, String string) {
        if (string.equals(menuManager.getId())) {
            return menuManager;
        }
        IContributionItem[] iContributionItemArray = menuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuManager menuManager2;
            MenuManager menuManager3;
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem instanceof MenuManager && (menuManager3 = WorkbenchHelper.findMenuManager(menuManager2 = (MenuManager)iContributionItem, string)) != null) {
                return menuManager3;
            }
            ++n2;
        }
        return null;
    }

    public static IStructuredSelection getSelection() {
        WorkbenchWindow workbenchWindow = WorkbenchHelper.getWindow();
        if (workbenchWindow == null) {
            return null;
        }
        ISelectionService iSelectionService = workbenchWindow.getSelectionService();
        if (iSelectionService == null) {
            return null;
        }
        ISelection iSelection = iSelectionService.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return null;
    }
}

