/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.access;

import gama.gaml.compilation.GamlIdiomsProvider;
import gama.gaml.interfaces.IGamlDescription;
import gama.ui.shared.access.GamlAccessEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ui.internal.quickaccess.CamelUtil;

public final class GamlAccessMatcher {
    private final IGamlDescription element;
    private static final int[][] EMPTY_INDICES = new int[0][];
    private static final String WS_WILD_START = "^\\s*(\\*|\\?)*";
    private static final String WS_WILD_END = "(\\*|\\?)*\\s*$";
    private static final String ANY_WS = "\\s+";
    private static final String EMPTY_STR = "";
    private static final String PAR_START = "\\(";
    private static final String PAR_END = "\\)";
    private static final String ONE_CHAR = ".?";
    private String wsFilter;
    private Pattern wsPattern;
    private String wcFilter;
    private Pattern wcPattern;

    public GamlAccessMatcher(IGamlDescription iGamlDescription) {
        this.element = iGamlDescription;
    }

    private Pattern getWhitespacesPattern(String string) {
        if (this.wsPattern == null || !string.equals(this.wsFilter)) {
            this.wsFilter = string;
            String string2 = string.replaceFirst(WS_WILD_START, EMPTY_STR).replaceFirst(WS_WILD_END, EMPTY_STR).replaceAll(PAR_START, ONE_CHAR).replaceAll(PAR_END, ONE_CHAR);
            string2 = String.format(".*(%s).*", string2.replaceAll(ANY_WS, ").*("));
            this.wsPattern = GamlAccessMatcher.safeCompile(string2);
        }
        return this.wsPattern;
    }

    private Pattern getWildcardsPattern(String string) {
        string = string.replaceAll("\\*+", "*");
        if (this.wcPattern == null || !string.equals(this.wcFilter)) {
            this.wcFilter = string;
            String string2 = string.replaceFirst(WS_WILD_START, EMPTY_STR).replaceFirst(WS_WILD_END, EMPTY_STR).replaceAll(PAR_START, ONE_CHAR).replaceAll(PAR_END, ONE_CHAR);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (c == '*') {
                    stringBuilder.append(").").append(c).append("(");
                } else if (c == '?') {
                    int n2 = 1;
                    while (n + 1 < string2.length()) {
                        if (string2.charAt(n + 1) != '?') break;
                        ++n2;
                        ++n;
                    }
                    stringBuilder.append(").").append(n2 == 1 ? Character.valueOf('?') : String.format("{0,%d}", n2)).append("(");
                } else {
                    stringBuilder.append(c);
                }
                ++n;
            }
            string2 = String.format(".*(%s).*", stringBuilder.toString());
            string2 = string2.replace("()", EMPTY_STR);
            this.wcPattern = GamlAccessMatcher.safeCompile(string2);
        }
        return this.wcPattern;
    }

    private static Pattern safeCompile(String string) {
        try {
            return Pattern.compile(string, 2);
        }
        catch (Exception exception) {
            return Pattern.compile("\\a");
        }
    }

    public GamlAccessEntry match(String string, GamlIdiomsProvider gamlIdiomsProvider) {
        String string2 = this.element.getName();
        int n = string2.toLowerCase().indexOf(string);
        if (n != -1) {
            n = this.element.getTitle().toLowerCase().indexOf(string);
            if (n != -1) {
                int n2 = string2.toLowerCase().equals(string) ? 0 : (string2.toLowerCase().startsWith(string) ? 5 : 10);
                return new GamlAccessEntry(this.element, gamlIdiomsProvider, new int[][]{{n, n + string.length() - 1}}, EMPTY_INDICES, n2);
            }
            return new GamlAccessEntry(this.element, gamlIdiomsProvider, EMPTY_INDICES, EMPTY_INDICES, 15);
        }
        Pattern pattern = string.contains("*") || string.contains("?") ? this.getWildcardsPattern(string) : this.getWhitespacesPattern(string);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.matches()) {
            String string3 = this.element.getTitle();
            if (!string2.equals(string3) && !(matcher = pattern.matcher(this.element.getTitle())).matches()) {
                return new GamlAccessEntry(this.element, gamlIdiomsProvider, EMPTY_INDICES, EMPTY_INDICES, 10);
            }
            int n3 = matcher.groupCount();
            int[][] nArrayArray = new int[n3][];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4 + 1;
                nArrayArray[n4] = new int[]{matcher.start(n5), matcher.end(n5) - 1};
                ++n4;
            }
            n4 = 5;
            return new GamlAccessEntry(this.element, gamlIdiomsProvider, nArrayArray, EMPTY_INDICES, n4);
        }
        String string4 = gamlIdiomsProvider.getSearchCategory() + " " + this.element.getName();
        String string5 = gamlIdiomsProvider.getSearchCategory() + " " + this.element.getTitle();
        n = string4.toLowerCase().indexOf(string);
        if (n != -1) {
            n = string5.toLowerCase().indexOf(string);
            if (n != -1) {
                int n6 = n + string.length() - gamlIdiomsProvider.getSearchCategory().length() - 1;
                if (n6 > 0) {
                    int[][] nArrayArray = new int[1][];
                    int[] nArray = new int[2];
                    nArray[1] = n6 - 1;
                    nArrayArray[0] = nArray;
                    return new GamlAccessEntry(this.element, gamlIdiomsProvider, nArrayArray, new int[][]{{n, n + string.length() - 1}}, 10);
                }
                return new GamlAccessEntry(this.element, gamlIdiomsProvider, EMPTY_INDICES, new int[][]{{n, n + string.length() - 1}}, 10);
            }
            return new GamlAccessEntry(this.element, gamlIdiomsProvider, EMPTY_INDICES, EMPTY_INDICES, 15);
        }
        String string6 = CamelUtil.getCamelCase((String)this.element.getName());
        n = string6.indexOf(string);
        if (n != -1) {
            int[][] nArray = CamelUtil.getCamelCaseIndices((String)string2, (int)n, (int)string.length());
            return new GamlAccessEntry(this.element, gamlIdiomsProvider, nArray, EMPTY_INDICES, 10);
        }
        String string7 = CamelUtil.getCamelCase((String)string5);
        n = string7.indexOf(string);
        if (n != -1) {
            String string8 = CamelUtil.getCamelCase((String)gamlIdiomsProvider.getSearchCategory());
            int n7 = n + string.length() - string8.length();
            if (n7 > 0) {
                return new GamlAccessEntry(this.element, gamlIdiomsProvider, CamelUtil.getCamelCaseIndices((String)string2, (int)0, (int)n7), CamelUtil.getCamelCaseIndices((String)gamlIdiomsProvider.getSearchCategory(), (int)n, (int)(string.length() - n7)), 10);
            }
            return new GamlAccessEntry(this.element, gamlIdiomsProvider, EMPTY_INDICES, CamelUtil.getCamelCaseIndices((String)gamlIdiomsProvider.getSearchCategory(), (int)n, (int)string.length()), 10);
        }
        return null;
    }
}

