/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls;

import gama.core.common.interfaces.ItemList;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.ParameterExpandBar;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import java.awt.Color;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class ParameterExpandItem
extends Item {
    private ParameterExpandBar parent;
    Composite control;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int pausePosition = -1;
    int closePosition = -1;
    org.eclipse.swt.graphics.Color headerColor = ThemeHelper.isDark() ? IGamaColors.DARK_GRAY.color() : IGamaColors.VERY_LIGHT_GRAY.color();
    private static int imageHeight = 16;
    private static int imageWidth = 16;
    boolean isPaused = false;
    private Runnable onExpandBlock;
    private static final int TEXT_INSET = 4;
    private static final int SEPARATION = 3;
    static final int BORDER = 4;
    static final int CHEVRON_SIZE = 20;

    public ParameterExpandItem(ParameterExpandBar parameterExpandBar, Object object, int n, GamaColors.GamaUIColor gamaUIColor) {
        this(parameterExpandBar, object, n, parameterExpandBar.getItemCount(), gamaUIColor);
    }

    public ParameterExpandItem(ParameterExpandBar parameterExpandBar, Object object, int n, int n2, GamaColors.GamaUIColor gamaUIColor) {
        super((Widget)parameterExpandBar, n);
        if (gamaUIColor != null) {
            this.headerColor = gamaUIColor.color();
        }
        this.parent = parameterExpandBar;
        this.setData(object);
        parameterExpandBar.createItem(this, n, n2);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.parent != null) {
            this.parent.destroyItem(this);
        }
        super.dispose();
        if (this.control != null) {
            this.control.dispose();
            this.control = null;
        }
        this.parent = null;
    }

    void drawItem(GC gC, boolean bl) {
        Object object;
        if (this.parent == null) {
            return;
        }
        int n = this.parent.bandHeight;
        this.control.setBackground(this.parent.getBackground());
        gC.setBackground(this.headerColor);
        gC.fillRoundRectangle(this.x + 1, this.y, this.width - 2, n, 6, 6);
        if (bl) {
            gC.setForeground(IGamaColors.GRAY_LABEL.color());
            gC.drawRoundRectangle(this.x + 1, this.y + 1, this.width - 2, n - 2, 6, 6);
        }
        int n2 = this.x;
        int n3 = this.y + (n - imageHeight) / 2;
        if (this.getImage() != null) {
            gC.drawImage(this.getImage(), n2 += 4, n3);
            n2 += imageWidth;
        }
        int n4 = this.x + this.width;
        if (this.parent.hasClosableToggle) {
            this.closePosition = n4 -= 8 + imageWidth;
            gC.drawImage(GamaIcon.named("overlays/small.close").image(), n4, n3);
        }
        if (this.parent.hasPausableToggle) {
            object = this.isPaused ? GamaIcon.named("overlays/small.resume").image() : GamaIcon.named("overlays/small.pause").image();
            this.pausePosition = n4 -= 8 + imageWidth;
            gC.drawImage(object, n4, n3);
        }
        if (this.getText().length() > 0) {
            String string = null;
            int n5 = this.getText().indexOf(ItemList.SEPARATION_CODE.charValue());
            if (n5 != -1) {
                object = this.getText().substring(0, n5) + ": ";
                string = this.getText().substring(n5 + 1);
            } else {
                object = this.getText();
            }
            Point point = gC.stringExtent((String)object);
            gC.setForeground(GamaColors.getTextColorForBackground(this.headerColor).color());
            gC.drawString((String)object, n2 += 8, this.y + (n - point.y) / 2, true);
            if (string != null) {
                int n6 = string.indexOf(ItemList.ERROR_CODE.charValue());
                int n7 = string.indexOf(ItemList.INFO_CODE.charValue());
                int n8 = string.indexOf(ItemList.WARNING_CODE.charValue());
                if (n6 != -1) {
                    string = string.substring(n6 + 1);
                    gC.setForeground(IGamaColors.ERROR.color());
                } else if (n7 != -1) {
                    string = string.substring(n7 + 1);
                    gC.setForeground(IGamaColors.OK.color());
                } else if (n8 != -1) {
                    string = string.substring(n8 + 1);
                    gC.setForeground(IGamaColors.WARNING.color());
                } else {
                    gC.setForeground(GamaColors.getTextColorForBackground(this.headerColor).color());
                }
                point = gC.stringExtent(string);
                gC.drawString(string, n2 += point.x + 6, this.y + (n - point.y) / 2, true);
            }
        }
    }

    public int getHeaderHeight() {
        if (this.parent == null) {
            return imageHeight;
        }
        return Math.max(this.parent.bandHeight, imageHeight);
    }

    int getPreferredWidth(GC gC) {
        int n = 28;
        if (this.getImage() != null) {
            n += 4 + imageWidth;
        }
        if (this.getText().length() > 0) {
            n += gC.stringExtent((String)this.getText()).x;
        }
        if (this.control != null) {
            n += this.control.computeSize((int)-1, (int)-1).x;
        }
        return n;
    }

    void redraw() {
        if (this.parent == null) {
            return;
        }
        int n = this.parent.bandHeight;
        if (imageHeight > n) {
            this.parent.redraw(this.x + 4, this.y + n - imageHeight, imageWidth, imageHeight, false);
        }
        this.parent.redraw(this.x, this.y, this.width, n + this.height, false);
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.redraw();
        if (this.parent == null) {
            return;
        }
        int n5 = this.parent.bandHeight;
        int n6 = n2;
        if (bl) {
            if (imageHeight > n5) {
                n6 += imageHeight - n5;
            }
            this.x = n;
            this.y = n6;
            this.redraw();
        }
        if (bl2) {
            this.width = n3;
            this.height = n4 + this.parent.bandHeight;
            this.redraw();
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (bl) {
                this.control.setLocation(n + 4, n2 + n5);
            }
            if (bl2) {
                int n7 = n3 - 8;
                int n8 = n4 + 4;
                if (this.control.getVerticalBar() != null) {
                    n7 -= this.control.getVerticalBar().getSize().x;
                }
                if (this.control.getHorizontalBar() != null && this.control.getHorizontalBar().isVisible()) {
                    n8 -= 2 * this.control.getHorizontalBar().getSize().y;
                }
                this.control.setSize(this.control.computeSize(n7, n8));
                this.control.layout(true);
            }
        }
    }

    public void setControl(Composite composite) {
        if (composite != null) {
            if (composite.isDisposed()) {
                SWT.error((int)5);
            }
            if (composite.getParent() != this.parent) {
                SWT.error((int)32);
            }
        }
        this.control = composite;
        if (composite != null) {
            composite.setVisible(this.expanded);
            int n = this.parent.bandHeight;
            composite.setBounds(this.x + 4, this.y + n, Math.max(0, this.width - 8), Math.max(0, this.height + 4));
        }
    }

    public void setExpanded(boolean bl) {
        if (this.parent == null) {
            return;
        }
        this.expanded = bl;
        if (this.onExpandBlock != null) {
            if (bl) {
                this.onExpandBlock.run();
                this.setHeight(this.control.computeSize((int)-1, (int)-1).y);
            } else {
                Control[] controlArray = this.control.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.dispose();
                    ++n2;
                }
                if (this.control instanceof ScrolledComposite) {
                    ((ScrolledComposite)this.control).setContent(null);
                }
            }
        }
        this.parent.showItem(this);
    }

    public void setImage(Image image) {
        super.setImage(image);
        int n = imageHeight;
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            imageHeight = rectangle.height;
            imageWidth = rectangle.width;
        } else {
            imageWidth = 0;
            imageHeight = 0;
        }
        if (n != imageHeight && this.parent != null) {
            this.parent.layoutItems(this.parent.indexOf(this), true);
        } else {
            this.redraw();
        }
    }

    public void setHeight(int n) {
        if (n < 0) {
            return;
        }
        this.setBounds(0, 0, this.width, n, false, true);
        if (this.expanded && this.parent != null) {
            this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.redraw();
    }

    private boolean clickIn(int n, int n2, int n3) {
        int n4 = n3 + imageWidth;
        int n5 = this.parent.bandHeight;
        int n6 = this.y + (n5 - imageHeight) / 2;
        int n7 = n6 + imageHeight;
        return n >= n3 && n <= n4 && n2 >= n6 && n2 <= n7;
    }

    public boolean closeRequested(int n, int n2) {
        if (this.closePosition == -1) {
            return false;
        }
        return this.clickIn(n, n2, this.x + this.closePosition);
    }

    public boolean pauseRequested(int n, int n2) {
        if (this.pausePosition == -1) {
            return false;
        }
        return this.clickIn(n, n2, this.x + this.pausePosition);
    }

    public void setColor(Color color) {
        if (color != null) {
            this.headerColor = GamaColors.get(color).color();
        }
    }

    public void onExpand(Runnable runnable) {
        this.onExpandBlock = runnable;
    }

    public Control getControl() {
        return this.control;
    }
}

