/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views;

import gama.core.common.interfaces.ItemList;
import gama.core.runtime.GAMA;
import gama.core.util.GamaColor;
import gama.ui.shared.controls.ParameterExpandBar;
import gama.ui.shared.controls.ParameterExpandItem;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.GamaViewPart;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class ExpandableItemsView<T>
extends GamaViewPart
implements ItemList<T>,
IToolbarDecoratedView.Expandable {
    private ParameterExpandBar viewer;
    protected boolean isOpen = true;

    public ParameterExpandBar getViewer() {
        return this.viewer;
    }

    public void createViewer(Composite composite) {
        if (composite == null) {
            return;
        }
        if (this.viewer == null) {
            this.viewer = new ParameterExpandBar(composite, 512, this.areItemsClosable(), this.areItemsPausable(), this);
            Layout layout = composite.getLayout();
            if (layout instanceof GridLayout) {
                GridData gridData = new GridData(4, 4, true, true);
                this.viewer.setLayoutData(gridData);
            }
            this.viewer.setSpacing(8);
        }
    }

    protected boolean areItemsClosable() {
        return false;
    }

    protected boolean areItemsPausable() {
        return false;
    }

    protected ParameterExpandItem createItem(Composite composite, T t, Composite composite2, boolean bl, GamaColors.GamaUIColor gamaUIColor) {
        return this.createItem(composite, this.getItemDisplayName(t, null), t, composite2, bl, gamaUIColor);
    }

    protected ParameterExpandItem createItem(Composite composite, String string, T t, Composite composite2, ParameterExpandBar parameterExpandBar, boolean bl, GamaColors.GamaUIColor gamaUIColor) {
        ParameterExpandItem parameterExpandItem = this.buildConcreteItem(parameterExpandBar, t, gamaUIColor);
        if (string != null) {
            parameterExpandItem.setText(string);
        }
        composite2.pack(true);
        composite2.layout();
        parameterExpandItem.setControl(composite2);
        parameterExpandItem.setHeight(composite2.computeSize((int)-1, (int)-1).y);
        parameterExpandItem.setExpanded(bl);
        composite.layout(true, true);
        return parameterExpandItem;
    }

    protected ParameterExpandItem buildConcreteItem(ParameterExpandBar parameterExpandBar, T t, GamaColors.GamaUIColor gamaUIColor) {
        return new ParameterExpandItem(parameterExpandBar, t, 0, gamaUIColor);
    }

    protected ParameterExpandItem createItem(Composite composite, String string, T t, Composite composite2, boolean bl, GamaColors.GamaUIColor gamaUIColor) {
        this.createViewer(composite);
        if (this.viewer == null) {
            return null;
        }
        return this.createItem(composite, string, t, composite2, this.viewer, bl, gamaUIColor);
    }

    protected ParameterExpandItem createItem(Composite composite, T t, boolean bl, GamaColors.GamaUIColor gamaUIColor) {
        this.createViewer(composite);
        if (this.viewer == null) {
            return null;
        }
        Composite composite2 = this.createItemContentsFor(t);
        if (composite2 == null) {
            return null;
        }
        return this.createItem(composite, t, composite2, bl, gamaUIColor);
    }

    protected abstract Composite createItemContentsFor(T var1);

    protected void disposeViewer() {
        try {
            if (this.viewer != null) {
                WorkbenchHelper.run(() -> this.viewer.dispose());
                this.viewer = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.reset();
        this.isOpen = false;
        super.widgetDisposed(disposeEvent);
    }

    @Override
    public void reset() {
        WorkbenchHelper.run(() -> {
            if (this.getParentComposite() == null) {
                return;
            }
            this.getParentComposite().setLayoutDeferred(true);
            this.disposeViewer();
            this.getParentComposite().setLayoutDeferred(false);
        });
    }

    @Override
    public void setFocus() {
        if (this.viewer != null && this.viewer.isVisible()) {
            this.viewer.setFocus();
        }
    }

    public void removeItem(T t) {
    }

    public void pauseItem(T t) {
    }

    public void resumeItem(T t) {
    }

    public void focusItem(T t) {
    }

    public String getItemDisplayName(T t, String string) {
        return null;
    }

    public GamaColor getItemDisplayColor(T t) {
        return null;
    }

    public void displayItems() {
        List<T> list = this.getItems();
        for (T t : list) {
            this.addItem(t);
        }
    }

    protected GamaViewPart.ViewUpdateUIJob createUpdateJob() {
        return new GamaViewPart.ViewUpdateUIJob(this){

            @Override
            protected GamaViewPart.UpdatePriority jobPriority() {
                return GamaViewPart.UpdatePriority.LOW;
            }

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (!ExpandableItemsView.this.isOpen) {
                    return Status.CANCEL_STATUS;
                }
                if (ExpandableItemsView.this.getViewer() != null && !ExpandableItemsView.this.getViewer().isDisposed()) {
                    ExpandableItemsView.this.getViewer().updateItemNames();
                    ExpandableItemsView.this.getViewer().updateItemColors();
                    ExpandableItemsView.this.updateItemValues(GAMA.isSynchronized());
                }
                return Status.OK_STATUS;
            }
        };
    }

    public abstract List<T> getItems();

    public abstract void updateItemValues(boolean var1);

    @Override
    public void collapseAll() {
        ParameterExpandItem[] parameterExpandItemArray = this.getViewer().getItems();
        int n = parameterExpandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterExpandItem parameterExpandItem = parameterExpandItemArray[n2];
            parameterExpandItem.setExpanded(false);
            ++n2;
        }
    }

    @Override
    public void expandAll() {
        ParameterExpandItem[] parameterExpandItemArray = this.getViewer().getItems();
        int n = parameterExpandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterExpandItem parameterExpandItem = parameterExpandItemArray[n2];
            parameterExpandItem.setExpanded(true);
            ++n2;
        }
    }
}

