/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.views;

import gama.core.common.interfaces.IGamaView;
import gama.core.common.interfaces.ITopLevelAgentChangeListener;
import gama.core.common.util.StringUtils;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.root.PlatformAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExecutionContext;
import gama.core.runtime.IScope;
import gama.dev.DEBUG;
import gama.dev.THREADS;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.GamlIdiomsProvider;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IVarDescriptionProvider;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Strings;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.GamaViewPart;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsoleViewer;

public class InteractiveConsoleView
extends GamaViewPart
implements IToolbarDecoratedView.Sizable,
IToolbarDecoratedView.LogExportable,
IExecutionContext,
IVarDescriptionProvider,
IGamaView.Interactive {
    private IOConsole msgConsole;
    IOConsoleViewer viewer;
    private OutputStreamWriter resultWriter;
    private OutputStreamWriter errorWriter;
    BufferedReader reader;
    private final Map<String, Object> temps = new LinkedHashMap<String, Object>();
    private final List<String> history = new ArrayList<String>();
    private int indexInHistory = 0;
    private Composite controlToDisplayInFullScreen;
    private Composite parentOfControlToDisplayFullScreen;
    public static final String PROMPT = "gaml> ";

    static {
        DEBUG.OFF();
    }

    public InteractiveConsoleView() {
        DEBUG.OUT((Object)"InteractiveConsoleView created");
        GAMA.registerTopLevelAgentChangeListener((ITopLevelAgentChangeListener)this);
    }

    @Override
    public void createPartControl(Composite composite) {
        this.setParentOfControlToDisplayFullScreen(composite);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.getParentOfControlToDisplayFullScreen().setLayout((Layout)gridLayout);
        this.controlToDisplayInFullScreen = new Composite(composite, 2048);
        this.controlToDisplayInFullScreen.setLayoutData((Object)new GridData(4, 4, true, true));
        super.createPartControl(this.controlToDisplayInFullScreen);
    }

    @Override
    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.setTitleImage(GamaIcon.named("views/tabs/view.interactive").image());
    }

    public IScope getScope() {
        return GAMA.getCurrentTopLevelAgent().getScope();
    }

    @Override
    public void ownCreatePartControl(Composite composite) {
        this.msgConsole = new IOConsole("GAMA Console", null);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)this.msgConsole.getInputStream()));
        IOConsoleOutputStream iOConsoleOutputStream = this.msgConsole.newOutputStream();
        iOConsoleOutputStream.setColor(ThemeHelper.isDark() ? IGamaColors.NEUTRAL.lighter() : IGamaColors.NEUTRAL.color());
        this.resultWriter = new OutputStreamWriter((OutputStream)iOConsoleOutputStream);
        iOConsoleOutputStream = this.msgConsole.newOutputStream();
        iOConsoleOutputStream.setColor(IGamaColors.ERROR.color());
        this.errorWriter = new OutputStreamWriter((OutputStream)iOConsoleOutputStream);
        this.viewer = new IOConsoleViewer(composite, (TextConsole)this.msgConsole);
        this.viewer.setWordWrap(true);
        this.msgConsole.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent documentEvent) {
                if (Strings.LN.equals(documentEvent.getText())) {
                    String string = "";
                    try {
                        string = InteractiveConsoleView.this.reader.readLine();
                    }
                    catch (IOException iOException) {
                        InteractiveConsoleView.this.append("Error in reading command", true, true);
                        return;
                    }
                    InteractiveConsoleView.this.processInput(string);
                }
            }

            public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            }
        });
        this.viewer.getTextWidget().addVerifyKeyListener(verifyEvent -> {
            if (verifyEvent.keyCode == 0x1000001 || verifyEvent.keyCode == 0x1000002) {
                StyledText styledText = (StyledText)verifyEvent.widget;
                Point point = styledText.getSelection();
                int n = styledText.getLineAtOffset(point.y);
                if (n == styledText.getLineCount() - 1) {
                    verifyEvent.doit = false;
                    this.insertHistory(verifyEvent.keyCode == 0x1000001);
                }
            }
        });
        composite.layout(true, true);
        this.showPrompt();
    }

    public Composite getControlToDisplayInFullScreen() {
        return this.controlToDisplayInFullScreen;
    }

    private void showPrompt() {
        new Thread(() -> {
            this.append(Strings.LN + PROMPT, false, false);
            THREADS.WAIT((long)200L, (String[])new String[0]);
            WorkbenchHelper.run(() -> {
                if (this.viewer != null && this.viewer.getTextWidget() != null && !this.viewer.getTextWidget().isDisposed()) {
                    this.viewer.getTextWidget().setCaretOffset(this.viewer.getTextWidget().getCharCount());
                }
            });
        }).start();
    }

    private void insertHistory(boolean bl) {
        if (this.history.size() == 0) {
            ViewsHelper.requestUserAttention(this, "No history");
            return;
        }
        if (this.indexInHistory <= 0) {
            if (bl) {
                ViewsHelper.requestUserAttention(this, "No more history");
            }
            this.indexInHistory = 0;
        } else if (this.indexInHistory >= this.history.size() - 1) {
            if (!bl) {
                ViewsHelper.requestUserAttention(this, "No more history");
            }
            this.indexInHistory = this.history.size() - 1;
        }
        try {
            StyledText styledText = this.viewer.getTextWidget();
            int n = styledText.getLineCount() - 1;
            int n2 = styledText.getCharCount();
            int n3 = styledText.getOffsetAtLine(n) + PROMPT.length();
            this.viewer.getDocument().replace(n3, n2 - n3, this.history.get(this.indexInHistory));
            styledText.setCaretOffset(styledText.getCharCount());
            this.indexInHistory = bl ? --this.indexInHistory : ++this.indexInHistory;
        }
        catch (BadLocationException badLocationException) {}
    }

    public void append(String string, boolean bl, boolean bl2) {
        WorkbenchHelper.asyncRun(() -> {
            OutputStreamWriter outputStreamWriter = bl ? this.errorWriter : this.resultWriter;
            try {
                outputStreamWriter.append(string);
                outputStreamWriter.flush();
                if (bl2) {
                    this.showPrompt();
                }
            }
            catch (IOException iOException) {}
        });
    }

    @Override
    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.reset();
        super.widgetDisposed(disposeEvent);
    }

    @Override
    public void dispose() {
        GAMA.removeTopLevelAgentChangeListener((ITopLevelAgentChangeListener)this);
        DEBUG.OUT((Object)"Console removed from GAMA listeners");
        super.dispose();
    }

    @Override
    public void close(IScope iScope) {
        this.reset();
        super.close(iScope);
    }

    @Override
    public void reset() {
        if (this.msgConsole != null) {
            this.msgConsole.clearConsole();
        }
        this.topLevelAgentChanged(null);
        this.showPrompt();
    }

    @Override
    public Control getSizableFontControl() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getTextWidget();
    }

    @Override
    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        super.createToolItems(gamaToolbar2);
        GamaToolbarSimple gamaToolbarSimple = this.toolbar.getToolbar(131072);
        gamaToolbarSimple.button("editor/local.menu", "More...", "More options", selectionEvent -> {
            GamaMenu gamaMenu = new GamaMenu(){

                @Override
                protected void fillMenu() {
                    GamaCommand.build("viewers/erase.contents", "Clear", "Clear the console", selectionEvent -> {
                        InteractiveConsoleView.this.msgConsole.clearConsole();
                        InteractiveConsoleView.this.showPrompt();
                    }).toItem(this.mainMenu);
                    GamaMenu.separate(this.mainMenu);
                    GamaCommand.build("generic/menu.saveas", "Export to log file", "Export to log file", selectionEvent -> InteractiveConsoleView.this.saveAsLog()).toItem(this.mainMenu);
                }
            };
            gamaMenu.open((Control)gamaToolbarSimple, selectionEvent, gamaToolbarSimple.getSize().y, 0);
        });
        this.topLevelAgentChanged(GAMA.getCurrentTopLevelAgent());
    }

    protected GamaViewPart.ViewUpdateUIJob createUpdateJob() {
        return null;
    }

    @Override
    protected boolean shouldBeClosedWhenNoExperiments() {
        return false;
    }

    @Override
    protected boolean needsOutput() {
        return false;
    }

    public void topLevelAgentChanged(ITopLevelAgent iTopLevelAgent) {
        if (iTopLevelAgent == null) {
            WorkbenchHelper.asyncRun(() -> {
                if (this.toolbar != null && !this.toolbar.isDisposed()) {
                    this.toolbar.wipe(16384, true);
                    this.toolbar.update();
                    this.toolbar.requestLayout();
                }
            });
        } else {
            DEBUG.OUT((Object)("Changing top level agent to " + iTopLevelAgent.getName()));
            if (!(iTopLevelAgent instanceof PlatformAgent)) {
                iTopLevelAgent.getSpecies().getDescription().attachAlternateVarDescriptionProvider((IVarDescriptionProvider)this);
            }
            WorkbenchHelper.asyncRun(() -> {
                if (this.toolbar != null) {
                    this.toolbar.status(GamaIcon.ofColor(iTopLevelAgent.getColor()).getCode(), "Interacting with " + iTopLevelAgent.getFamilyName() + " " + iTopLevelAgent.getName());
                    this.toolbar.update();
                    this.toolbar.requestLayout();
                }
            });
        }
    }

    protected void processInput(String string) {
        ITopLevelAgent iTopLevelAgent = GAMA.getCurrentTopLevelAgent();
        if (iTopLevelAgent == null || iTopLevelAgent.dead()) {
            this.topLevelAgentChanged(null);
        } else {
            boolean bl;
            Object object;
            block12: {
                String string2 = string.trim();
                this.history.add(string2);
                this.indexInHistory = this.history.size() - 1;
                object = null;
                bl = false;
                if (string2.startsWith("?")) {
                    object = GamlIdiomsProvider.getDocumentationOn((String)string2.substring(1));
                } else {
                    IScope iScope = iTopLevelAgent.getScope().copy("In interactive console");
                    try {
                        try {
                            IExpression iExpression = GAML.compileExpression((String)string, (IAgent)iTopLevelAgent, (IExecutionContext)this, (boolean)false);
                            if (iExpression != null) {
                                object = StringUtils.toGaml((Object)iScope.evaluate(iExpression, (IAgent)iTopLevelAgent).getValue(), (boolean)true);
                            }
                        }
                        catch (Exception exception) {
                            bl = true;
                            object = "> Error: " + exception.getMessage();
                            iTopLevelAgent.getSpecies().removeTemporaryAction();
                            GAMA.releaseScope((IScope)iScope);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        iTopLevelAgent.getSpecies().removeTemporaryAction();
                        GAMA.releaseScope((IScope)iScope);
                        throw throwable;
                    }
                    iTopLevelAgent.getSpecies().removeTemporaryAction();
                    GAMA.releaseScope((IScope)iScope);
                }
            }
            if (object == null) {
                object = "nil";
            }
            this.append((String)object, bl, true);
            if (!bl && GAMA.getExperiment() != null) {
                GAMA.getExperiment().refreshAllOutputs();
            }
        }
    }

    public Composite getParentOfControlToDisplayFullScreen() {
        return this.parentOfControlToDisplayFullScreen;
    }

    public void setParentOfControlToDisplayFullScreen(Composite composite) {
        this.parentOfControlToDisplayFullScreen = composite;
    }

    public void setTempVar(String string, Object object) {
        this.temps.put(string, object);
    }

    public Object getTempVar(String string) {
        return this.temps.get(string);
    }

    public Map<? extends String, ? extends Object> getLocalVars() {
        return this.temps;
    }

    public void clearLocalVars() {
        this.temps.clear();
    }

    public void putLocalVar(String string, Object object) {
        this.temps.put(string, object);
    }

    public Object getLocalVar(String string) {
        return this.temps.get(string);
    }

    public boolean hasLocalVar(String string) {
        return this.temps.containsKey(string);
    }

    public void removeLocalVar(String string) {
        this.temps.remove(string);
    }

    public IExecutionContext getOuterContext() {
        return this;
    }

    public IExecutionContext createCopy(ISymbol iSymbol) {
        return this;
    }

    public IExecutionContext createChildContext(ISymbol iSymbol) {
        return this;
    }

    public IExpression getVarExpr(String string, boolean bl) {
        Object object = this.temps.get(string);
        if (object != null) {
            IType iType = GamaType.of((Object)object);
            return GAML.getExpressionFactory().createVar(string, iType, false, 2, null);
        }
        return null;
    }

    public boolean hasAttribute(String string) {
        return this.temps.containsKey(string);
    }

    @Override
    public String getContents() {
        return this.viewer.getDocument().get();
    }

    public ISymbol getCurrentSymbol() {
        return null;
    }

    public void setCurrentSymbol(ISymbol iSymbol) {
    }
}

