/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.compilation.GAML;
import gama.ui.shared.parameters.ListEditor;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ListEditorDialog
extends Dialog {
    final ArrayList<String> data = new ArrayList();
    Button newElementButton = null;
    Button upButton = null;
    Button downButton = null;
    Button removeButton = null;
    List list = null;
    String listname = null;

    protected ListEditorDialog(Shell shell, IList iList, String string) {
        super(shell);
        this.listname = string;
        for (Object e : iList) {
            this.data.add(StringUtils.toGaml(e, (boolean)false));
        }
    }

    protected Control createDialogArea(Composite composite) {
        String string2;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(3, false);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(2, 2, false, false, 3, 1));
        label.setText("Modify the list '" + this.listname + "'");
        final Text text = new Text(composite2, 2048);
        text.addModifyListener(modifyEvent -> {
            if (text.getText() == null || text.getText().trim().length() == 0) {
                this.newElementButton.setEnabled(false);
            }
            if (text.getText().trim().length() > 0) {
                this.newElementButton.setEnabled(true);
            }
        });
        GridData gridData = new GridData(4, 2, true, false);
        gridData.widthHint = 40;
        text.setLayoutData((Object)gridData);
        this.newElementButton = new Button(composite2, 8);
        this.newElementButton.setText("Add");
        this.newElementButton.setToolTipText("Add new element");
        this.newElementButton.setEnabled(false);
        this.newElementButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                ListEditorDialog.this.list.add(text.getText());
                ListEditorDialog.this.data.add(text.getText());
                text.setText("");
                ListEditorDialog.this.newElementButton.setEnabled(false);
            }
        });
        this.list = new List(composite2, 2820);
        for (String string2 : this.data) {
            this.list.add(string2);
        }
        string2 = new GridData(4, 4, true, true, 2, 5);
        ((GridData)string2).widthHint = 60;
        ((GridData)string2).heightHint = 100;
        this.list.setLayoutData((Object)string2);
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (ListEditorDialog.this.list.getSelectionIndex() != -1) {
                    if (ListEditorDialog.this.list.getSelectionIndex() > 0) {
                        ListEditorDialog.this.upButton.setEnabled(true);
                    } else {
                        ListEditorDialog.this.upButton.setEnabled(false);
                    }
                    if (ListEditorDialog.this.list.getSelectionIndex() < ListEditorDialog.this.data.size() - 1) {
                        ListEditorDialog.this.downButton.setEnabled(true);
                    } else {
                        ListEditorDialog.this.downButton.setEnabled(false);
                    }
                    ListEditorDialog.this.removeButton.setEnabled(true);
                } else {
                    ListEditorDialog.this.upButton.setEnabled(false);
                    ListEditorDialog.this.downButton.setEnabled(false);
                    ListEditorDialog.this.removeButton.setEnabled(false);
                }
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData2 = new GridData(4, 0x1000000, true, true, 1, 5);
        gridData2.heightHint = 100;
        composite3.setLayoutData((Object)gridData2);
        this.upButton = new Button(composite3, 8);
        this.upButton.setText("Up");
        this.upButton.setEnabled(false);
        GridData gridData3 = new GridData(4, 0x1000000, true, false);
        gridData3.horizontalSpan = 1;
        this.upButton.setLayoutData((Object)gridData3);
        this.upButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                int n = ListEditorDialog.this.list.getSelectionIndex();
                String string = ListEditorDialog.this.list.getItem(n);
                ListEditorDialog.this.list.remove(n);
                ListEditorDialog.this.data.remove(n);
                if (n > 0) {
                    --n;
                }
                ListEditorDialog.this.list.add(string, n);
                ListEditorDialog.this.data.add(n, string);
                ListEditorDialog.this.list.setSelection(n);
                if (n == 0) {
                    ListEditorDialog.this.upButton.setEnabled(false);
                }
                if (n < ListEditorDialog.this.data.size() - 1) {
                    ListEditorDialog.this.downButton.setEnabled(true);
                }
            }
        });
        this.downButton = new Button(composite3, 8);
        this.downButton.setText("Down");
        this.downButton.setEnabled(false);
        GridData gridData4 = new GridData(4, 0x1000000, true, false);
        gridData4.horizontalSpan = 1;
        this.downButton.setLayoutData((Object)gridData4);
        this.downButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                int n = ListEditorDialog.this.list.getSelectionIndex();
                String string = ListEditorDialog.this.list.getItem(n);
                ListEditorDialog.this.list.remove(n);
                ListEditorDialog.this.data.remove(n);
                if (n < ListEditorDialog.this.data.size()) {
                    ++n;
                }
                ListEditorDialog.this.list.add(string, n);
                ListEditorDialog.this.data.add(n, string);
                ListEditorDialog.this.list.setSelection(n);
                if (n >= ListEditorDialog.this.data.size() - 1) {
                    ListEditorDialog.this.downButton.setEnabled(false);
                }
                if (n > 0) {
                    ListEditorDialog.this.upButton.setEnabled(true);
                }
            }
        });
        this.removeButton = new Button(composite3, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        GridData gridData5 = new GridData(4, 0x1000000, true, false);
        gridData5.horizontalSpan = 1;
        this.removeButton.setLayoutData((Object)gridData5);
        this.removeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                int n = ListEditorDialog.this.list.getSelectionIndex();
                ListEditorDialog.this.list.remove(n);
                ListEditorDialog.this.data.remove(n);
                if (ListEditorDialog.this.data.size() > 0) {
                    if (n >= ListEditorDialog.this.data.size()) {
                        --n;
                    }
                    if (n >= 0 && n < ListEditorDialog.this.data.size()) {
                        ListEditorDialog.this.list.setSelection(n);
                        ListEditorDialog.this.removeButton.setEnabled(true);
                    }
                    if (n >= ListEditorDialog.this.data.size() - 1) {
                        ListEditorDialog.this.downButton.setEnabled(false);
                    } else {
                        ListEditorDialog.this.downButton.setEnabled(true);
                    }
                    if (n > 0) {
                        ListEditorDialog.this.upButton.setEnabled(true);
                    } else {
                        ListEditorDialog.this.upButton.setEnabled(false);
                    }
                } else {
                    ListEditorDialog.this.upButton.setEnabled(false);
                    ListEditorDialog.this.downButton.setEnabled(false);
                    ListEditorDialog.this.removeButton.setEnabled(false);
                }
            }
        });
        return composite2;
    }

    public IList getList(ListEditor listEditor) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder("[");
        for (String string : this.data) {
            if (bl) {
                bl = false;
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append("," + string);
        }
        stringBuilder.append("]");
        try {
            return (IList)GAML.evaluateExpression((String)stringBuilder.toString(), (IAgent)listEditor.getAgent());
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            return GamaListFactory.create();
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

