/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.access;

import gama.gaml.compilation.GamlIdiomsProvider;
import gama.gaml.interfaces.IGamlDescription;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class GamlAccessEntry {
    boolean firstInCategory;
    boolean lastInCategory;
    IGamlDescription element;
    GamlIdiomsProvider<?> provider;
    int[][] elementMatchRegions;
    int[][] providerMatchRegions;
    private final int matchQuality;
    static TextStyle boldStyle;
    static TextStyle categoryStyle;
    public static final int MATCH_PERFECT = 0;
    public static final int MATCH_EXCELLENT = 5;
    public static final int MATCH_GOOD = 10;
    public static final int MATCH_PARTIAL = 15;

    static TextStyle getBoldStyle() {
        if (boldStyle == null) {
            boldStyle = new TextStyle(WorkbenchHelper.getDisplay().getSystemFont(), null, ThemeHelper.isDark() ? IGamaColors.BLUE.color() : IGamaColors.TOOLTIP.color());
        }
        return boldStyle;
    }

    static TextStyle getCategoryStyle() {
        if (categoryStyle == null) {
            categoryStyle = new TextStyle(WorkbenchHelper.getDisplay().getSystemFont(), null, ThemeHelper.isDark() ? IGamaColors.BLUE.color() : IGamaColors.TOOLTIP.color());
        }
        return categoryStyle;
    }

    GamlAccessEntry(IGamlDescription iGamlDescription, GamlIdiomsProvider<?> gamlIdiomsProvider, int[][] nArray, int[][] nArray2, int n) {
        this.element = iGamlDescription;
        this.provider = gamlIdiomsProvider;
        this.elementMatchRegions = nArray;
        this.providerMatchRegions = nArray2;
        this.matchQuality = n;
    }

    public String getSearchCategory() {
        return this.provider.getSearchCategory();
    }

    public void measure(Event event, TextLayout textLayout) {
        Object object;
        event.width = 0;
        switch (event.index) {
            case 0: {
                if (this.firstInCategory || this.providerMatchRegions.length > 0) {
                    textLayout.setText(this.provider.name);
                    int[][] nArray = this.providerMatchRegions;
                    int n = this.providerMatchRegions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = nArray[n2];
                        textLayout.setStyle(GamlAccessEntry.getCategoryStyle(), (int)object[0], (int)object[1]);
                        ++n2;
                    }
                    break;
                }
                textLayout.setText("");
                break;
            }
            case 1: {
                textLayout.setText(this.element.getTitle());
                int[][] nArray = this.elementMatchRegions;
                int n = this.elementMatchRegions.length;
                int n3 = 0;
                while (n3 < n) {
                    object = nArray[n3];
                    textLayout.setStyle(GamlAccessEntry.getBoldStyle(), (int)object[0], (int)object[1]);
                    ++n3;
                }
                break;
            }
        }
        object = textLayout.getBounds();
        event.width += object.width + 4;
        event.height = Math.max(event.height, object.height + 2);
    }

    public void paint(Event event, TextLayout textLayout) {
        Object object;
        Table table = ((TableItem)event.item).getParent();
        switch (event.index) {
            case 0: {
                textLayout.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
                if (!this.firstInCategory && this.providerMatchRegions.length <= 0) break;
                textLayout.setText(this.provider.name);
                int[][] nArray = this.providerMatchRegions;
                int n = this.providerMatchRegions.length;
                int n2 = 0;
                while (n2 < n) {
                    object = nArray[n2];
                    textLayout.setStyle(GamlAccessEntry.getCategoryStyle(), (int)object[0], (int)object[1]);
                    ++n2;
                }
                if (this.providerMatchRegions.length > 0 && !this.firstInCategory) {
                    event.gc.setForeground(IGamaColors.GRAY_LABEL.color());
                }
                object = ((TableItem)event.item).getTextBounds(event.index);
                Rectangle rectangle = textLayout.getBounds();
                textLayout.draw(event.gc, ((Rectangle)object).x + 1, ((Rectangle)object).y + (((Rectangle)object).height - rectangle.height) / 2);
                break;
            }
            case 1: {
                Object object2;
                textLayout.setFont(table.getFont());
                object = this.element.getTitle();
                textLayout.setText((String)object);
                int[][] nArray = this.elementMatchRegions;
                int n = this.elementMatchRegions.length;
                int n3 = 0;
                while (n3 < n) {
                    object2 = nArray[n3];
                    textLayout.setStyle(GamlAccessEntry.getBoldStyle(), object2[0], object2[1]);
                    ++n3;
                }
                object2 = ((TableItem)event.item).getTextBounds(event.index);
                Rectangle rectangle = textLayout.getBounds();
                textLayout.draw(event.gc, object2.x + 1, object2.y + (object2.height - rectangle.height) / 2);
            }
        }
        if (this.lastInCategory) {
            event.gc.setForeground(IGamaColors.GRAY_LABEL.color());
            object = ((TableItem)event.item).getBounds(event.index);
            event.gc.drawLine(Math.max(0, ((Rectangle)object).x - 1), ((Rectangle)object).y + ((Rectangle)object).height - 1, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height - 1);
        }
    }

    public void erase(Event event) {
        event.detail &= 0xFFFFFFEF;
    }

    public int getMatchQuality() {
        return this.matchQuality;
    }
}

