/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.controls;

import com.google.common.base.Objects;
import gama.core.common.interfaces.ItemList;
import gama.dev.DEBUG;
import gama.ui.shared.controls.ParameterExpandItem;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;

public class ParameterExpandBar
extends Composite {
    private ParameterExpandItem[] items = new ParameterExpandItem[4];
    private ParameterExpandItem focusItem;
    private ParameterExpandItem hoverItem;
    private int spacing;
    private int yCurrentScroll;
    private int itemCount;
    private final Listener listener;
    private boolean inDispose;
    final boolean hasClosableToggle;
    final boolean hasPausableToggle;
    private final ItemList underlyingObjects;
    int bandHeight = 20;
    private boolean ignoreMouseUp;

    static {
        DEBUG.OFF();
    }

    public boolean setFocus() {
        return false;
    }

    public ParameterExpandBar(Composite composite, int n) {
        this(composite, n, false, false, null);
    }

    public ParameterExpandBar(Composite composite, int n, boolean bl, boolean bl2, ItemList itemList) {
        super(composite, n | 0x20000000);
        this.hasClosableToggle = bl;
        this.hasPausableToggle = bl2;
        this.underlyingObjects = itemList;
        this.listener = event -> {
            switch (event.type) {
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 35: {
                    this.onContextualMenu(event);
                    break;
                }
                case 3: {
                    if ((event.stateMask & 0x40000) != 0 || event.button == 3) {
                        this.onContextualMenu(event);
                        break;
                    }
                    this.onMouseDown(event);
                    break;
                }
                case 4: {
                    this.onMouseUp(event);
                    break;
                }
                case 9: {
                    this.onPaint(event);
                    break;
                }
                case 11: {
                    this.onResize();
                    break;
                }
                case 15: 
                case 16: {
                    this.onFocus();
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(35, this.listener);
        this.addListener(15, this.listener);
        this.addListener(16, this.listener);
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent mouseEvent) {
                ParameterExpandBar.this.changeHoverTo(null);
            }
        });
        this.addMouseMoveListener(this::onHover);
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.addListener(13, this::onScroll);
        }
    }

    protected void checkSubclass() {
    }

    void createItem(ParameterExpandItem parameterExpandItem, int n, int n2) {
        if (n2 < 0 || n2 > this.itemCount) {
            SWT.error((int)6);
        }
        if (this.itemCount == this.items.length) {
            ParameterExpandItem[] parameterExpandItemArray = new ParameterExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, parameterExpandItemArray, 0, this.items.length);
            this.items = parameterExpandItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount - n2);
        this.items[n2] = parameterExpandItem;
        ++this.itemCount;
        if (this.getFocusItem() == null) {
            this.setFocusItem(parameterExpandItem);
        }
        parameterExpandItem.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(n2, true);
    }

    public void destroyItem(ParameterExpandItem parameterExpandItem) {
        if (this.inDispose) {
            return;
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == parameterExpandItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        if (parameterExpandItem == this.getFocusItem()) {
            int n2;
            int n3 = n2 = n > 0 ? n - 1 : 1;
            if (n2 < this.itemCount) {
                this.setFocusItem(this.items[n2]);
                this.getFocusItem().redraw();
            } else {
                this.setFocusItem(null);
            }
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.underlyingObjects != null) {
            this.underlyingObjects.removeItem(parameterExpandItem.getData());
        }
        this.layoutItems(n, true);
        if (this.isDisposed()) {
            return;
        }
        this.redraw();
        this.update();
    }

    void computeBandHeight() {
        if (this.getFont() == null) {
            return;
        }
        GC gC = new GC((Drawable)this);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        this.bandHeight = Math.max(20, fontMetrics.getHeight());
    }

    public ParameterExpandItem getItem(Object object) {
        ParameterExpandItem[] parameterExpandItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterExpandItem parameterExpandItem = parameterExpandItemArray[n2];
            if (parameterExpandItem != null && Objects.equal((Object)parameterExpandItem.getData(), (Object)object)) {
                return parameterExpandItem;
            }
            ++n2;
        }
        return null;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public ParameterExpandItem[] getItems() {
        ParameterExpandItem[] parameterExpandItemArray = new ParameterExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, parameterExpandItemArray, 0, this.itemCount);
        return parameterExpandItemArray;
    }

    public int indexOf(ParameterExpandItem parameterExpandItem) {
        if (parameterExpandItem == null) {
            SWT.error((int)4);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == parameterExpandItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void layoutItems(int n, boolean bl) {
        if (n < this.itemCount) {
            ParameterExpandItem parameterExpandItem;
            int n2 = this.spacing - this.yCurrentScroll;
            int n3 = 0;
            while (n3 < n) {
                parameterExpandItem = this.items[n3];
                if (parameterExpandItem.expanded) {
                    n2 += parameterExpandItem.height + 2;
                }
                n2 += parameterExpandItem.getHeaderHeight() + this.spacing;
                ++n3;
            }
            n3 = n;
            while (n3 < this.itemCount) {
                parameterExpandItem = this.items[n3];
                parameterExpandItem.setBounds(this.spacing, n2, 0, 0, true, false);
                if (parameterExpandItem.expanded) {
                    n2 += parameterExpandItem.height + 2;
                }
                n2 += parameterExpandItem.getHeaderHeight() + this.spacing;
                ++n3;
            }
        }
        if (bl) {
            this.setScrollbar();
        }
    }

    public void updateItemNames() {
        if (this.underlyingObjects == null) {
            return;
        }
        int n = 0;
        while (n < this.itemCount) {
            this.items[n].setText(this.underlyingObjects.getItemDisplayName(this.items[n].getData(), this.items[n].getText()));
            ++n;
        }
    }

    public void updateItemColors() {
        if (this.underlyingObjects == null) {
            return;
        }
        int n = 0;
        while (n < this.itemCount) {
            this.items[n].setColor((Color)this.underlyingObjects.getItemDisplayColor(this.items[n].getData()));
            ++n;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.computeBandHeight();
        this.layoutItems(0, true);
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar == null) {
            return;
        }
        int n = this.getClientArea().height;
        ParameterExpandItem parameterExpandItem = this.items[this.itemCount - 1];
        int n2 = parameterExpandItem.y + this.bandHeight + this.spacing;
        if (parameterExpandItem.expanded) {
            n2 += parameterExpandItem.height;
        }
        if (this.yCurrentScroll > 0 && n > n2) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n2 - n);
            this.layoutItems(0, false);
        }
        int n3 = Math.min(this.yCurrentScroll, n2 += this.yCurrentScroll);
        int n4 = scrollBar.getIncrement();
        int n5 = scrollBar.getPageIncrement();
        scrollBar.setValues(n3, 0, n2, n, n4, n5);
        scrollBar.setVisible(n2 > n);
    }

    public void setSpacing(int n) {
        if (n < 0 || n == this.spacing) {
            return;
        }
        this.spacing = n;
        int n2 = Math.max(0, this.getClientArea().width - n * 2);
        int n3 = 0;
        while (n3 < this.itemCount) {
            ParameterExpandItem parameterExpandItem = this.items[n3];
            if (parameterExpandItem.width != n2) {
                parameterExpandItem.setBounds(0, 0, n2, parameterExpandItem.height, false, true);
            }
            ++n3;
        }
        this.layoutItems(0, true);
        this.redraw();
    }

    void showItem(ParameterExpandItem parameterExpandItem) {
        Composite composite = parameterExpandItem.control;
        if (composite != null && !composite.isDisposed()) {
            parameterExpandItem.setImage(parameterExpandItem.expanded ? GamaIcon.named("overlays/small.collapse").image() : GamaIcon.named("overlays/small.expand").image());
            composite.setVisible(parameterExpandItem.expanded);
        }
        parameterExpandItem.redraw();
        int n = this.indexOf(parameterExpandItem);
        this.layoutItems(n + 1, true);
        Event event = new Event();
        event.item = this;
        this.notifyListeners(11, event);
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        int n = 0;
        while (n < this.itemCount) {
            this.items[n].dispose();
            ++n;
        }
        this.items = null;
        this.setFocusItem(null);
    }

    void onFocus() {
        if (this.getFocusItem() != null) {
            this.getFocusItem().redraw();
        }
    }

    void onHover(MouseEvent mouseEvent) {
        int n = mouseEvent.x;
        int n2 = mouseEvent.y;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.itemCount) {
            ParameterExpandItem parameterExpandItem = this.items[n3];
            boolean bl2 = bl = parameterExpandItem.x <= n && n < parameterExpandItem.x + parameterExpandItem.width && parameterExpandItem.y <= n2 && n2 < parameterExpandItem.y + this.bandHeight;
            if (bl) {
                this.changeHoverTo(parameterExpandItem);
                return;
            }
            ++n3;
        }
        if (!bl) {
            this.changeHoverTo(null);
        }
    }

    void changeHoverTo(ParameterExpandItem parameterExpandItem) {
        if (this.hoverItem == parameterExpandItem) {
            return;
        }
        ParameterExpandItem parameterExpandItem2 = this.hoverItem;
        this.hoverItem = parameterExpandItem;
        if (parameterExpandItem2 != null) {
            parameterExpandItem2.redraw();
        }
        if (parameterExpandItem != null) {
            parameterExpandItem.redraw();
        }
    }

    void onContextualMenu(Event event2) {
        int n = event2.x;
        int n2 = event2.y;
        int n3 = 0;
        while (n3 < this.itemCount) {
            boolean bl;
            ParameterExpandItem parameterExpandItem = this.items[n3];
            boolean bl2 = bl = parameterExpandItem.x <= n && n < parameterExpandItem.x + parameterExpandItem.width && parameterExpandItem.y <= n2 && n2 < parameterExpandItem.y + this.bandHeight;
            if (bl && this.underlyingObjects != null) {
                this.ignoreMouseUp = true;
                Point point = this.toDisplay(n, n2);
                Map map = this.underlyingObjects.handleMenu(parameterExpandItem.getData(), point.x, point.y);
                if (map == null) {
                    return;
                }
                Menu menu = new Menu((Decorations)this.getShell(), 8);
                for (Map.Entry entry : map.entrySet()) {
                    MenuItem menuItem = new MenuItem(menu, 8);
                    menuItem.setText((String)entry.getKey());
                    menuItem.addListener(13, event -> ((Runnable)entry.getValue()).run());
                }
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (WorkbenchHelper.getDisplay().readAndDispatch()) continue;
                    WorkbenchHelper.getDisplay().sleep();
                }
                menu.dispose();
            }
            ++n3;
        }
    }

    void onMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        int n = event.x;
        int n2 = event.y;
        int n3 = 0;
        while (n3 < this.itemCount) {
            boolean bl;
            ParameterExpandItem parameterExpandItem = this.items[n3];
            boolean bl2 = bl = parameterExpandItem.x <= n && n < parameterExpandItem.x + parameterExpandItem.width && parameterExpandItem.y <= n2 && n2 < parameterExpandItem.y + this.bandHeight;
            if (bl) {
                if (this.hasPausableToggle && parameterExpandItem.pauseRequested(n, n2)) {
                    this.ignoreMouseUp = true;
                    if (parameterExpandItem.isPaused) {
                        if (this.underlyingObjects != null) {
                            this.underlyingObjects.resumeItem(parameterExpandItem.getData());
                        }
                        parameterExpandItem.isPaused = false;
                    } else {
                        if (this.underlyingObjects != null) {
                            this.underlyingObjects.pauseItem(parameterExpandItem.getData());
                        }
                        parameterExpandItem.isPaused = true;
                    }
                    this.showItem(parameterExpandItem);
                    return;
                }
                if (this.hasClosableToggle && parameterExpandItem.closeRequested(n, n2)) {
                    this.ignoreMouseUp = true;
                    parameterExpandItem.dispose();
                    return;
                }
                if (parameterExpandItem != this.getFocusItem()) {
                    if (this.getFocusItem() != null) {
                        this.getFocusItem().redraw();
                    }
                    this.setFocusItem(parameterExpandItem);
                    this.getFocusItem().redraw();
                    this.forceFocus();
                    break;
                }
            }
            ++n3;
        }
    }

    void onMouseUp(Event event) {
        boolean bl;
        if (this.ignoreMouseUp) {
            this.ignoreMouseUp = false;
            return;
        }
        if (event.button != 1 || this.getFocusItem() == null) {
            return;
        }
        int n = event.x;
        int n2 = event.y;
        boolean bl2 = bl = this.getFocusItem().x <= n && n < this.getFocusItem().x + this.getFocusItem().width && this.getFocusItem().y <= n2 && n2 < this.getFocusItem().y + this.bandHeight;
        if (bl) {
            Event event2 = new Event();
            event2.item = this.getFocusItem();
            boolean bl3 = this.getFocusItem().expanded;
            this.getFocusItem().setExpanded(!this.getFocusItem().expanded);
            this.notifyListeners(bl3 ? 18 : 17, event2);
            this.showItem(this.getFocusItem());
            WorkbenchHelper.copy(this.getFocusItem().getText());
        }
    }

    void onPaint(Event event) {
        int n = 0;
        while (n < this.itemCount) {
            ParameterExpandItem parameterExpandItem = this.items[n];
            event.gc.setAlpha(255);
            parameterExpandItem.drawItem(event.gc, parameterExpandItem == this.hoverItem);
            ++n;
        }
    }

    void onResize() {
        WorkbenchHelper.asyncRun(() -> {
            if (this.isDisposed()) {
                return;
            }
            Rectangle rectangle = this.getClientArea();
            int n = Math.max(0, rectangle.width - this.spacing * 2);
            int n2 = 0;
            while (n2 < this.itemCount) {
                ParameterExpandItem parameterExpandItem = this.items[n2];
                if (parameterExpandItem.getControl() != null) {
                    parameterExpandItem.setHeight(parameterExpandItem.getControl().computeSize((int)n, (int)-1).y);
                }
                parameterExpandItem.setBounds(0, 0, n, parameterExpandItem.height, false, true);
                ++n2;
            }
            this.setScrollbar();
        });
    }

    public void onScroll(Event event) {
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            this.yCurrentScroll = scrollBar.getSelection();
            this.layoutItems(0, false);
        }
    }

    void setFocusItem(ParameterExpandItem parameterExpandItem) {
        this.focusItem = parameterExpandItem;
        if (parameterExpandItem != null && this.underlyingObjects != null) {
            this.underlyingObjects.focusItem(parameterExpandItem.getData());
        }
    }

    ParameterExpandItem getFocusItem() {
        return this.focusItem;
    }

    public void collapseItemWithData(Object object) {
        if (object == null) {
            return;
        }
        ParameterExpandItem[] parameterExpandItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterExpandItem parameterExpandItem = parameterExpandItemArray[n2];
            if (object.equals(parameterExpandItem.getData())) {
                parameterExpandItem.setExpanded(false);
                return;
            }
            ++n2;
        }
    }

    public boolean isVisible(ParameterExpandItem parameterExpandItem) {
        return this.underlyingObjects == null ? true : this.underlyingObjects.isItemVisible(parameterExpandItem.getData());
    }
}

