/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.parameters;

import gama.core.common.util.StringUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.PreferencesHelper;
import java.util.EnumSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;

public class EditorLabel
extends Label {
    public static final Color ERROR;
    public static final Color CHANGED;
    public static final Color DARK_ACTIVE;
    public static final Color LIGHT_ACTIVE;
    public static final Color INACTIVE;
    EnumSet<State> states = EnumSet.of(State.active);

    static {
        DEBUG.OFF();
        ERROR = IGamaColors.ERROR.color();
        CHANGED = IGamaColors.TOOLTIP.color();
        DARK_ACTIVE = IGamaColors.VERY_LIGHT_GRAY.color();
        LIGHT_ACTIVE = IGamaColors.BLACK.color();
        INACTIVE = GamaColors.system(15);
    }

    public EditorLabel(AbstractEditor abstractEditor, Composite composite, String string, boolean bl) {
        super(composite, 131136);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(true, false).minSize(40, -1).indent(bl ? 30 : 0, 0).applyTo((Control)this);
        this.setText(string == null ? " " : string);
        this.setToolTipText(this.computeLabelTooltip(abstractEditor));
        this.setColors(composite.getBackground());
    }

    protected String computeLabelTooltip(AbstractEditor abstractEditor) {
        boolean bl = GAMA.getExperiment() != null && GAMA.getExperiment().isBatch();
        IParameter iParameter = abstractEditor.getParam();
        if (iParameter == null) {
            return "";
        }
        boolean bl2 = iParameter.isDefinedInExperiment();
        StringBuilder stringBuilder = new StringBuilder();
        if (iParameter.isEditable()) {
            stringBuilder.append("Parameter of type ").append(iParameter.getType().serializeToGaml(false)).append(" that represents the ");
        } else {
            stringBuilder.append("Read-only ");
        }
        stringBuilder.append("value of " + (bl2 ? "experiment" : "model") + " attribute " + iParameter.getName());
        if (!bl) {
            if (abstractEditor.getMinValue() != null) {
                String string = StringUtils.toGaml(abstractEditor.getMinValue(), (boolean)false);
                if (abstractEditor.getMaxValue() != null) {
                    stringBuilder.append(" [").append(string).append("..").append(StringUtils.toGaml(abstractEditor.getMaxValue(), (boolean)false)).append("]");
                } else {
                    stringBuilder.append(">= ").append(string);
                }
            } else if (abstractEditor.getMaxValue() != null) {
                stringBuilder.append("<=").append(StringUtils.toGaml(abstractEditor.getMaxValue(), (boolean)false));
            }
            if ((abstractEditor.getMinValue() != null || abstractEditor.getMaxValue() != null) && abstractEditor.getStepValue() != null) {
                stringBuilder.append(" every ").append(abstractEditor.getStepValue());
            }
        } else {
            String string = iParameter.getUnitLabel(abstractEditor.getScope());
            if (string != null) {
                stringBuilder.append(" ").append(string);
            }
        }
        return stringBuilder.toString();
    }

    public void signalChanged(boolean bl) {
        if (bl) {
            this.states.add(State.changed);
        } else {
            this.states.remove((Object)State.changed);
        }
        this.reskin();
    }

    public void signalErrored() {
        if (!this.states.contains((Object)State.errored)) {
            this.states.add(State.errored);
            this.reskin();
        }
    }

    public void cancelErrored() {
        if (this.states.contains((Object)State.errored)) {
            this.states.remove((Object)State.errored);
            this.reskin();
        }
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.states.add(State.active);
        } else {
            this.states.remove((Object)State.active);
        }
        this.reskin();
    }

    private void setColors(Color ... colorArray) {
        Color color = colorArray[0];
        if (color == null) {
            color = this.getParent().getBackground();
        }
        this.setBackground(color);
        if (colorArray.length <= 1) {
            Color color2 = color;
            this.setForeground(GamaColors.getTextColorForBackground(color2).color());
        } else {
            this.setForeground(colorArray[1]);
        }
        this.setCSSData();
    }

    private void setCSSData() {
        GamaColors.setBackAndForeground(this.getBackground(), this.getForeground(), new Control[]{this});
    }

    private void reskin() {
        if (this.isDisposed()) {
            return;
        }
        if (this.states.contains((Object)State.errored)) {
            this.setColors(ERROR);
        } else if (this.states.contains((Object)State.changed) && ((Boolean)PreferencesHelper.CORE_EDITORS_HIGHLIGHT.getValue()).booleanValue()) {
            this.setColors(CHANGED);
        } else if (this.states.contains((Object)State.active)) {
            this.setColors(this.getParent().getBackground());
        } else {
            this.setColors(this.getParent().getBackground(), INACTIVE);
        }
    }

    public void setMenu(Menu menu) {
        if (this.isDisposed()) {
            return;
        }
        super.setMenu(menu);
    }

    public void setHorizontalAlignment(int n) {
        if (this.isDisposed()) {
            return;
        }
        ((GridData)this.getLayoutData()).horizontalAlignment = n;
    }

    public Menu createMenu() {
        if (this.isDisposed()) {
            return null;
        }
        return new Menu((Control)this);
    }

    protected void checkSubclass() {
    }

    static enum State {
        active,
        errored,
        changed;

    }
}

