/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.dialogs;

import gama.ui.shared.dialogs.AbstractDetailsDialog;
import gama.ui.shared.utils.WorkbenchHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExceptionDetailsDialog
extends AbstractDetailsDialog {
    private final Object details;

    public ExceptionDetailsDialog(Shell shell, String string, Image image, String string2, Object object) {
        this((IShellProvider)new SameShellProvider((Control)shell), string, image, string2, object);
    }

    private ExceptionDetailsDialog(IShellProvider iShellProvider, String string, Image image, String string2, Object object) {
        super(iShellProvider, ExceptionDetailsDialog.getTitle(string, object), ExceptionDetailsDialog.getImage(image, object), string2);
        this.details = object;
    }

    @Override
    protected Control createDetailsArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createDetailsViewer(composite2);
        return composite2;
    }

    private Control createDetailsViewer(Composite composite) {
        if (this.details == null) {
            return null;
        }
        Text text = new Text(composite, 2826);
        text.setLayoutData((Object)new GridData(1808));
        StringWriter stringWriter = new StringWriter(1000);
        if (this.details instanceof Throwable) {
            ExceptionDetailsDialog.appendException(new PrintWriter(stringWriter), (Throwable)this.details);
        } else if (this.details instanceof IStatus) {
            ExceptionDetailsDialog.appendCommandStatus(new PrintWriter(stringWriter), (IStatus)this.details, 0);
        }
        text.setText(stringWriter.toString());
        return text;
    }

    private static String getTitle(String string, Object object) {
        if (string != null) {
            return string;
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            while (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
            }
            String string2 = throwable.getClass().getName();
            return string2.substring(string2.lastIndexOf(46) + 1);
        }
        return "Exception";
    }

    private static Image getImage(Image image, Object object) {
        if (image != null) {
            return image;
        }
        Display display = WorkbenchHelper.getDisplay();
        if (object instanceof IStatus) {
            switch (((IStatus)object).getSeverity()) {
                case 4: {
                    return display.getSystemImage(1);
                }
                case 2: {
                    return display.getSystemImage(8);
                }
                case 1: {
                    return display.getSystemImage(2);
                }
                case 0: {
                    return null;
                }
            }
        }
        return display.getSystemImage(1);
    }

    private static void appendException(PrintWriter printWriter, Throwable throwable) {
        if (throwable instanceof CoreException) {
            ExceptionDetailsDialog.appendCommandStatus(printWriter, ((CoreException)throwable).getStatus(), 0);
            printWriter.println();
        }
        ExceptionDetailsDialog.appendStackTrace(printWriter, throwable);
        if (throwable instanceof InvocationTargetException) {
            ExceptionDetailsDialog.appendException(printWriter, ((InvocationTargetException)throwable).getTargetException());
        }
    }

    private static void appendCommandStatus(PrintWriter printWriter, IStatus iStatus, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("  ");
            ++n2;
        }
        printWriter.println(iStatus.getMessage());
        IStatus[] iStatusArray = iStatus.getChildren();
        int n3 = 0;
        while (n3 < iStatusArray.length) {
            ExceptionDetailsDialog.appendCommandStatus(printWriter, iStatusArray[n3], n + 1);
            ++n3;
        }
    }

    private static void appendStackTrace(PrintWriter printWriter, Throwable throwable) {
        throwable.printStackTrace(printWriter);
    }
}

