/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.shared.utils;

import gama.core.common.CompositeConsoleListener;
import gama.core.common.interfaces.IConsoleListener;
import gama.core.common.interfaces.IDisplayCreator;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGamaView;
import gama.core.common.interfaces.IGui;
import gama.core.common.interfaces.IRuntimeExceptionHandler;
import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.IOutput;
import gama.core.outputs.InspectDisplayOutput;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.display.AbstractDisplayGraphics;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.IFileMetaDataProvider;
import gama.dev.DEBUG;
import gama.gaml.architecture.user.UserPanelStatement;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.statements.test.CompoundSummary;
import gama.gaml.statements.test.TestExperimentSummary;
import gama.ui.application.workbench.PerspectiveHelper;
import gama.ui.application.workbench.SimulationPerspectiveDescriptor;
import gama.ui.shared.dialogs.Messages;
import gama.ui.shared.interfaces.IDisplayLayoutManager;
import gama.ui.shared.interfaces.IModelRunner;
import gama.ui.shared.interfaces.IRefreshHandler;
import gama.ui.shared.interfaces.ISpeedDisplayer;
import gama.ui.shared.interfaces.IUserDialogFactory;
import gama.ui.shared.parameters.EditorsDialog;
import gama.ui.shared.parameters.GamaWizard;
import gama.ui.shared.parameters.GamaWizardDialog;
import gama.ui.shared.parameters.GamaWizardPage;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.FileOpener;
import gama.ui.shared.utils.PreferencesHelper;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WebHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchWindow;

public class SwtGui
implements IGui {
    public static volatile boolean ALL_TESTS_RUNNING;
    private IAgent highlightedAgent;
    private GamaPoint mouseLocationInModel;
    private GamaPoint mouseLocationInDisplay;
    private final IGamaView.Parameters[] parametersView = new IGamaView.Parameters[1];
    IConsoleListener console;
    static Transfer[] transfers;

    static {
        DEBUG.ON();
        PreferencesHelper.initialize();
        AbstractDisplayGraphics.getCachedGC();
        transfers = new Transfer[]{TextTransfer.getInstance()};
    }

    public boolean confirmClose(IExperimentPlan iExperimentPlan) {
        if (iExperimentPlan == null || !((Boolean)GamaPreferences.Runtime.CORE_ASK_CLOSING.getValue()).booleanValue()) {
            return true;
        }
        PerspectiveHelper.switchToSimulationPerspective();
        return Messages.modalQuestion("Close simulation confirmation", "Do you want to close experiment '" + iExperimentPlan.getName() + "' of model '" + iExperimentPlan.getModel().getName() + "' ?");
    }

    public void openMessageDialog(IScope iScope, String string) {
        Messages.tell(string);
    }

    public void openErrorDialog(IScope iScope, String string) {
        Messages.error(string);
    }

    public void runtimeError(IScope iScope, GamaRuntimeException gamaRuntimeException) {
        if (gamaRuntimeException.isReported() || GAMA.getFrontmostController() != null && GAMA.getFrontmostController().isDisposing()) {
            return;
        }
        IRuntimeExceptionHandler iRuntimeExceptionHandler = this.getRuntimeExceptionHandler();
        if (!iRuntimeExceptionHandler.isRunning()) {
            iRuntimeExceptionHandler.start();
        }
        iRuntimeExceptionHandler.offer(gamaRuntimeException);
        gamaRuntimeException.setReported();
    }

    public void displayErrors(IScope iScope, List<GamaRuntimeException> list, boolean bl) {
        if (list == null) {
            ViewsHelper.hideView("gama.ui.application.view.ErrorView");
        } else {
            IGamaView.Error error = (IGamaView.Error)this.showView(iScope, "gama.ui.application.view.ErrorView", null, 1);
            if (error != null) {
                error.displayErrors(bl);
            }
        }
    }

    public IGamaView.Test openTestView(IScope iScope, boolean bl) {
        ALL_TESTS_RUNNING = bl;
        IGamaView.Test test = (IGamaView.Test)this.showView(iScope, "gama.ui.application.view.TestView", null, 1);
        if (test != null) {
            test.startNewTestSequence(bl);
        }
        return test;
    }

    public void displayTestsProgress(IScope iScope, int n, int n2) {
        IGamaView.Test test = (IGamaView.Test)WorkbenchHelper.getPage().findView("gama.ui.application.view.TestView");
        if (test != null) {
            test.displayProgress(n, n2);
        }
    }

    public void displayTestsResults(IScope iScope, CompoundSummary<?, ?> compoundSummary) {
        IGamaView.Test test = (IGamaView.Test)WorkbenchHelper.getPage().findView("gama.ui.application.view.TestView");
        if (test != null) {
            test.addTestResult(compoundSummary);
        }
    }

    public void endTestDisplay() {
        IGamaView.Test test = (IGamaView.Test)WorkbenchHelper.getPage().findView("gama.ui.application.view.TestView");
        if (test != null) {
            test.finishTestSequence();
        }
        WorkbenchHelper.refreshNavigator();
    }

    public void clearErrors(IScope iScope) {
        IRuntimeExceptionHandler iRuntimeExceptionHandler = this.getRuntimeExceptionHandler();
        iRuntimeExceptionHandler.clearErrors();
    }

    private Object internalShowView(String string, String string2, int n) {
        if (GAMA.getFrontmostController() != null && GAMA.getFrontmostController().isDisposing()) {
            return null;
        }
        Object[] objectArray = new Object[1];
        WorkbenchHelper.run(() -> {
            try {
                IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
                if (iWorkbenchPage != null) {
                    iWorkbenchPage.zoomOut();
                    String string3 = string2 == null ? null : string2 + "@@@" + String.valueOf(System.currentTimeMillis());
                    objectArray[0] = iWorkbenchPage.showView(string, string3, n);
                }
            }
            catch (Exception exception) {
                objectArray[0] = exception;
            }
        });
        return objectArray[0];
    }

    public boolean copyToClipboard(String string) {
        if (WorkbenchHelper.getClipboard() == null || string == null) {
            return false;
        }
        WorkbenchHelper.asyncRun(() -> WorkbenchHelper.getClipboard().setContents((Object[])new String[]{string}, transfers));
        return true;
    }

    public String copyTextFromClipboard() {
        if (WorkbenchHelper.getClipboard() == null) {
            return null;
        }
        return (String)WorkbenchHelper.run(() -> WorkbenchHelper.getClipboard().getContents((Transfer)TextTransfer.getInstance()));
    }

    public void openWebDocumentationPage() {
        WebHelper.openWelcomePage();
    }

    public IGamaView showView(IScope iScope, String string, String string2, int n) {
        Object object = this.internalShowView(string, string2, n);
        if (object instanceof IWorkbenchPart) {
            if (object instanceof IGamaView) {
                return (IGamaView)object;
            }
            object = GamaRuntimeException.error((String)("Impossible to open view " + string), (IScope)iScope);
        }
        if (object instanceof Throwable) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)((Exception)object), (IScope)iScope), (boolean)false);
        }
        return null;
    }

    public final boolean openSimulationPerspective(IModel iModel, String string) {
        return PerspectiveHelper.openSimulationPerspective((IModel)iModel, (String)string);
    }

    public IDisplayCreator.DisplayDescription getDisplayDescriptionFor(String string) {
        return (IDisplayCreator.DisplayDescription)DISPLAYS.get(string);
    }

    public IDisplaySurface createDisplaySurfaceFor(LayeredDisplayOutput layeredDisplayOutput, Object ... objectArray) {
        String string = layeredDisplayOutput.getData().getDisplayType();
        IDisplayCreator.DisplayDescription displayDescription = (IDisplayCreator.DisplayDescription)DISPLAYS.get(string);
        if (displayDescription == null) {
            throw GamaRuntimeException.error((String)("Display " + string + " is not defined anywhere."), (IScope)layeredDisplayOutput.getScope());
        }
        IDisplaySurface iDisplaySurface = displayDescription.create((IOutput)layeredDisplayOutput, objectArray);
        iDisplaySurface.outputReloaded();
        return iDisplaySurface;
    }

    public IDisplaySurface getFrontmostDisplaySurface() {
        return ViewsHelper.frontmostDisplaySurface();
    }

    public Map<String, Object> openUserInputDialog(IScope iScope, String string, List<IParameter> list, GamaFont gamaFont, GamaColor gamaColor, Boolean bl) {
        IMap iMap = GamaMapFactory.createUnordered();
        for (IParameter iParameter : list) {
            iMap.put((Object)iParameter.getName(), iParameter.getInitialValue(iScope));
        }
        WorkbenchHelper.run(() -> {
            EditorsDialog editorsDialog = new EditorsDialog(iScope, null, list, string, gamaFont, gamaColor, bl);
            if (editorsDialog.open() == 0) {
                iMap.putAll(editorsDialog.getValues());
            }
        });
        return iMap;
    }

    public IMap<String, IMap<String, Object>> openWizard(IScope iScope, String string, ActionDescription actionDescription, IList<IMap<String, Object>> iList) {
        IMap iMap = GamaMapFactory.create();
        IList iList2 = GamaListFactory.create();
        for (IMap iMap2 : iList) {
            GamaFont cfr_ignored_0 = (GamaFont)iMap2.get((Object)"font");
            String string2 = (String)iMap2.get((Object)"title");
            String string3 = (String)iMap2.get((Object)"description");
            List list = (List)iMap2.get((Object)"parameters");
            iList2.add((Object)new GamaWizardPage(iScope, list, string2, string3));
        }
        WorkbenchHelper.run(() -> {
            GamaWizard gamaWizard = new GamaWizard(string, actionDescription, (List<GamaWizardPage>)iList2);
            GamaWizardDialog gamaWizardDialog = new GamaWizardDialog(WorkbenchHelper.getShell(), gamaWizard);
            if (gamaWizardDialog.open() == 0) {
                iMap.putAll(gamaWizardDialog.getValues());
            }
        });
        return iMap;
    }

    public Boolean openUserInputDialogConfirm(IScope iScope, String string, String string2) {
        ArrayList arrayList = new ArrayList();
        WorkbenchHelper.run(() -> arrayList.add(Messages.confirm(string, string2)));
        return arrayList.isEmpty() ? false : (Boolean)arrayList.get(0);
    }

    public void openUserControlPanel(IScope iScope, UserPanelStatement userPanelStatement) {
        WorkbenchHelper.run(() -> {
            IGamaView.User user = (IGamaView.User)this.showView(iScope, "gama.ui.application.view.userControlView", null, 3);
            if (user != null) {
                user.initFor(iScope, userPanelStatement);
            }
            iScope.setOnUserHold(true);
            try {
                WorkbenchHelper.getPage().showView("gama.ui.application.view.userControlView");
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        });
    }

    public void closeDialogs(IScope iScope) {
        WorkbenchHelper.run(() -> {
            IUserDialogFactory iUserDialogFactory = WorkbenchHelper.getService(IUserDialogFactory.class);
            if (iUserDialogFactory != null) {
                iUserDialogFactory.closeUserDialog();
            }
            ViewsHelper.hideView("gama.ui.application.view.userControlView");
        });
    }

    public IAgent getHighlightedAgent() {
        return this.highlightedAgent;
    }

    public void setHighlightedAgent(IAgent iAgent) {
        this.highlightedAgent = iAgent;
    }

    private IModelRunner getModelRunner() {
        return WorkbenchHelper.getService(IModelRunner.class);
    }

    public void editModel(Object object) {
        IModelRunner iModelRunner = this.getModelRunner();
        if (iModelRunner == null) {
            return;
        }
        iModelRunner.editModel(object);
    }

    public List<TestExperimentSummary> runHeadlessTests(Object object) {
        IModelRunner iModelRunner = this.getModelRunner();
        if (iModelRunner == null) {
            return null;
        }
        return iModelRunner.runHeadlessTests(object);
    }

    public void updateParameters() {
        WorkbenchHelper.run(() -> {
            boolean bl = GAMA.getExperiment().hasParametersOrUserCommands() && !PerspectiveHelper.isModelingPerspective() && PerspectiveHelper.showParameters();
            this.parametersView[0] = bl ? (IGamaView.Parameters)this.showView(GAMA.getRuntimeScope(), "gama.ui.application.view.ParameterView", null, 1) : (IGamaView.Parameters)ViewsHelper.findView("gama.ui.application.view.ParameterView", null, false);
            if (this.parametersView[0] != null) {
                this.parametersView[0].topLevelAgentChanged(GAMA.getCurrentTopLevelAgent());
                this.parametersView[0].updateItemValues(false);
            }
        });
    }

    public void updateParameterView(IScope iScope) {
        IGamaView.Parameters parameters = this.parametersView[0];
        if (parameters instanceof IGamaView) {
            IGamaView iGamaView = (IGamaView)parameters;
            iGamaView.update(null);
        }
    }

    public void setSelectedAgent(IAgent iAgent) {
        WorkbenchHelper.asyncRun(() -> {
            InspectDisplayOutput inspectDisplayOutput;
            if (WorkbenchHelper.getPage() == null || iAgent == null) {
                return;
            }
            try {
                inspectDisplayOutput = InspectDisplayOutput.inspect((IAgent)iAgent, null);
                inspectDisplayOutput.launch(iAgent.getScope().copy("in Inspector"));
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                gamaRuntimeException.addContext("In opening the agent inspector");
                GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
            }
            inspectDisplayOutput = WorkbenchHelper.getPage().findViewReference("gama.ui.application.view.AgentInspectView", "");
            if (inspectDisplayOutput != null) {
                WorkbenchHelper.getPage().bringToTop(inspectDisplayOutput.getPart(true));
            }
        });
    }

    public void arrangeExperimentViews(IScope iScope, IExperimentPlan iExperimentPlan, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Boolean bl7, Supplier<GamaColor> supplier, boolean bl8) {
        WorkbenchHelper.setWorkbenchWindowTitle(iExperimentPlan.getName() + " - " + iExperimentPlan.getModel().getFilePath());
        WorkbenchHelper.runInUI("Laying out experiment views", 0, iProgressMonitor -> {
            SimulationPerspectiveDescriptor simulationPerspectiveDescriptor;
            WorkbenchHelper.getWindow().updateActionBars();
            ICommandService iCommandService = WorkbenchHelper.getService(ICommandService.class);
            iCommandService.refreshElements("gama.ui.application.commands.SynchronizeExperiment", null);
            WorkbenchHelper.getPage().setEditorAreaVisible(bl8);
            this.getConsole().toggleConsoleViews((ITopLevelAgent)iExperimentPlan.getAgent(), bl3 == null || bl3 != false);
            if (bl5 != null && !bl5.booleanValue()) {
                ViewsHelper.hideView("gama.ui.application.view.GamaNavigator");
            }
            if (bl6 != null) {
                WorkbenchHelper.getWindow().setCoolBarVisible(bl6.booleanValue());
            }
            if (bl7 != null) {
                PerspectiveHelper.showBottomTray((WorkbenchWindow)WorkbenchHelper.getWindow(), (Boolean)bl7);
            }
            if ((simulationPerspectiveDescriptor = PerspectiveHelper.getActiveSimulationPerspective()) != null) {
                simulationPerspectiveDescriptor.showParameters(Boolean.valueOf(bl4 == null || bl4 != false));
                simulationPerspectiveDescriptor.showConsoles(Boolean.valueOf(bl3 == null || bl3 != false));
                simulationPerspectiveDescriptor.keepTabs(bl);
                simulationPerspectiveDescriptor.keepToolbars(bl2);
                simulationPerspectiveDescriptor.keepControls(bl6);
                simulationPerspectiveDescriptor.keepTray(bl7);
                simulationPerspectiveDescriptor.setBackground(() -> SwtGui.lambda$11((Supplier)supplier));
            }
        });
    }

    public void cleanAfterExperiment() {
        this.hideParameters();
        IGamaView iGamaView = (IGamaView)ViewsHelper.findView("gama.ui.application.view.MonitorView", null, false);
        if (iGamaView != null) {
            iGamaView.reset();
            ViewsHelper.hideView("gama.ui.application.view.MonitorView");
        }
        this.getConsole().eraseConsole(true);
        IGamaView iGamaView2 = (IGamaView)ViewsHelper.findView("gama.ui.application.view.InteractiveConsoleView", null, false);
        if (iGamaView2 != null) {
            iGamaView2.reset();
        }
        IRuntimeExceptionHandler iRuntimeExceptionHandler = this.getRuntimeExceptionHandler();
        iRuntimeExceptionHandler.stop();
    }

    public void hideParameters() {
        ViewsHelper.hideView("gama.ui.application.view.ParameterView");
        this.parametersView[0] = null;
    }

    private IRuntimeExceptionHandler getRuntimeExceptionHandler() {
        return WorkbenchHelper.getService(IRuntimeExceptionHandler.class);
    }

    public void runModel(Object object, String string) {
        IModelRunner iModelRunner = this.getModelRunner();
        if (iModelRunner == null) {
            return;
        }
        iModelRunner.runModel(object, string);
    }

    public void updateSpeedDisplay(IScope iScope, Double d, Double d2, boolean bl) {
        ISpeedDisplayer iSpeedDisplayer = WorkbenchHelper.getService(ISpeedDisplayer.class);
        if (iSpeedDisplayer != null) {
            WorkbenchHelper.asyncRun(() -> {
                iSpeedDisplayer.setMaximum(d2);
                iSpeedDisplayer.setInit(d, bl);
            });
        }
    }

    public IFileMetaDataProvider getMetaDataProvider() {
        return WorkbenchHelper.getService(IFileMetaDataProvider.class);
    }

    public void closeSimulationViews(IScope iScope, boolean bl, boolean bl2) {
        WorkbenchHelper.run(() -> {
            IViewReference[] iViewReferenceArray;
            IWorkbenchPage iWorkbenchPage = WorkbenchHelper.getPage();
            IViewReference[] iViewReferenceArray2 = iViewReferenceArray = iWorkbenchPage.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference iViewReference = iViewReferenceArray2[n2];
                IViewPart iViewPart = iViewReference.getView(false);
                if (iViewPart instanceof IGamaView) {
                    ((IGamaView)iViewPart).close(iScope);
                }
                ++n2;
            }
            if (bl) {
                DEBUG.OUT((Object)("Deleting simulation perspective and opening immediately the modeling perspective = " + bl2));
                PerspectiveHelper.deleteCurrentSimulationPerspective();
                PerspectiveHelper.openModelingPerspective((boolean)bl2, (boolean)false);
            }
        });
    }

    public void updateViewTitle(IOutput iOutput, SimulationAgent simulationAgent) {
        WorkbenchHelper.run(() -> {
            IViewPart iViewPart = ViewsHelper.findView(iOutput.getViewId(), iOutput.isUnique() ? null : iOutput.getName(), true);
            if (iViewPart instanceof IGamaView) {
                ((IGamaView)iViewPart).changePartNameWithSimulation(simulationAgent);
            }
        });
    }

    public IStatusDisplayer getStatus() {
        return WorkbenchHelper.getService(IStatusDisplayer.class);
    }

    public IConsoleListener getConsole() {
        if (this.console == null) {
            this.console = new CompositeConsoleListener();
            this.console.addConsoleListener(WorkbenchHelper.getService(IConsoleListener.class));
        }
        return this.console;
    }

    public void run(String string, Runnable runnable, boolean bl) {
        if (bl) {
            WorkbenchHelper.runInUI(string, 0, iProgressMonitor -> runnable.run());
        } else {
            WorkbenchHelper.run(runnable);
        }
    }

    public void setFocusOn(IShape iShape) {
        if (iShape == null) {
            return;
        }
        for (IDisplaySurface iDisplaySurface : ViewsHelper.allDisplaySurfaces()) {
            if (iShape instanceof ITopLevelAgent) {
                iDisplaySurface.zoomFit();
                continue;
            }
            iDisplaySurface.focusOn(iShape);
        }
        GAMA.getExperiment().refreshAllOutputs();
    }

    public void applyLayout(IScope iScope, Object object) {
        IDisplayLayoutManager iDisplayLayoutManager = WorkbenchHelper.getService(IDisplayLayoutManager.class);
        if (iDisplayLayoutManager != null) {
            iDisplayLayoutManager.applyLayout(object);
        }
    }

    public GamaPoint getMouseLocationInModel() {
        return this.mouseLocationInModel;
    }

    public GamaPoint getMouseLocationInDisplay() {
        return this.mouseLocationInDisplay;
    }

    public void setMouseLocationInModel(GamaPoint gamaPoint) {
        this.mouseLocationInModel = gamaPoint;
    }

    public void setMouseLocationInDisplay(GamaPoint gamaPoint) {
        this.mouseLocationInDisplay = gamaPoint;
    }

    public void exit() {
        WorkbenchHelper.close();
    }

    public void refreshNavigator() {
        IRefreshHandler iRefreshHandler = WorkbenchHelper.getService(IRefreshHandler.class);
        if (iRefreshHandler != null) {
            iRefreshHandler.completeRefresh(null);
        }
    }

    public boolean isInDisplayThread() {
        return EventQueue.isDispatchThread() || Display.getCurrent() != null;
    }

    public boolean isHiDPI() {
        int n = WorkbenchHelper.run(() -> WorkbenchHelper.getDisplay().getPrimaryMonitor().getZoom());
        return n > 100;
    }

    public void openFile(URI uRI) {
        FileOpener.openFile(uRI);
    }

    private static /* synthetic */ org.eclipse.swt.graphics.Color lambda$11(Supplier supplier) {
        GamaColor gamaColor = (GamaColor)supplier.get();
        return gamaColor == null ? null : GamaColors.toSwtColor((Color)gamaColor);
    }
}

